/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.shard;

import java.io.IOException;
import java.io.Serializable;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Streamable;
import org.elasticsearch.index.Index;

public class ShardId
implements Serializable,
Streamable {
    private Index index;
    private int shardId;
    private int hashCode;

    private ShardId() {
    }

    public ShardId(String index, int shardId) {
        this(new Index(index), shardId);
    }

    public ShardId(Index index, int shardId) {
        this.index = index;
        this.shardId = shardId;
        this.hashCode = this.computeHashCode();
    }

    public Index index() {
        return this.index;
    }

    public String getIndex() {
        return this.index().name();
    }

    public int id() {
        return this.shardId;
    }

    public int getId() {
        return this.id();
    }

    public String toString() {
        return "[" + this.index.name() + "][" + this.shardId + "]";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        ShardId shardId1 = (ShardId)o;
        return this.shardId == shardId1.shardId && this.index.name().equals(shardId1.index.name());
    }

    public int hashCode() {
        return this.hashCode;
    }

    private int computeHashCode() {
        int result = this.index != null ? this.index.hashCode() : 0;
        result = 31 * result + this.shardId;
        return result;
    }

    public static ShardId readShardId(StreamInput in) throws IOException {
        ShardId shardId = new ShardId();
        shardId.readFrom(in);
        return shardId;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        this.index = Index.readIndexName(in);
        this.shardId = in.readVInt();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        this.index.writeTo(out);
        out.writeVInt(this.shardId);
    }
}

