/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.store.fs;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InterruptedIOException;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.store.LockFactory;
import org.apache.lucene.store.NativeFSLockFactory;
import org.apache.lucene.store.NoLockFactory;
import org.apache.lucene.store.SimpleFSLockFactory;
import org.elasticsearch.common.io.FileSystemUtils;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.settings.IndexSettings;
import org.elasticsearch.index.shard.AbstractIndexShardComponent;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.index.store.DirectoryService;
import org.elasticsearch.index.store.IndexStore;
import org.elasticsearch.index.store.fs.FsIndexStore;

public abstract class FsDirectoryService
extends AbstractIndexShardComponent
implements DirectoryService {
    protected final FsIndexStore indexStore;

    public FsDirectoryService(ShardId shardId, @IndexSettings Settings indexSettings, IndexStore indexStore) {
        super(shardId, indexSettings);
        this.indexStore = (FsIndexStore)indexStore;
    }

    protected LockFactory buildLockFactory() throws IOException {
        String fsLock = this.componentSettings.get("lock", this.componentSettings.get("fs_lock", "native"));
        LockFactory lockFactory = NoLockFactory.getNoLockFactory();
        if (fsLock.equals("native")) {
            lockFactory = new NativeFSLockFactory();
        } else if (fsLock.equals("simple")) {
            lockFactory = new SimpleFSLockFactory();
        } else if (fsLock.equals("none")) {
            lockFactory = NoLockFactory.getNoLockFactory();
        }
        return lockFactory;
    }

    @Override
    public void renameFile(Directory dir, String from, String to) throws IOException {
        File directory = ((FSDirectory)dir).getDirectory();
        File old = new File(directory, from);
        File nu = new File(directory, to);
        if (nu.exists() && !nu.delete()) {
            throw new IOException("Cannot delete " + nu);
        }
        if (!old.exists()) {
            throw new FileNotFoundException("Can't rename from [" + from + "] to [" + to + "], from does not exists");
        }
        boolean renamed = false;
        for (int i = 0; i < 3; ++i) {
            if (old.renameTo(nu)) {
                renamed = true;
                break;
            }
            try {
                Thread.sleep(100L);
                continue;
            }
            catch (InterruptedException e) {
                throw new InterruptedIOException(e.getMessage());
            }
        }
        if (!renamed) {
            throw new IOException("Failed to rename, from [" + from + "], to [" + to + "]");
        }
    }

    @Override
    public void fullDelete(Directory dir) throws IOException {
        FSDirectory fsDirectory = (FSDirectory)dir;
        FileSystemUtils.deleteRecursively(fsDirectory.getDirectory());
        String[] list = fsDirectory.getDirectory().getParentFile().list();
        if (list == null || list.length == 0) {
            FileSystemUtils.deleteRecursively(fsDirectory.getDirectory().getParentFile());
        }
    }
}

