/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.store.ram;

import java.io.FileNotFoundException;
import java.io.IOException;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.RAMDirectory;
import org.apache.lucene.store.RAMFile;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.settings.IndexSettings;
import org.elasticsearch.index.shard.AbstractIndexShardComponent;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.index.store.DirectoryService;

public class RamDirectoryService
extends AbstractIndexShardComponent
implements DirectoryService {
    @Inject
    public RamDirectoryService(ShardId shardId, @IndexSettings Settings indexSettings) {
        super(shardId, indexSettings);
    }

    @Override
    public Directory[] build() {
        return new Directory[]{new CustomRAMDirectory()};
    }

    @Override
    public void renameFile(Directory dir, String from, String to) throws IOException {
        ((CustomRAMDirectory)dir).renameTo(from, to);
    }

    @Override
    public void fullDelete(Directory dir) {
    }

    static class CustomRAMDirectory
    extends RAMDirectory {
        CustomRAMDirectory() {
        }

        public synchronized void renameTo(String from, String to) throws IOException {
            RAMFile fromFile = (RAMFile)this.fileMap.get(from);
            if (fromFile == null) {
                throw new FileNotFoundException(from);
            }
            RAMFile toFile = (RAMFile)this.fileMap.get(to);
            if (toFile != null) {
                this.sizeInBytes.addAndGet(-this.fileLength(from));
                this.fileMap.remove(from);
            }
            this.fileMap.put(to, fromFile);
        }
    }
}

