/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.facet.range;

import java.io.IOException;
import java.util.Map;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.Scorer;
import org.elasticsearch.script.SearchScript;
import org.elasticsearch.search.facet.AbstractFacetCollector;
import org.elasticsearch.search.facet.Facet;
import org.elasticsearch.search.facet.range.InternalRangeFacet;
import org.elasticsearch.search.facet.range.RangeFacet;
import org.elasticsearch.search.internal.SearchContext;

public class ScriptRangeFacetCollector
extends AbstractFacetCollector {
    private final SearchScript keyScript;
    private final SearchScript valueScript;
    private final RangeFacet.Entry[] entries;

    public ScriptRangeFacetCollector(String facetName, String scriptLang, String keyScript, String valueScript, Map<String, Object> params, RangeFacet.Entry[] entries, SearchContext context) {
        super(facetName);
        this.keyScript = context.scriptService().search(context.lookup(), scriptLang, keyScript, params);
        this.valueScript = context.scriptService().search(context.lookup(), scriptLang, valueScript, params);
        this.entries = entries;
    }

    @Override
    public void setScorer(Scorer scorer) throws IOException {
        this.keyScript.setScorer(scorer);
        this.valueScript.setScorer(scorer);
    }

    @Override
    protected void doSetNextReader(IndexReader reader, int docBase) throws IOException {
        this.keyScript.setNextReader(reader);
        this.valueScript.setNextReader(reader);
    }

    @Override
    protected void doCollect(int doc) throws IOException {
        this.keyScript.setNextDocId(doc);
        this.valueScript.setNextDocId(doc);
        double key = this.keyScript.runAsDouble();
        double value = this.valueScript.runAsDouble();
        for (RangeFacet.Entry entry : this.entries) {
            if (!(key >= entry.getFrom()) || !(key < entry.getTo())) continue;
            ++entry.count;
            ++entry.totalCount;
            entry.total += value;
            if (value < entry.min) {
                entry.min = value;
            }
            if (!(value > entry.max)) continue;
            entry.max = value;
        }
    }

    @Override
    public Facet facet() {
        return new InternalRangeFacet(this.facetName, this.entries);
    }
}

