/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.internal;

import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import org.apache.lucene.search.Explanation;
import org.elasticsearch.ElasticSearchParseException;
import org.elasticsearch.common.BytesHolder;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.Unicode;
import org.elasticsearch.common.collect.ImmutableMap;
import org.elasticsearch.common.compress.lzf.LZF;
import org.elasticsearch.common.compress.lzf.LZFDecoder;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Streamable;
import org.elasticsearch.common.lucene.Lucene;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentBuilderString;
import org.elasticsearch.rest.action.support.RestXContentBuilder;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.SearchHitField;
import org.elasticsearch.search.SearchShardTarget;
import org.elasticsearch.search.highlight.HighlightField;
import org.elasticsearch.search.internal.InternalSearchHitField;
import org.elasticsearch.search.internal.InternalSearchHits;
import org.elasticsearch.search.lookup.SourceLookup;

public class InternalSearchHit
implements SearchHit {
    private static final Object[] EMPTY_SORT_VALUES = new Object[0];
    private transient int docId;
    private float score = Float.NEGATIVE_INFINITY;
    private String id;
    private String type;
    private long version = -1L;
    private BytesHolder source;
    private Map<String, SearchHitField> fields = ImmutableMap.of();
    private Map<String, HighlightField> highlightFields = null;
    private Object[] sortValues = EMPTY_SORT_VALUES;
    private String[] matchedFilters = Strings.EMPTY_ARRAY;
    private Explanation explanation;
    @Nullable
    private SearchShardTarget shard;
    private Map<String, Object> sourceAsMap;
    private byte[] sourceAsBytes;

    private InternalSearchHit() {
    }

    public InternalSearchHit(int docId, String id, String type, byte[] source, Map<String, SearchHitField> fields) {
        this.docId = docId;
        this.id = id;
        this.type = type;
        this.source = source == null ? null : new BytesHolder(source);
        this.fields = fields;
    }

    public int docId() {
        return this.docId;
    }

    public void shardTarget(SearchShardTarget shardTarget) {
        this.shard = shardTarget;
    }

    public void score(float score) {
        this.score = score;
    }

    @Override
    public float score() {
        return this.score;
    }

    @Override
    public float getScore() {
        return this.score();
    }

    public void version(long version) {
        this.version = version;
    }

    @Override
    public long version() {
        return this.version;
    }

    @Override
    public long getVersion() {
        return this.version;
    }

    @Override
    public String index() {
        return this.shard.index();
    }

    @Override
    public String getIndex() {
        return this.index();
    }

    @Override
    public String id() {
        return this.id;
    }

    @Override
    public String getId() {
        return this.id();
    }

    @Override
    public String type() {
        return this.type;
    }

    @Override
    public String getType() {
        return this.type();
    }

    @Override
    public BytesHolder sourceRef() {
        if (LZF.isCompressed(this.source.bytes(), this.source.offset(), this.source.length())) {
            try {
                this.source = new BytesHolder(LZFDecoder.decode(this.source.bytes(), this.source.offset(), this.source.length()));
            }
            catch (IOException e) {
                throw new ElasticSearchParseException("failed to decompress source", e);
            }
        }
        return this.source;
    }

    public BytesHolder internalSourceRef() {
        return this.source;
    }

    @Override
    public byte[] source() {
        if (this.source == null) {
            return null;
        }
        if (this.sourceAsBytes != null) {
            return this.sourceAsBytes;
        }
        this.sourceAsBytes = this.sourceRef().copyBytes();
        return this.sourceAsBytes;
    }

    @Override
    public boolean isSourceEmpty() {
        return this.source == null;
    }

    @Override
    public Map<String, Object> getSource() {
        return this.sourceAsMap();
    }

    @Override
    public String sourceAsString() {
        if (this.source == null) {
            return null;
        }
        BytesHolder source = this.sourceRef();
        return Unicode.fromBytes(source.bytes(), source.offset(), source.length());
    }

    @Override
    public Map<String, Object> sourceAsMap() throws ElasticSearchParseException {
        if (this.source == null) {
            return null;
        }
        if (this.sourceAsMap != null) {
            return this.sourceAsMap;
        }
        this.sourceAsMap = SourceLookup.sourceAsMap(this.source.bytes(), this.source.offset(), this.source.length());
        return this.sourceAsMap;
    }

    @Override
    public Iterator<SearchHitField> iterator() {
        return this.fields.values().iterator();
    }

    @Override
    public SearchHitField field(String fieldName) {
        return this.fields().get(fieldName);
    }

    @Override
    public Map<String, SearchHitField> fields() {
        if (this.fields == null) {
            return ImmutableMap.of();
        }
        return this.fields;
    }

    public Map<String, SearchHitField> fieldsOrNull() {
        return this.fields;
    }

    @Override
    public Map<String, SearchHitField> getFields() {
        return this.fields();
    }

    public void fields(Map<String, SearchHitField> fields) {
        this.fields = fields;
    }

    public Map<String, HighlightField> internalHighlightFields() {
        return this.highlightFields;
    }

    @Override
    public Map<String, HighlightField> highlightFields() {
        if (this.highlightFields == null) {
            return ImmutableMap.of();
        }
        return this.highlightFields;
    }

    @Override
    public Map<String, HighlightField> getHighlightFields() {
        return this.highlightFields();
    }

    public void highlightFields(Map<String, HighlightField> highlightFields) {
        this.highlightFields = highlightFields;
    }

    public void sortValues(Object[] sortValues) {
        this.sortValues = sortValues;
    }

    @Override
    public Object[] sortValues() {
        return this.sortValues;
    }

    @Override
    public Object[] getSortValues() {
        return this.sortValues();
    }

    @Override
    public Explanation explanation() {
        return this.explanation;
    }

    @Override
    public Explanation getExplanation() {
        return this.explanation();
    }

    public void explanation(Explanation explanation) {
        this.explanation = explanation;
    }

    @Override
    public SearchShardTarget shard() {
        return this.shard;
    }

    @Override
    public SearchShardTarget getShard() {
        return this.shard();
    }

    public void shard(SearchShardTarget target) {
        this.shard = target;
    }

    public void matchedFilters(String[] matchedFilters) {
        this.matchedFilters = matchedFilters;
    }

    @Override
    public String[] matchedFilters() {
        return this.matchedFilters;
    }

    @Override
    public String[] getMatchedFilters() {
        return this.matchedFilters;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        if (this.explanation() != null) {
            builder.field("_shard", this.shard.shardId());
            builder.field("_node", this.shard.nodeId());
        }
        builder.field(Fields._INDEX, this.shard.index());
        builder.field(Fields._TYPE, this.type);
        builder.field(Fields._ID, this.id);
        if (this.version != -1L) {
            builder.field(Fields._VERSION, this.version);
        }
        if (Float.isNaN(this.score)) {
            builder.nullField(Fields._SCORE);
        } else {
            builder.field(Fields._SCORE, this.score);
        }
        if (this.source != null) {
            RestXContentBuilder.restDocumentSource(this.source.bytes(), this.source.offset(), this.source.length(), builder, params);
        }
        if (this.fields != null && !this.fields.isEmpty()) {
            builder.startObject(Fields.FIELDS);
            for (SearchHitField searchHitField : this.fields.values()) {
                if (searchHitField.values().isEmpty()) continue;
                if (searchHitField.values().size() == 1) {
                    builder.field(searchHitField.name(), searchHitField.values().get(0));
                    continue;
                }
                builder.field(searchHitField.name());
                builder.startArray();
                for (Object value : searchHitField.values()) {
                    builder.value(value);
                }
                builder.endArray();
            }
            builder.endObject();
        }
        if (this.highlightFields != null && !this.highlightFields.isEmpty()) {
            builder.startObject(Fields.HIGHLIGHT);
            for (HighlightField highlightField : this.highlightFields.values()) {
                builder.field(highlightField.name());
                if (highlightField.fragments() == null) {
                    builder.nullValue();
                    continue;
                }
                builder.startArray();
                for (String fragment : highlightField.fragments()) {
                    builder.value(fragment);
                }
                builder.endArray();
            }
            builder.endObject();
        }
        if (this.sortValues != null && this.sortValues.length > 0) {
            builder.startArray(Fields.SORT);
            for (Object sortValue : this.sortValues) {
                builder.value(sortValue);
            }
            builder.endArray();
        }
        if (this.matchedFilters.length > 0) {
            builder.startArray(Fields.MATCH_FILTERS);
            for (String matchedFilter : this.matchedFilters) {
                builder.value(matchedFilter);
            }
            builder.endArray();
        }
        if (this.explanation() != null) {
            builder.field(Fields._EXPLANATION);
            this.buildExplanation(builder, this.explanation());
        }
        builder.endObject();
        return builder;
    }

    private void buildExplanation(XContentBuilder builder, Explanation explanation) throws IOException {
        builder.startObject();
        builder.field(Fields.VALUE, explanation.getValue());
        builder.field(Fields.DESCRIPTION, explanation.getDescription());
        Explanation[] innerExps = explanation.getDetails();
        if (innerExps != null) {
            builder.startArray(Fields.DETAILS);
            for (Explanation exp : innerExps) {
                this.buildExplanation(builder, exp);
            }
            builder.endArray();
        }
        builder.endObject();
    }

    public static InternalSearchHit readSearchHit(StreamInput in, InternalSearchHits.StreamContext context) throws IOException {
        InternalSearchHit hit = new InternalSearchHit();
        hit.readFrom(in, context);
        return hit;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        this.readFrom(in, InternalSearchHits.streamContext().streamShardTarget(InternalSearchHits.StreamContext.ShardTargetType.STREAM));
    }

    public void readFrom(StreamInput in, InternalSearchHits.StreamContext context) throws IOException {
        int lookupId;
        HighlightField field3;
        HighlightField field1;
        ImmutableMap.Builder<String, Streamable> builder;
        InternalSearchHitField hitField4;
        InternalSearchHitField hitField3;
        InternalSearchHitField hitField1;
        int size;
        this.score = in.readFloat();
        this.id = in.readUTF();
        this.type = in.readUTF();
        this.version = in.readLong();
        this.source = in.readBytesReference();
        if (this.source.length() == 0) {
            this.source = null;
        }
        if (in.readBoolean()) {
            this.explanation = Lucene.readExplanation(in);
        }
        if ((size = in.readVInt()) == 0) {
            this.fields = ImmutableMap.of();
        } else if (size == 1) {
            InternalSearchHitField hitField = InternalSearchHitField.readSearchHitField(in);
            this.fields = ImmutableMap.of(hitField.name(), hitField);
        } else if (size == 2) {
            hitField1 = InternalSearchHitField.readSearchHitField(in);
            InternalSearchHitField hitField2 = InternalSearchHitField.readSearchHitField(in);
            this.fields = ImmutableMap.of(hitField1.name(), hitField1, hitField2.name(), hitField2);
        } else if (size == 3) {
            hitField1 = InternalSearchHitField.readSearchHitField(in);
            InternalSearchHitField hitField2 = InternalSearchHitField.readSearchHitField(in);
            hitField3 = InternalSearchHitField.readSearchHitField(in);
            this.fields = ImmutableMap.of(hitField1.name(), hitField1, hitField2.name(), hitField2, hitField3.name(), hitField3);
        } else if (size == 4) {
            hitField1 = InternalSearchHitField.readSearchHitField(in);
            InternalSearchHitField hitField2 = InternalSearchHitField.readSearchHitField(in);
            hitField3 = InternalSearchHitField.readSearchHitField(in);
            hitField4 = InternalSearchHitField.readSearchHitField(in);
            this.fields = ImmutableMap.of(hitField1.name(), hitField1, hitField2.name(), hitField2, hitField3.name(), hitField3, hitField4.name(), hitField4);
        } else if (size == 5) {
            hitField1 = InternalSearchHitField.readSearchHitField(in);
            InternalSearchHitField hitField2 = InternalSearchHitField.readSearchHitField(in);
            hitField3 = InternalSearchHitField.readSearchHitField(in);
            hitField4 = InternalSearchHitField.readSearchHitField(in);
            InternalSearchHitField hitField5 = InternalSearchHitField.readSearchHitField(in);
            this.fields = ImmutableMap.of(hitField1.name(), hitField1, hitField2.name(), hitField2, hitField3.name(), hitField3, hitField4.name(), hitField4, hitField5.name(), hitField5);
        } else {
            builder = ImmutableMap.builder();
            for (int i = 0; i < size; ++i) {
                InternalSearchHitField hitField = InternalSearchHitField.readSearchHitField(in);
                builder.put(hitField.name(), hitField);
            }
            this.fields = builder.build();
        }
        size = in.readVInt();
        if (size == 0) {
            this.highlightFields = ImmutableMap.of();
        } else if (size == 1) {
            HighlightField field = HighlightField.readHighlightField(in);
            this.highlightFields = ImmutableMap.of(field.name(), field);
        } else if (size == 2) {
            field1 = HighlightField.readHighlightField(in);
            HighlightField field2 = HighlightField.readHighlightField(in);
            this.highlightFields = ImmutableMap.of(field1.name(), field1, field2.name(), field2);
        } else if (size == 3) {
            field1 = HighlightField.readHighlightField(in);
            HighlightField field2 = HighlightField.readHighlightField(in);
            field3 = HighlightField.readHighlightField(in);
            this.highlightFields = ImmutableMap.of(field1.name(), field1, field2.name(), field2, field3.name(), field3);
        } else if (size == 4) {
            field1 = HighlightField.readHighlightField(in);
            HighlightField field2 = HighlightField.readHighlightField(in);
            field3 = HighlightField.readHighlightField(in);
            HighlightField field4 = HighlightField.readHighlightField(in);
            this.highlightFields = ImmutableMap.of(field1.name(), field1, field2.name(), field2, field3.name(), field3, field4.name(), field4);
        } else {
            builder = ImmutableMap.builder();
            for (int i = 0; i < size; ++i) {
                HighlightField field = HighlightField.readHighlightField(in);
                builder.put(field.name(), field);
            }
            this.highlightFields = builder.build();
        }
        size = in.readVInt();
        if (size > 0) {
            this.sortValues = new Object[size];
            for (int i = 0; i < this.sortValues.length; ++i) {
                byte type = in.readByte();
                if (type == 0) {
                    this.sortValues[i] = null;
                    continue;
                }
                if (type == 1) {
                    this.sortValues[i] = in.readUTF();
                    continue;
                }
                if (type == 2) {
                    this.sortValues[i] = in.readInt();
                    continue;
                }
                if (type == 3) {
                    this.sortValues[i] = in.readLong();
                    continue;
                }
                if (type == 4) {
                    this.sortValues[i] = Float.valueOf(in.readFloat());
                    continue;
                }
                if (type == 5) {
                    this.sortValues[i] = in.readDouble();
                    continue;
                }
                if (type == 6) {
                    this.sortValues[i] = in.readByte();
                    continue;
                }
                if (type == 7) {
                    this.sortValues[i] = in.readShort();
                    continue;
                }
                if (type == 8) {
                    this.sortValues[i] = in.readBoolean();
                    continue;
                }
                throw new IOException("Can't match type [" + type + "]");
            }
        }
        if ((size = in.readVInt()) > 0) {
            this.matchedFilters = new String[size];
            for (int i = 0; i < size; ++i) {
                this.matchedFilters[i] = in.readUTF();
            }
        }
        if (context.streamShardTarget() == InternalSearchHits.StreamContext.ShardTargetType.STREAM) {
            if (in.readBoolean()) {
                this.shard = SearchShardTarget.readSearchShardTarget(in);
            }
        } else if (context.streamShardTarget() == InternalSearchHits.StreamContext.ShardTargetType.LOOKUP && (lookupId = in.readVInt()) > 0) {
            this.shard = context.handleShardLookup().get(lookupId);
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        this.writeTo(out, InternalSearchHits.streamContext().streamShardTarget(InternalSearchHits.StreamContext.ShardTargetType.STREAM));
    }

    public void writeTo(StreamOutput out, InternalSearchHits.StreamContext context) throws IOException {
        out.writeFloat(this.score);
        out.writeUTF(this.id);
        out.writeUTF(this.type);
        out.writeLong(this.version);
        out.writeBytesHolder(this.source);
        if (this.explanation == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            Lucene.writeExplanation(out, this.explanation);
        }
        if (this.fields == null) {
            out.writeVInt(0);
        } else {
            out.writeVInt(this.fields.size());
            for (SearchHitField hitField : this.fields().values()) {
                hitField.writeTo(out);
            }
        }
        if (this.highlightFields == null) {
            out.writeVInt(0);
        } else {
            out.writeVInt(this.highlightFields.size());
            for (HighlightField highlightField : this.highlightFields.values()) {
                highlightField.writeTo(out);
            }
        }
        if (this.sortValues.length == 0) {
            out.writeVInt(0);
        } else {
            out.writeVInt(this.sortValues.length);
            for (Object sortValue : this.sortValues) {
                if (sortValue == null) {
                    out.writeByte((byte)0);
                    continue;
                }
                Class<?> type = sortValue.getClass();
                if (type == String.class) {
                    out.writeByte((byte)1);
                    out.writeUTF((String)sortValue);
                    continue;
                }
                if (type == Integer.class) {
                    out.writeByte((byte)2);
                    out.writeInt((Integer)sortValue);
                    continue;
                }
                if (type == Long.class) {
                    out.writeByte((byte)3);
                    out.writeLong((Long)sortValue);
                    continue;
                }
                if (type == Float.class) {
                    out.writeByte((byte)4);
                    out.writeFloat(((Float)sortValue).floatValue());
                    continue;
                }
                if (type == Double.class) {
                    out.writeByte((byte)5);
                    out.writeDouble((Double)sortValue);
                    continue;
                }
                if (type == Byte.class) {
                    out.writeByte((byte)6);
                    out.writeByte((Byte)sortValue);
                    continue;
                }
                if (type == Short.class) {
                    out.writeByte((byte)7);
                    out.writeShort((Short)sortValue);
                    continue;
                }
                if (type == Boolean.class) {
                    out.writeByte((byte)8);
                    out.writeBoolean((Boolean)sortValue);
                    continue;
                }
                throw new IOException("Can't handle sort field value of type [" + type + "]");
            }
        }
        if (this.matchedFilters.length == 0) {
            out.writeVInt(0);
        } else {
            out.writeVInt(this.matchedFilters.length);
            for (String matchedFilter : this.matchedFilters) {
                out.writeUTF(matchedFilter);
            }
        }
        if (context.streamShardTarget() == InternalSearchHits.StreamContext.ShardTargetType.STREAM) {
            if (this.shard == null) {
                out.writeBoolean(false);
            } else {
                out.writeBoolean(true);
                this.shard.writeTo(out);
            }
        } else if (context.streamShardTarget() == InternalSearchHits.StreamContext.ShardTargetType.LOOKUP) {
            if (this.shard == null) {
                out.writeVInt(0);
            } else {
                out.writeVInt(context.shardHandleLookup().get(this.shard));
            }
        }
    }

    public static class Fields {
        static final XContentBuilderString _INDEX = new XContentBuilderString("_index");
        static final XContentBuilderString _TYPE = new XContentBuilderString("_type");
        static final XContentBuilderString _ID = new XContentBuilderString("_id");
        static final XContentBuilderString _VERSION = new XContentBuilderString("_version");
        static final XContentBuilderString _SCORE = new XContentBuilderString("_score");
        static final XContentBuilderString FIELDS = new XContentBuilderString("fields");
        static final XContentBuilderString HIGHLIGHT = new XContentBuilderString("highlight");
        static final XContentBuilderString SORT = new XContentBuilderString("sort");
        static final XContentBuilderString MATCH_FILTERS = new XContentBuilderString("matched_filters");
        static final XContentBuilderString _EXPLANATION = new XContentBuilderString("_explanation");
        static final XContentBuilderString VALUE = new XContentBuilderString("value");
        static final XContentBuilderString DESCRIPTION = new XContentBuilderString("description");
        static final XContentBuilderString DETAILS = new XContentBuilderString("details");
    }
}

