/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.threadpool;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Streamable;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentBuilderString;

public class ThreadPoolStats
implements Streamable,
ToXContent,
Iterable<Stats> {
    private List<Stats> stats;

    ThreadPoolStats() {
    }

    public ThreadPoolStats(List<Stats> stats) {
        this.stats = stats;
    }

    @Override
    public Iterator<Stats> iterator() {
        return this.stats.iterator();
    }

    public static ThreadPoolStats readThreadPoolStats(StreamInput in) throws IOException {
        ThreadPoolStats stats = new ThreadPoolStats();
        stats.readFrom(in);
        return stats;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        int size = in.readVInt();
        this.stats = new ArrayList<Stats>(size);
        for (int i = 0; i < size; ++i) {
            Stats stats1 = new Stats();
            stats1.readFrom(in);
            this.stats.add(stats1);
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeVInt(this.stats.size());
        for (Stats stat : this.stats) {
            stat.writeTo(out);
        }
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject(Fields.THREAD_POOL);
        for (Stats stat : this.stats) {
            stat.toXContent(builder, params);
        }
        builder.endObject();
        return builder;
    }

    static final class Fields {
        static final XContentBuilderString THREAD_POOL = new XContentBuilderString("thread_pool");
        static final XContentBuilderString THREADS = new XContentBuilderString("threads");
        static final XContentBuilderString QUEUE = new XContentBuilderString("queue");
        static final XContentBuilderString ACTIVE = new XContentBuilderString("active");

        Fields() {
        }
    }

    public static class Stats
    implements Streamable,
    ToXContent {
        private String name;
        private int threads;
        private int queue;
        private int active;

        Stats() {
        }

        public Stats(String name, int threads, int queue, int active) {
            this.name = name;
            this.threads = threads;
            this.queue = queue;
            this.active = active;
        }

        public String name() {
            return this.name;
        }

        public String getName() {
            return this.name;
        }

        public int threads() {
            return this.threads;
        }

        public int getThreads() {
            return this.threads;
        }

        public int queue() {
            return this.queue;
        }

        public int getQueue() {
            return this.queue;
        }

        public int active() {
            return this.active;
        }

        public int getActive() {
            return this.active;
        }

        @Override
        public void readFrom(StreamInput in) throws IOException {
            this.name = in.readUTF();
            this.threads = in.readInt();
            this.queue = in.readInt();
            this.active = in.readInt();
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeUTF(this.name);
            out.writeInt(this.threads);
            out.writeInt(this.queue);
            out.writeInt(this.active);
        }

        @Override
        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject(this.name, XContentBuilder.FieldCaseConversion.NONE);
            if (this.threads != -1) {
                builder.field(Fields.THREADS, this.threads);
            }
            if (this.queue != -1) {
                builder.field(Fields.QUEUE, this.queue);
            }
            if (this.active != -1) {
                builder.field(Fields.ACTIVE, this.active);
            }
            builder.endObject();
            return builder;
        }
    }
}

