/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.transport;

import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.elasticsearch.ElasticSearchException;
import org.elasticsearch.ElasticSearchInterruptedException;
import org.elasticsearch.ElasticSearchTimeoutException;
import org.elasticsearch.common.io.stream.Streamable;
import org.elasticsearch.common.util.concurrent.BaseFuture;
import org.elasticsearch.transport.TransportException;
import org.elasticsearch.transport.TransportFuture;
import org.elasticsearch.transport.TransportResponseHandler;

public class PlainTransportFuture<V extends Streamable>
extends BaseFuture<V>
implements TransportFuture<V>,
TransportResponseHandler<V> {
    private final TransportResponseHandler<V> handler;

    public PlainTransportFuture(TransportResponseHandler<V> handler) {
        this.handler = handler;
    }

    @Override
    public V txGet() throws ElasticSearchException {
        try {
            return (V)((Streamable)this.get());
        }
        catch (InterruptedException e) {
            throw new ElasticSearchInterruptedException(e.getMessage());
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof ElasticSearchException) {
                throw (ElasticSearchException)e.getCause();
            }
            throw new TransportException("Failed execution", e);
        }
    }

    @Override
    public V txGet(long timeout, TimeUnit unit) throws ElasticSearchException {
        try {
            return (V)((Streamable)this.get(timeout, unit));
        }
        catch (TimeoutException e) {
            throw new ElasticSearchTimeoutException(e.getMessage());
        }
        catch (InterruptedException e) {
            throw new ElasticSearchInterruptedException(e.getMessage());
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof ElasticSearchException) {
                throw (ElasticSearchException)e.getCause();
            }
            throw new TransportException("Failed execution", e);
        }
    }

    @Override
    public V newInstance() {
        return this.handler.newInstance();
    }

    @Override
    public String executor() {
        return this.handler.executor();
    }

    @Override
    public void handleResponse(V response) {
        this.handler.handleResponse(response);
        this.set(response);
    }

    @Override
    public void handleException(TransportException exp) {
        this.handler.handleException(exp);
        this.setException(exp);
    }

    public String toString() {
        return "future(" + this.handler.toString() + ")";
    }
}

