/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.shell.osgi;

import org.apache.felix.gogo.commands.Argument;
import org.apache.felix.gogo.commands.Command;
import org.apache.karaf.shell.osgi.BundleCommand;
import org.osgi.framework.Bundle;
import org.osgi.framework.ServiceReference;
import org.osgi.service.startlevel.StartLevel;

@Command(scope="osgi", name="bundle-level", description="Gets or sets the start level of a given bundle.")
public class BundleLevel
extends BundleCommand {
    @Argument(index=1, name="startLevel", description="The bundle's new start level", required=false, multiValued=false)
    Integer level;

    protected void doExecute(Bundle bundle) throws Exception {
        ServiceReference ref = this.getBundleContext().getServiceReference(StartLevel.class.getName());
        if (ref == null) {
            System.out.println("StartLevel service is unavailable.");
            return;
        }
        StartLevel sl = (StartLevel)this.getService(StartLevel.class, ref);
        if (sl == null) {
            System.out.println("StartLevel service is unavailable.");
            return;
        }
        if (this.level == null) {
            System.out.println("Level " + sl.getBundleStartLevel(bundle));
        } else if (this.level < 50 && sl.getBundleStartLevel(bundle) > 50 && !this.force) {
            String str;
            do {
                int c;
                StringBuffer sb = new StringBuffer();
                System.err.println("You are about to designate bundle as a system bundle.  Do you wish to continue (yes/no): ");
                System.err.flush();
                while ((c = this.session.getKeyboard().read()) >= 0) {
                    if (c == 13 || c == 10) {
                        System.err.println();
                        System.err.flush();
                        break;
                    }
                    if (c == 127 || c == 98) {
                        System.err.print('\b');
                        System.err.print(' ');
                        System.err.print('\b');
                    } else {
                        System.err.print((char)c);
                    }
                    System.err.flush();
                    if (c == 127 || c == 98) {
                        if (sb.length() <= 0) continue;
                        sb.deleteCharAt(sb.length() - 1);
                        continue;
                    }
                    sb.append((char)c);
                }
                if (!"yes".equals(str = sb.toString())) continue;
                sl.setBundleStartLevel(bundle, this.level.intValue());
                break;
            } while (!"no".equals(str));
        } else {
            sl.setBundleStartLevel(bundle, this.level.intValue());
        }
    }
}

