/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.compute.config;

import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Objects;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.inject.AbstractModule;
import com.google.inject.Provides;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.collect.TransformingSetSupplier;
import org.jclouds.compute.ComputeServiceAdapter;
import org.jclouds.compute.config.BaseComputeServiceContextModule;
import org.jclouds.compute.domain.Hardware;
import org.jclouds.compute.domain.Image;
import org.jclouds.compute.domain.ImageBuilder;
import org.jclouds.compute.strategy.CreateNodeWithGroupEncodedIntoName;
import org.jclouds.compute.strategy.DestroyNodeStrategy;
import org.jclouds.compute.strategy.GetImageStrategy;
import org.jclouds.compute.strategy.GetNodeMetadataStrategy;
import org.jclouds.compute.strategy.ListNodesStrategy;
import org.jclouds.compute.strategy.PopulateDefaultLoginCredentialsForImageStrategy;
import org.jclouds.compute.strategy.RebootNodeStrategy;
import org.jclouds.compute.strategy.ResumeNodeStrategy;
import org.jclouds.compute.strategy.SuspendNodeStrategy;
import org.jclouds.compute.strategy.impl.AdaptingComputeServiceStrategies;
import org.jclouds.domain.Location;
import org.jclouds.domain.LoginCredentials;
import org.jclouds.location.suppliers.LocationsSupplier;

public class ComputeServiceAdapterContextModule<N, H, I, L>
extends BaseComputeServiceContextModule {
    @Provides
    @Singleton
    protected Supplier<Set<? extends Hardware>> provideHardware(final ComputeServiceAdapter<N, H, I, L> adapter, Function<H, Hardware> transformer) {
        return new TransformingSetSupplier(new Supplier<Iterable<H>>(){

            public Iterable<H> get() {
                return adapter.listHardwareProfiles();
            }

            public String toString() {
                return Objects.toStringHelper((Object)adapter).add("method", (Object)"listHardwareProfiles").toString();
            }
        }, transformer);
    }

    @Provides
    @Singleton
    protected Supplier<Set<? extends Image>> provideImages(final ComputeServiceAdapter<N, H, I, L> adapter, Function<I, Image> transformer, AddDefaultCredentialsToImage addDefaultCredentialsToImage) {
        return new TransformingSetSupplier(new Supplier<Iterable<I>>(){

            public Iterable<I> get() {
                return Iterables.filter(adapter.listImages(), (Predicate)Predicates.notNull());
            }

            public String toString() {
                return Objects.toStringHelper((Object)adapter).add("method", (Object)"listImages").toString();
            }
        }, Functions.compose((Function)addDefaultCredentialsToImage, transformer));
    }

    @Provides
    @Singleton
    protected CreateNodeWithGroupEncodedIntoName defineAddNodeWithTagStrategy(AdaptingComputeServiceStrategies<N, H, I, L> in) {
        return in;
    }

    @Provides
    @Singleton
    protected DestroyNodeStrategy defineDestroyNodeStrategy(AdaptingComputeServiceStrategies<N, H, I, L> in) {
        return in;
    }

    @Provides
    @Singleton
    protected GetNodeMetadataStrategy defineGetNodeMetadataStrategy(AdaptingComputeServiceStrategies<N, H, I, L> in) {
        return in;
    }

    @Provides
    @Singleton
    protected GetImageStrategy defineGetImageStrategy(AdaptingComputeServiceStrategies<N, H, I, L> in) {
        return in;
    }

    @Provides
    @Singleton
    protected ListNodesStrategy defineListNodesStrategy(AdaptingComputeServiceStrategies<N, H, I, L> in) {
        return in;
    }

    @Provides
    @Singleton
    protected RebootNodeStrategy defineRebootNodeStrategy(AdaptingComputeServiceStrategies<N, H, I, L> in) {
        return in;
    }

    @Provides
    @Singleton
    protected ResumeNodeStrategy defineStartNodeStrategy(AdaptingComputeServiceStrategies<N, H, I, L> in) {
        return in;
    }

    @Provides
    @Singleton
    protected SuspendNodeStrategy defineStopNodeStrategy(AdaptingComputeServiceStrategies<N, H, I, L> in) {
        return in;
    }

    @Singleton
    public static class AddDefaultCredentialsToImage
    implements Function<Image, Image> {
        private final PopulateDefaultLoginCredentialsForImageStrategy credsForImage;

        @Inject
        public AddDefaultCredentialsToImage(PopulateDefaultLoginCredentialsForImageStrategy credsForImage) {
            this.credsForImage = credsForImage;
        }

        public Image apply(Image arg0) {
            if (arg0 == null) {
                return null;
            }
            LoginCredentials credentials = this.credsForImage.apply(arg0);
            return credentials != null ? ImageBuilder.fromImage(arg0).defaultCredentials(credentials).build() : arg0;
        }

        public String toString() {
            return Objects.toStringHelper((Object)this).add("credsForImage", (Object)this.credsForImage).toString();
        }
    }

    public static class LocationsFromComputeServiceAdapterModule<N, H, I, L>
    extends AbstractModule {
        protected void configure() {
        }

        @Provides
        @Singleton
        protected LocationsSupplier supplyLocationsFromComputeServiceAdapter(final ComputeServiceAdapter<N, H, I, L> adapter, final Function<L, Location> transformer) {
            return new LocationsSupplier(){

                public Set<? extends Location> get() {
                    Iterable locations = Iterables.filter(adapter.listLocations(), (Predicate)Predicates.notNull());
                    return ImmutableSet.copyOf((Iterable)Iterables.transform((Iterable)locations, (Function)transformer));
                }

                public String toString() {
                    return Objects.toStringHelper((Object)adapter).add("method", (Object)"listLocations").toString();
                }
            };
        }
    }
}

