/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.jaas.command;

import java.util.LinkedList;
import java.util.Map;
import javax.security.auth.login.AppConfigurationEntry;
import org.apache.felix.gogo.commands.Command;
import org.apache.felix.gogo.commands.Option;
import org.apache.karaf.jaas.command.JaasCommandSupport;
import org.apache.karaf.jaas.config.JaasRealm;
import org.apache.karaf.jaas.modules.BackingEngine;

@Command(scope="jaas", name="manage", description="Manage users and roles of a JAAS Realm")
public class ManageRealmCommand
extends JaasCommandSupport {
    @Option(name="--realm", description="Realm Name", required=false, multiValued=false)
    String realmName;
    @Option(name="--index", description="Realm Index", required=false, multiValued=false)
    int index;
    @Option(name="--module", aliases={}, description="Login Module Class Name", required=false, multiValued=false)
    String moduleName;
    @Option(name="-f", aliases={"--force"}, description="Force the management of this realm, even if another one was under management", required=false, multiValued=false)
    boolean force;

    protected Object doExecute() throws Exception {
        if (this.realmName == null && this.index <= 0) {
            System.err.println("A valid realm or the realm index need to be specified");
            return null;
        }
        JaasRealm oldRealm = (JaasRealm)this.session.get("JaasCommand.REALM");
        AppConfigurationEntry oldEntry = (AppConfigurationEntry)this.session.get("JaasCommand.ENTRY");
        if (oldRealm != null && !oldRealm.getName().equals(this.realmName) && !this.force) {
            System.err.println("Another JAAS Realm is being edited. Cancel/update first, or use the --force option.");
        } else if (oldEntry != null && !oldEntry.getLoginModuleName().equals(this.moduleName) && !this.force) {
            System.err.println("Another JAAS Login Module is being edited. Cancel/update first, or use the --force option.");
        } else {
            Map<AppConfigurationEntry, JaasRealm> entries = this.findEntries(this.realmName, this.moduleName, this.index);
            if (entries.size() == 1) {
                LinkedList commands = null;
                commands = (LinkedList)this.session.get("JaasCommand.COMMANDS");
                if (commands == null) {
                    commands = new LinkedList();
                }
                AppConfigurationEntry entry = entries.keySet().iterator().next();
                JaasRealm realm = entries.get(entry);
                this.session.put("JaasCommand.REALM", (Object)realm);
                this.session.put("JaasCommand.ENTRY", (Object)entry);
                this.session.put("JaasCommand.COMMANDS", commands);
            } else {
                this.reportFailure(this.realmName, this.moduleName, this.index);
            }
        }
        return null;
    }

    private void reportFailure(String realmName, String moduleName, int index) {
        StringBuilder sb = new StringBuilder();
        sb.append("Failed to find Login Module with");
        boolean isAndRequired = false;
        if (realmName != null && !realmName.isEmpty()) {
            sb.append(" realm name:").append(realmName);
            isAndRequired = true;
        }
        if (index > 0) {
            if (isAndRequired) {
                sb.append(" and");
            }
            sb.append(" index:").append(index);
            isAndRequired = true;
        }
        if (moduleName != null && !moduleName.isEmpty()) {
            if (isAndRequired) {
                sb.append(" and");
            }
            sb.append(" module name:").append(moduleName);
        }
        if (realmName != null && this.findRealmsByName(realmName).size() > 0 && index == 0 && moduleName == null) {
            sb.append(".\n");
            sb.append("Reason: Multiple realms named ").append(realmName).append(" found.Please specify the index or the module name of the target realm. ");
        } else {
            sb.append(".");
        }
        System.err.println(sb.toString());
    }

    protected Object doExecute(BackingEngine engine) throws Exception {
        return null;
    }
}

