/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.blobstore.strategy.internal;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import javax.annotation.Resource;
import javax.inject.Named;
import org.jclouds.blobstore.AsyncBlobStore;
import org.jclouds.blobstore.domain.BlobMetadata;
import org.jclouds.blobstore.domain.PageSet;
import org.jclouds.blobstore.domain.StorageMetadata;
import org.jclouds.blobstore.domain.StorageType;
import org.jclouds.blobstore.domain.internal.PageSetImpl;
import org.jclouds.concurrent.FutureIterables;
import org.jclouds.http.handlers.BackoffLimitedRetryHandler;
import org.jclouds.javax.annotation.concurrent.NotThreadSafe;
import org.jclouds.logging.Logger;

@NotThreadSafe
public class FetchBlobMetadata
implements Function<PageSet<? extends StorageMetadata>, PageSet<? extends StorageMetadata>> {
    protected final BackoffLimitedRetryHandler retryHandler;
    protected final AsyncBlobStore ablobstore;
    protected final ExecutorService userExecutor;
    @Resource
    @Named(value="jclouds.blobstore")
    protected Logger logger = Logger.NULL;
    private String container;
    @Inject(optional=true)
    @Named(value="jclouds.request-timeout")
    protected Long maxTime;

    @Inject
    FetchBlobMetadata(@Named(value="jclouds.user-threads") ExecutorService userExecutor, AsyncBlobStore ablobstore, BackoffLimitedRetryHandler retryHandler) {
        this.userExecutor = userExecutor;
        this.ablobstore = ablobstore;
        this.retryHandler = retryHandler;
    }

    public FetchBlobMetadata setContainerName(String container) {
        this.container = container;
        return this;
    }

    public PageSet<? extends StorageMetadata> apply(PageSet<? extends StorageMetadata> in) {
        Preconditions.checkState((this.container != null ? 1 : 0) != 0, (Object)"container name should be initialized");
        ArrayList returnv = Lists.newArrayList((Iterable)FutureIterables.transformParallel((Iterable)Iterables.filter(in, (Predicate)new Predicate<StorageMetadata>(){

            public boolean apply(StorageMetadata input) {
                return input.getType() == StorageType.BLOB;
            }
        }), (Function)new Function<StorageMetadata, Future<? extends BlobMetadata>>(){

            public Future<BlobMetadata> apply(StorageMetadata from) {
                return FetchBlobMetadata.this.ablobstore.blobMetadata(FetchBlobMetadata.this.container, from.getName());
            }
        }, (ExecutorService)this.userExecutor, (Long)this.maxTime, (Logger)this.logger, (String)String.format("getting metadata from containerName: %s", this.container)));
        return new PageSetImpl(returnv, in.getNextMarker());
    }
}

