/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.web.extender.war.internal.model;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.servlet.Filter;
import org.ops4j.lang.NullArgumentException;
import org.ops4j.pax.web.extender.war.internal.model.WebAppInitParam;

public class WebAppFilter {
    private String m_filterName;
    private String m_filterClass;
    private Filter m_filter;
    private final List<WebAppInitParam> m_initParams;
    private final Set<String> m_urlPatterns = new HashSet<String>();
    private final Set<String> m_servletNames = new HashSet<String>();

    public WebAppFilter() {
        this.m_initParams = new ArrayList<WebAppInitParam>();
    }

    public String getFilterName() {
        return this.m_filterName;
    }

    public void setFilterName(String filterName) {
        NullArgumentException.validateNotNull(filterName, "Filter name");
        this.m_filterName = filterName;
        WebAppInitParam initParam = new WebAppInitParam();
        initParam.setParamName("filter-name");
        initParam.setParamValue(filterName);
        this.m_initParams.add(initParam);
    }

    public String getFilterClass() {
        return this.m_filterClass;
    }

    public void setFilterClass(String filterClass) {
        NullArgumentException.validateNotNull(filterClass, "Filter class");
        this.m_filterClass = filterClass;
    }

    public Filter getFilter() {
        return this.m_filter;
    }

    public void setFilter(Filter filter) {
        this.m_filter = filter;
    }

    public String[] getUrlPatterns() {
        return this.m_urlPatterns.toArray(new String[this.m_urlPatterns.size()]);
    }

    public void addUrlPattern(String urlPattern) {
        NullArgumentException.validateNotEmpty(urlPattern, "Url pattern");
        this.m_urlPatterns.add(urlPattern);
    }

    public String[] getServletNames() {
        return this.m_servletNames.toArray(new String[this.m_servletNames.size()]);
    }

    public void addServletName(String servletName) {
        NullArgumentException.validateNotEmpty(servletName, "Servlet name");
        this.m_servletNames.add(servletName);
    }

    public void addInitParam(WebAppInitParam param) {
        NullArgumentException.validateNotNull(param, "Init param");
        NullArgumentException.validateNotNull(param.getParamName(), "Init param name");
        NullArgumentException.validateNotNull(param.getParamValue(), "Init param value");
        this.m_initParams.add(param);
    }

    public WebAppInitParam[] getInitParams() {
        return this.m_initParams.toArray(new WebAppInitParam[this.m_initParams.size()]);
    }

    public String toString() {
        return new StringBuffer().append(this.getClass().getSimpleName()).append("{").append("filterName=").append(this.m_filterName).append(",filterClass=").append(this.m_filterClass).append(",urlPatterns=").append(this.m_urlPatterns).append(",servletNames=").append(this.m_servletNames).append("}").toString();
    }
}

