/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.proton.engine.impl;

import java.util.EnumSet;
import org.apache.qpid.proton.amqp.transport.ReceiverSettleMode;
import org.apache.qpid.proton.amqp.transport.SenderSettleMode;
import org.apache.qpid.proton.amqp.transport.Source;
import org.apache.qpid.proton.amqp.transport.Target;
import org.apache.qpid.proton.engine.EndpointState;
import org.apache.qpid.proton.engine.Link;
import org.apache.qpid.proton.engine.impl.ConnectionImpl;
import org.apache.qpid.proton.engine.impl.DeliveryImpl;
import org.apache.qpid.proton.engine.impl.EndpointImpl;
import org.apache.qpid.proton.engine.impl.EndpointImplQuery;
import org.apache.qpid.proton.engine.impl.LinkNode;
import org.apache.qpid.proton.engine.impl.SessionImpl;
import org.apache.qpid.proton.engine.impl.TransportLink;

public abstract class LinkImpl
extends EndpointImpl
implements Link {
    private final SessionImpl _session;
    DeliveryImpl _head;
    DeliveryImpl _tail;
    DeliveryImpl _current;
    private String _name;
    private Source _source;
    private Source _remoteSource;
    private Target _target;
    private Target _remoteTarget;
    private int _queued;
    private int _credit;
    private int _unsettled;
    private SenderSettleMode _senderSettleMode;
    private SenderSettleMode _remoteSenderSettleMode;
    private ReceiverSettleMode _receiverSettleMode;
    private ReceiverSettleMode _remoteReceiverSettleMode;
    private final LinkNode<LinkImpl> _node;
    private boolean _drain;

    public LinkImpl(SessionImpl session, String name) {
        this._session = session;
        this._name = name;
        this._node = session.getConnectionImpl().addLinkEndpoint(this);
    }

    @Override
    public void open() {
        super.open();
        this.modified();
    }

    @Override
    public void close() {
        super.close();
        this.modified();
    }

    @Override
    public String getName() {
        return this._name;
    }

    @Override
    public DeliveryImpl delivery(byte[] tag) {
        return this.delivery(tag, 0, tag.length);
    }

    @Override
    public DeliveryImpl delivery(byte[] tag, int offset, int length) {
        if (offset != 0 || length != tag.length) {
            throw new IllegalArgumentException("At present delivery tag must be the whole byte array");
        }
        this.incrementQueued();
        try {
            DeliveryImpl delivery = new DeliveryImpl(tag, this, this._tail);
            if (this._tail == null) {
                this._head = delivery;
            }
            this._tail = delivery;
            if (this._current == null) {
                this._current = delivery;
            }
            this.getConnectionImpl().workUpdate(delivery);
            return delivery;
        }
        catch (RuntimeException e) {
            e.printStackTrace();
            throw e;
        }
    }

    @Override
    public void free() {
        super.free();
        this._session.getConnectionImpl().removeLinkEndpoint(this._node);
    }

    public void remove(DeliveryImpl delivery) {
        if (this._head == delivery) {
            this._head = delivery.getLinkNext();
        }
        if (this._tail == delivery) {
            this._tail = delivery.getLinkPrevious();
        }
        if (this._current == delivery) {
            // empty if block
        }
    }

    @Override
    public DeliveryImpl current() {
        return this._current;
    }

    @Override
    public boolean advance() {
        if (this._current != null) {
            DeliveryImpl oldCurrent = this._current;
            this._current = this._current.getLinkNext();
            this.getConnectionImpl().workUpdate(oldCurrent);
            if (this._current != null) {
                this.getConnectionImpl().workUpdate(this._current);
            }
            return true;
        }
        return false;
    }

    @Override
    protected ConnectionImpl getConnectionImpl() {
        return this._session.getConnectionImpl();
    }

    @Override
    public SessionImpl getSession() {
        return this._session;
    }

    @Override
    public Source getRemoteSource() {
        return this._remoteSource;
    }

    void setRemoteSource(Source source) {
        this._remoteSource = source;
    }

    @Override
    public Target getRemoteTarget() {
        return this._remoteTarget;
    }

    void setRemoteTarget(Target target) {
        this._remoteTarget = target;
    }

    @Override
    public Source getSource() {
        return this._source;
    }

    @Override
    public void setSource(Source source) {
        this._source = source;
        this.modified();
    }

    @Override
    public Target getTarget() {
        return this._target;
    }

    @Override
    public void setTarget(Target target) {
        this._target = target;
        this.modified();
    }

    @Override
    public Link next(EnumSet<EndpointState> local, EnumSet<EndpointState> remote) {
        EndpointImplQuery query = new EndpointImplQuery(local, remote);
        LinkNode<LinkImpl> linkNode = this._node.next(query);
        return linkNode == null ? null : linkNode.getValue();
    }

    abstract TransportLink getTransportLink();

    abstract boolean workUpdate(DeliveryImpl var1);

    @Override
    public int getCredit() {
        return this._credit;
    }

    public void addCredit(int credit) {
        this._credit += credit;
    }

    public void setCredit(int credit) {
        this._credit = credit;
    }

    boolean hasCredit() {
        return this._credit > 0;
    }

    void incrementCredit() {
        ++this._credit;
    }

    void decrementCredit() {
        --this._credit;
    }

    @Override
    public int getQueued() {
        return this._queued;
    }

    void incrementQueued() {
        ++this._queued;
    }

    void decrementQueued() {
        --this._queued;
    }

    @Override
    public int getUnsettled() {
        return this._unsettled;
    }

    void incrementUnsettled() {
        ++this._unsettled;
    }

    void decrementUnsettled() {
        --this._unsettled;
    }

    void setDrain(boolean drain) {
        this._drain = drain;
    }

    boolean getDrain() {
        return this._drain;
    }

    @Override
    public SenderSettleMode getSenderSettleMode() {
        return this._senderSettleMode;
    }

    @Override
    public void setSenderSettleMode(SenderSettleMode senderSettleMode) {
        this._senderSettleMode = senderSettleMode;
    }

    @Override
    public SenderSettleMode getRemoteSenderSettleMode() {
        return this._remoteSenderSettleMode;
    }

    @Override
    public void setRemoteSenderSettleMode(SenderSettleMode remoteSenderSettleMode) {
        this._remoteSenderSettleMode = remoteSenderSettleMode;
    }

    @Override
    public ReceiverSettleMode getReceiverSettleMode() {
        return this._receiverSettleMode;
    }

    @Override
    public void setReceiverSettleMode(ReceiverSettleMode receiverSettleMode) {
        this._receiverSettleMode = receiverSettleMode;
    }

    @Override
    public ReceiverSettleMode getRemoteReceiverSettleMode() {
        return this._remoteReceiverSettleMode;
    }

    void setRemoteReceiverSettleMode(ReceiverSettleMode remoteReceiverSettleMode) {
        this._remoteReceiverSettleMode = remoteReceiverSettleMode;
    }
}

