/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.proton.messenger.impl;

import java.util.ArrayList;
import java.util.Iterator;
import org.apache.qpid.proton.amqp.messaging.Accepted;
import org.apache.qpid.proton.amqp.messaging.Rejected;
import org.apache.qpid.proton.amqp.transport.DeliveryState;
import org.apache.qpid.proton.engine.Delivery;
import org.apache.qpid.proton.messenger.Status;
import org.apache.qpid.proton.messenger.Tracker;
import org.apache.qpid.proton.messenger.impl.TrackerImpl;

class TrackerQueue {
    private static final Accepted ACCEPTED = Accepted.getInstance();
    private static final Rejected REJECTED = new Rejected();
    private int _window = 0;
    private int _hwm = 0;
    private int _lwm = 0;
    private ArrayList<Delivery> _deliveries = new ArrayList();
    private static final DeliveryOperation ACCEPT = new DeliveryOperation(){

        @Override
        public void apply(Delivery d) {
            if (d.getLocalState() == null) {
                d.disposition(ACCEPTED);
            }
        }
    };
    private static final DeliveryOperation REJECT = new DeliveryOperation(){

        @Override
        public void apply(Delivery d) {
            if (d.getLocalState() == null) {
                d.disposition(REJECTED);
            }
        }
    };
    private static final DeliveryOperation SETTLE = new DeliveryOperation(){

        @Override
        public void apply(Delivery d) {
            if (d.getLocalState() == null) {
                d.disposition(d.getRemoteState());
            }
            d.settle();
        }
    };

    TrackerQueue() {
    }

    void setWindow(int window) {
        this._window = window;
    }

    int getWindow() {
        return this._window;
    }

    void accept(Tracker tracker) {
        this.accept(tracker, 0);
    }

    void accept(Tracker tracker, int flags) {
        this.apply(tracker, flags, ACCEPT);
    }

    void reject(Tracker tracker, int flags) {
        this.apply(tracker, flags, REJECT);
    }

    void settle(Tracker tracker, int flags) {
        this.apply(tracker, flags, SETTLE);
    }

    void add(Delivery delivery) {
        if (delivery == null) {
            throw new NullPointerException("Cannot add null delivery!");
        }
        int sequence = this._hwm++;
        this._deliveries.add(delivery);
        this.slide();
    }

    Status getStatus(Tracker tracker) {
        Delivery delivery = this.getDelivery(tracker);
        if (delivery != null) {
            DeliveryState state = delivery.getRemoteState();
            if (state != null) {
                return this.getStatus(state);
            }
            if (delivery.remotelySettled() || delivery.isSettled()) {
                return this.getStatus(delivery.getLocalState());
            }
            return Status.PENDING;
        }
        return Status.UNKNOWN;
    }

    private Status getStatus(DeliveryState state) {
        if (state instanceof Accepted) {
            return Status.ACCEPTED;
        }
        if (state instanceof Rejected) {
            return Status.REJECTED;
        }
        if (state == null) {
            return Status.PENDING;
        }
        throw new RuntimeException("Unexpected disposition: " + state);
    }

    void slide() {
        if (this._window >= 0) {
            while (this._hwm - this._lwm > this._window) {
                if (this._deliveries.isEmpty()) {
                    throw new RuntimeException("Inconsistent state, empty delivery queue but lwm=" + this._lwm + " and hwm=" + this._hwm);
                }
                Delivery d = this._deliveries.get(0);
                if (d.getLocalState() == null) {
                    d.disposition(ACCEPTED);
                }
                d.settle();
                this._deliveries.remove(0);
                ++this._lwm;
            }
        }
    }

    int getHighWaterMark() {
        return this._hwm;
    }

    Iterator<Delivery> deliveries() {
        return this._deliveries.iterator();
    }

    private Delivery getDelivery(Tracker tracker) {
        int seq = ((TrackerImpl)tracker).getSequence();
        if (seq < this._lwm || seq > this._hwm) {
            return null;
        }
        int index = seq - this._lwm;
        return index < this._deliveries.size() ? this._deliveries.get(index) : null;
    }

    static boolean isOutgoing(Tracker tracker) {
        return ((TrackerImpl)tracker).isOutgoing();
    }

    private void apply(Tracker tracker, int flags, DeliveryOperation operation) {
        int start2;
        int seq = ((TrackerImpl)tracker).getSequence();
        if (seq < this._lwm || seq > this._hwm) {
            return;
        }
        int last = seq - this._lwm;
        for (int i = start2 = (flags & 1) != 0 ? 0 : last; i <= last && i < this._deliveries.size(); ++i) {
            Delivery d = this._deliveries.get(i);
            if (d == null || d.isSettled()) continue;
            operation.apply(d);
        }
    }

    private static interface DeliveryOperation {
        public void apply(Delivery var1);
    }
}

