/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.insight.log.elasticsearch;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.concurrent.atomic.AtomicLong;
import org.elasticsearch.action.admin.indices.create.CreateIndexRequest;
import org.elasticsearch.action.index.IndexRequest;
import org.fusesource.insight.log.elasticsearch.ElasticSender;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;

public class InsightEventHandler
implements EventHandler {
    private static final AtomicLong SEQUENCE_COUNTER = new AtomicLong(System.currentTimeMillis() * 1000L);
    private String name;
    private String index;
    private String type;
    private ElasticSender sender;
    private final SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZ");

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getIndex() {
        return this.index;
    }

    public void setIndex(String index) {
        this.index = index;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public ElasticSender getSender() {
        return this.sender;
    }

    public void setSender(ElasticSender sender) {
        this.sender = sender;
    }

    public void init() {
        CreateIndexRequest request = new CreateIndexRequest(this.index);
        HashMap<String, String> not_analyzed = new HashMap<String, String>();
        not_analyzed.put("type", "string");
        not_analyzed.put("index", "not_analyzed");
        HashMap<String, HashMap<String, String>> properties = new HashMap<String, HashMap<String, String>>();
        properties.put("seq", not_analyzed);
        HashMap<String, HashMap<String, HashMap<String, String>>> options = new HashMap<String, HashMap<String, HashMap<String, String>>>();
        options.put("properties", properties);
        request.mapping(this.type, options);
        this.sender.createIndexIfNeeded(request);
    }

    public void handleEvent(Event event) {
        try {
            StringBuilder writer = new StringBuilder();
            writer.append("{ \"host\": ");
            ElasticSender.quote(this.name, writer);
            writer.append(", \"seq\" : " + SEQUENCE_COUNTER.incrementAndGet());
            writer.append(", \"topic\": ");
            ElasticSender.quote(event.getTopic(), writer);
            writer.append(", \"properties\": { ");
            boolean first = true;
            for (String name : event.getPropertyNames()) {
                if (first) {
                    first = false;
                } else {
                    writer.append(", ");
                }
                ElasticSender.quote(name, writer);
                writer.append(": ");
                Object value = event.getProperty(name);
                if (value == null) {
                    writer.append("null");
                    continue;
                }
                if ("timestamp".equals(name) && value instanceof Long) {
                    ElasticSender.quote(this.formatDate((Long)value), writer);
                    continue;
                }
                if (value.getClass().isArray()) {
                    writer.append(" [ ");
                    boolean vfirst = true;
                    for (Object v : (Object[])value) {
                        if (!vfirst) {
                            writer.append(", ");
                        } else {
                            vfirst = false;
                        }
                        ElasticSender.quote(v.toString(), writer);
                    }
                    writer.append(" ] ");
                    continue;
                }
                ElasticSender.quote(value.toString(), writer);
            }
            writer.append(" } }");
            IndexRequest request = new IndexRequest().index(this.index).type(this.type).source(writer.toString()).create(true);
            this.sender.put(request);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private String formatDate(long timestamp) {
        return this.simpleDateFormat.format(new Date(timestamp));
    }
}

