/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.karaf.cache;

import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.jclouds.karaf.cache.Cacheable;
import org.jclouds.karaf.cache.tasks.UpdateCachesTask;
import org.jclouds.karaf.utils.ServiceHelper;

public class CacheManager<T>
implements Runnable {
    protected ScheduledExecutorService scheduledExecutorService = Executors.newSingleThreadScheduledExecutor();
    protected final List<Cacheable<T>> cacheables = new LinkedList<Cacheable<T>>();
    protected final Map<String, T> services = new HashMap<String, T>();
    private UpdateCachesTask updatesCachesTask;

    public void init() {
        this.scheduledExecutorService.scheduleAtFixedRate(this, 0L, 5L, TimeUnit.MINUTES);
    }

    public void destroy() {
        if (this.updatesCachesTask != null) {
            this.updatesCachesTask.stop();
        }
        this.scheduledExecutorService.shutdownNow();
    }

    @Override
    public void run() {
        this.updatesCachesTask = new UpdateCachesTask<T>(this.cacheables, this.services);
        this.updatesCachesTask.run();
    }

    public void bindService(T service) {
        HashMap<String, T> map = new HashMap<String, T>();
        map.put(ServiceHelper.toId(service), service);
        this.services.putAll(map);
        this.scheduledExecutorService.submit(new UpdateCachesTask<T>(this.cacheables, map));
    }

    public void unbindService(T service) {
        if (this.services != null && service != null) {
            this.services.remove(ServiceHelper.toId(service));
        }
    }

    public void bindCachable(Cacheable<T> cacheable) {
        this.cacheables.add(cacheable);
        this.scheduledExecutorService.submit(new UpdateCachesTask(Arrays.asList(cacheable), this.services));
    }

    public void unbindCachable(Cacheable<T> cacheable) {
        if (this.cacheables != null) {
            this.cacheables.remove(cacheable);
        }
    }
}

