/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.karaf.cache.utils;

import org.jclouds.karaf.cache.CacheManager;
import org.jclouds.karaf.cache.Cacheable;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;

public class CacheUtils {
    private CacheUtils() {
    }

    public static <T> ServiceTracker createServiceCacheTracker(BundleContext context, final Class<T> serviceClass, final CacheManager<T> cacheManager) {
        return new ServiceTracker(context, serviceClass.getName(), null){

            public Object addingService(ServiceReference reference) {
                Object service = super.addingService(reference);
                if (serviceClass.isAssignableFrom(service.getClass())) {
                    cacheManager.bindService(service);
                }
                return service;
            }

            public void removedService(ServiceReference reference, Object service) {
                if (serviceClass.isAssignableFrom(service.getClass())) {
                    cacheManager.unbindService(service);
                }
                super.removedService(reference, service);
            }
        };
    }

    public static <T> ServiceTracker createCacheableTracker(BundleContext context, String type, final CacheManager<T> cacheManager) throws InvalidSyntaxException {
        return new ServiceTracker(context, FrameworkUtil.createFilter((String)("(&(cache-type=" + type + ")(objectClass=org.jclouds.karaf.cache.Cacheable))")), null){

            public Object addingService(ServiceReference reference) {
                Object service = super.addingService(reference);
                if (Cacheable.class.isAssignableFrom(service.getClass())) {
                    cacheManager.bindCachable((Cacheable)service);
                }
                return service;
            }

            public void removedService(ServiceReference reference, Object service) {
                if (Cacheable.class.isAssignableFrom(service.getClass())) {
                    cacheManager.unbindCachable((Cacheable)service);
                }
                super.removedService(reference, service);
            }
        };
    }
}

