/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.karaf.commands.blobstore;

import java.util.LinkedList;
import java.util.List;
import org.apache.felix.gogo.commands.Argument;
import org.apache.felix.gogo.commands.Command;
import org.jclouds.blobstore.BlobStore;
import org.jclouds.karaf.commands.blobstore.BlobStoreCommandWithOptions;

@Command(scope="jclouds", name="blobstore-delete-container", description="Deletes a container")
public class BlobDeleteCommand
extends BlobStoreCommandWithOptions {
    @Argument(index=0, name="containerNames", description="The name of the container", required=true, multiValued=true)
    List<String> containerNames = new LinkedList<String>();

    protected Object doExecute() throws Exception {
        BlobStore blobStore = this.getBlobStore();
        for (String container : this.containerNames) {
            blobStore.deleteContainer(container);
            this.cacheProvider.getProviderCacheForType("container").remove((Object)blobStore.getContext().unwrap().getId(), (Object)container);
        }
        return null;
    }
}

