/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.karaf.commands.support;

import com.google.common.collect.Multimap;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.apache.felix.service.command.CommandSession;
import org.apache.karaf.shell.console.Completer;
import org.apache.karaf.shell.console.completer.ArgumentCompleter;
import org.apache.karaf.shell.console.completer.StringsCompleter;
import org.apache.karaf.shell.console.jline.CommandSessionHolder;
import org.jclouds.karaf.cache.CacheProvider;
import org.jclouds.karaf.cache.Cacheable;

public abstract class GenericCompleterSupport<T, K>
implements Completer,
Cacheable<T> {
    protected static final String NAME_OPTION = "--name";
    protected static final String PROVIDER_OPTION = "--provider";
    protected static final String API_OPTION = "--api";
    protected final StringsCompleter delegate = new StringsCompleter();
    protected CacheProvider cacheProvider;
    protected Multimap<String, String> cache;

    public abstract K getCacheableKey(T var1);

    public int complete(String buffer, int cursor, List<String> candidates) {
        CommandSession commandSession = CommandSessionHolder.getSession();
        ArgumentCompleter.ArgumentList list = (ArgumentCompleter.ArgumentList)commandSession.get("ARGUMENTS_LIST");
        this.delegate.getStrings().clear();
        if (list != null) {
            String contextName = this.extractContextName(list.getArguments());
            String providerOrApi = this.extractProviderOrApiFromArguments(list.getArguments());
            Collection values = contextName != null && this.cache.containsKey((Object)contextName) ? this.cache.get((Object)contextName) : (providerOrApi != null && this.cache.containsKey((Object)providerOrApi) ? this.cache.get((Object)providerOrApi) : this.cache.values());
            for (String item : values) {
                if (buffer != null && !item.startsWith(buffer)) continue;
                this.delegate.getStrings().add(item);
            }
        }
        return this.delegate.complete(buffer, cursor, candidates);
    }

    private String extractContextName(String ... args) {
        List<String> arguments;
        String id = null;
        if (args != null && args.length > 0 && (arguments = Arrays.asList(args)).contains(NAME_OPTION)) {
            int index = arguments.indexOf(NAME_OPTION);
            if (arguments.size() > index) {
                return arguments.get(index + 1);
            }
        }
        return id;
    }

    private String extractProviderOrApiFromArguments(String ... args) {
        String id = null;
        if (args != null && args.length > 0) {
            int index;
            List<String> arguments = Arrays.asList(args);
            if (arguments.contains(NAME_OPTION)) {
                index = arguments.indexOf(NAME_OPTION);
                if (arguments.size() > index) {
                    return arguments.get(index + 1);
                }
            }
            if (arguments.contains(PROVIDER_OPTION)) {
                index = arguments.indexOf(PROVIDER_OPTION);
                if (arguments.size() > index) {
                    return arguments.get(index + 1);
                }
            } else if (arguments.contains(API_OPTION)) {
                index = arguments.indexOf(API_OPTION);
                if (arguments.size() > index) {
                    return arguments.get(index + 1);
                }
            }
        }
        return id;
    }

    public void updateOnRemoved(T type) {
        this.cache.removeAll(this.getCacheableKey(type));
    }

    public CacheProvider getCacheProvider() {
        return this.cacheProvider;
    }

    public void setCacheProvider(CacheProvider cacheProvider) {
        this.cacheProvider = cacheProvider;
    }
}

