/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.fabric.commands;

import java.util.List;
import org.apache.felix.gogo.commands.Argument;
import org.apache.felix.gogo.commands.Command;
import org.fusesource.fabric.api.Container;
import org.fusesource.fabric.api.Profile;
import org.fusesource.fabric.boot.commands.support.FabricCommand;
import org.fusesource.fabric.utils.FabricValidations;

@Command(name="container-add-profile", scope="fabric", description="Adds the specified profile to the container list of profiles.")
public class ContainerAddProfile
extends FabricCommand {
    @Argument(index=0, name="container", description="The container name", required=true, multiValued=false)
    private String container;
    @Argument(index=1, name="profiles", description="The profiles to add to the container.", required=true, multiValued=true)
    private List<String> profiles;

    protected Object doExecute() throws Exception {
        this.checkFabricAvailable();
        FabricValidations.validateContainersName(this.container);
        FabricValidations.validateProfileName(this.profiles);
        Container cont = this.getContainer(this.container);
        Profile[] existingProfiles = cont.getProfiles();
        if (existingProfiles != null) {
            for (Profile existingProfile : existingProfiles) {
                String id = existingProfile.getId();
                if (this.profiles.contains(id)) continue;
                this.profiles.add(id);
            }
        }
        Profile[] profs = this.getProfiles(cont.getVersion(), this.profiles);
        cont.setProfiles(profs);
        return null;
    }
}

