/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.fabric.commands;

import java.util.List;
import org.apache.felix.gogo.commands.Argument;
import org.apache.felix.gogo.commands.Command;
import org.apache.felix.gogo.commands.Option;
import org.fusesource.fabric.api.Profile;
import org.fusesource.fabric.api.Version;
import org.fusesource.fabric.boot.commands.support.FabricCommand;
import org.fusesource.fabric.utils.FabricValidations;

@Command(name="profile-create", scope="fabric", description="Create a new profile with the specified name and version", detailedDescription="classpath:profileCreate.txt")
public class ProfileCreate
extends FabricCommand {
    @Option(name="--version", description="The profile version. Defaults to the current default version.")
    private String version;
    @Option(name="--parents", multiValued=true, required=false, description="Optionally specifies one or multiple parent profiles. To specify multiple parent profiles, specify this flag multiple times on the command line. For example, --parents foo --parents bar.")
    private List<String> parents;
    @Argument(index=0)
    private String name;

    protected Object doExecute() throws Exception {
        this.checkFabricAvailable();
        FabricValidations.validateProfileName(this.name);
        Version ver = this.version != null ? this.fabricService.getVersion(this.version) : this.fabricService.getDefaultVersion();
        Profile[] parents = this.getProfiles(ver, this.parents);
        Profile profile = this.fabricService.getVersion(ver.getName()).createProfile(this.name);
        profile.setParents(parents);
        return null;
    }
}

