/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.compute.domain;

import com.google.common.base.Preconditions;
import java.net.URI;
import java.util.Map;
import org.jclouds.compute.domain.ComputeMetadataBuilder;
import org.jclouds.compute.domain.ComputeType;
import org.jclouds.compute.domain.Image;
import org.jclouds.compute.domain.OperatingSystem;
import org.jclouds.compute.domain.internal.ImageImpl;
import org.jclouds.domain.Location;
import org.jclouds.domain.LoginCredentials;
import org.jclouds.javax.annotation.Nullable;

public class ImageBuilder
extends ComputeMetadataBuilder {
    private OperatingSystem operatingSystem;
    private Image.Status status;
    private String backendStatus;
    private String version;
    private String description;
    private LoginCredentials defaultLoginCredentials;

    public ImageBuilder() {
        super(ComputeType.IMAGE);
    }

    public ImageBuilder operatingSystem(OperatingSystem operatingSystem) {
        this.operatingSystem = (OperatingSystem)Preconditions.checkNotNull((Object)operatingSystem, (Object)"operatingSystem");
        return this;
    }

    public ImageBuilder status(Image.Status status) {
        this.status = (Image.Status)((Object)Preconditions.checkNotNull((Object)((Object)status), (Object)"status"));
        return this;
    }

    public ImageBuilder backendStatus(@Nullable String backendStatus) {
        this.backendStatus = backendStatus;
        return this;
    }

    public ImageBuilder version(@Nullable String version) {
        this.version = version;
        return this;
    }

    public ImageBuilder description(String description) {
        this.description = (String)Preconditions.checkNotNull((Object)description, (Object)"description");
        return this;
    }

    public ImageBuilder defaultCredentials(@Nullable LoginCredentials defaultLoginCredentials) {
        this.defaultLoginCredentials = defaultLoginCredentials;
        return this;
    }

    @Override
    public ImageBuilder id(String id) {
        return (ImageBuilder)((Object)ImageBuilder.class.cast((Object)super.id(id)));
    }

    @Override
    public ImageBuilder tags(Iterable<String> tags) {
        return (ImageBuilder)((Object)ImageBuilder.class.cast((Object)super.tags(tags)));
    }

    @Override
    public ImageBuilder ids(String id) {
        return (ImageBuilder)((Object)ImageBuilder.class.cast((Object)super.ids(id)));
    }

    @Override
    public ImageBuilder providerId(String providerId) {
        return (ImageBuilder)((Object)ImageBuilder.class.cast((Object)super.providerId(providerId)));
    }

    @Override
    public ImageBuilder name(String name) {
        return (ImageBuilder)((Object)ImageBuilder.class.cast((Object)super.name(name)));
    }

    @Override
    public ImageBuilder location(Location location) {
        return (ImageBuilder)((Object)ImageBuilder.class.cast((Object)super.location(location)));
    }

    @Override
    public ImageBuilder uri(URI uri) {
        return (ImageBuilder)((Object)ImageBuilder.class.cast((Object)super.uri(uri)));
    }

    @Override
    public ImageBuilder userMetadata(Map<String, String> userMetadata) {
        return (ImageBuilder)((Object)ImageBuilder.class.cast(super.userMetadata((Map)userMetadata)));
    }

    @Override
    public Image build() {
        return new ImageImpl(this.providerId, this.name, this.id, this.location, this.uri, this.userMetadata, this.tags, this.operatingSystem, this.status, this.backendStatus, this.description, this.version, this.defaultLoginCredentials);
    }

    public static ImageBuilder fromImage(Image image) {
        return ((ImageBuilder)((ImageBuilder)new ImageBuilder().providerId(image.getProviderId()).name(image.getName()).id(image.getId()).location(image.getLocation()).uri(image.getUri()).userMetadata(image.getUserMetadata())).tags(image.getTags())).version(image.getVersion()).description(image.getDescription()).operatingSystem(image.getOperatingSystem()).status((Image.Status)((Object)image.getStatus())).backendStatus(image.getBackendStatus()).defaultCredentials(image.getDefaultCredentials());
    }
}

