/*
 * Decompiled with CFR 0.152.
 */
package org.linkedin.zookeeper.client;

import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.TimeoutException;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.linkedin.util.annotations.Initializer;
import org.linkedin.util.clock.Clock;
import org.linkedin.util.clock.SystemClock;
import org.linkedin.util.clock.Timespan;
import org.linkedin.util.concurrent.ConcurrentUtils;
import org.linkedin.util.exceptions.InternalException;
import org.linkedin.util.lifecycle.Destroyable;
import org.linkedin.util.lifecycle.Startable;
import org.linkedin.zookeeper.client.AbstractZKClient;
import org.linkedin.zookeeper.client.ChrootedZKClient;
import org.linkedin.zookeeper.client.IZKClient;
import org.linkedin.zookeeper.client.IZooKeeper;
import org.linkedin.zookeeper.client.IZooKeeperFactory;
import org.linkedin.zookeeper.client.LifecycleListener;
import org.linkedin.zookeeper.client.ZooKeeperFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ZKClient
extends AbstractZKClient
implements Startable,
Destroyable,
Watcher {
    public static final String MODULE = ZKClient.class.getName();
    public static final Logger log = LoggerFactory.getLogger((String)MODULE);
    private IZooKeeper _zk;
    private volatile Clock _clock = SystemClock.instance();
    private volatile Timespan _reconnectTimeout = Timespan.parse("20s");
    private volatile Set<LifecycleListener> _listeners = null;
    private final Object _lock = new Object();
    private StateChangeDispatcher _stateChangeDispatcher = null;
    private ExpiredSessionRecovery _expiredSessionRecovery = null;
    private volatile State _state = State.NONE;
    private final IZooKeeperFactory _factory;

    public ZKClient(String connectString, Timespan sessionTimeout, Watcher watcher) {
        this(new ZooKeeperFactory(connectString, sessionTimeout, watcher));
    }

    public ZKClient(IZooKeeperFactory factory) {
        this(factory, null);
    }

    public ZKClient(IZooKeeperFactory factory, String chroot) {
        super(chroot);
        this._factory = factory;
    }

    public State getZKClientState() {
        return this._state;
    }

    public IZooKeeperFactory getFactory() {
        return this._factory;
    }

    public Clock getClock() {
        return this._clock;
    }

    @Initializer
    public void setClock(Clock clock) {
        this._clock = clock;
    }

    public Timespan getReconnectTimeout() {
        return this._reconnectTimeout;
    }

    @Initializer
    public void setReconnectTimeout(Timespan reconnectTimeout) {
        this._reconnectTimeout = reconnectTimeout;
    }

    public Set<LifecycleListener> getListeners() {
        return this._listeners;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerListener(LifecycleListener listener) {
        if (listener == null) {
            throw new NullPointerException("listener is null");
        }
        Object object = this._lock;
        synchronized (object) {
            if (this._listeners == null || !this._listeners.contains(listener)) {
                HashSet<LifecycleListener> listeners = new HashSet<LifecycleListener>();
                if (this._listeners != null) {
                    listeners.addAll(this._listeners);
                }
                listeners.add(listener);
                this._listeners = listeners;
                if (this._stateChangeDispatcher == null) {
                    this._stateChangeDispatcher = new StateChangeDispatcher();
                    this._stateChangeDispatcher.setDaemon(true);
                    this._stateChangeDispatcher.start();
                }
                if (this._state == State.CONNECTED) {
                    this._stateChangeDispatcher.addEvent(null, State.CONNECTED);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeListener(LifecycleListener listener) {
        Object object = this._lock;
        synchronized (object) {
            if (this._listeners != null && this._listeners.contains(listener)) {
                HashSet<LifecycleListener> listeners = new HashSet<LifecycleListener>(this._listeners);
                listeners.remove(listener);
                if (listeners.size() == 0) {
                    listeners = null;
                    if (this._stateChangeDispatcher != null) {
                        this._stateChangeDispatcher.end();
                        this._stateChangeDispatcher = null;
                    }
                }
                this._listeners = listeners;
            }
        }
    }

    @Override
    public IZKClient chroot(String path) {
        return new ChrootedZKClient(this, this.adjustPath(path));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start() {
        Object object = this._lock;
        synchronized (object) {
            if (this._state != State.NONE) {
                throw new IllegalStateException("already started");
            }
            this.changeState(State.CONNECTING);
            try {
                this._zk = this.createZooKeeper();
            }
            catch (InternalException e) {
                this.changeState(State.NONE);
                throw e;
            }
            catch (Throwable e) {
                this.changeState(State.NONE);
                throw new InternalException(MODULE, e);
            }
        }
    }

    private IZooKeeper createZooKeeper() {
        return this._factory.createZooKeeper(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void changeState(State newState) {
        Object object = this._lock;
        synchronized (object) {
            if (this._state != newState) {
                if (this._stateChangeDispatcher != null) {
                    this._stateChangeDispatcher.addEvent(this._state, newState);
                }
                this._state = newState;
                this._lock.notifyAll();
            }
        }
    }

    @Override
    public boolean isConnected() {
        return this._state == State.CONNECTED;
    }

    public void waitForStart() throws InterruptedException {
        try {
            this.waitForStart(null);
        }
        catch (TimeoutException e) {
            throw new RuntimeException(e);
        }
    }

    public void waitForStart(Timespan timeout) throws TimeoutException, InterruptedException {
        this.waitForState(State.CONNECTED, timeout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForState(State state, Timespan timeout) throws TimeoutException, InterruptedException {
        long endTime = timeout == null ? 0L : timeout.futureTimeMillis(this._clock);
        Object object = this._lock;
        synchronized (object) {
            while (this._state != state) {
                ConcurrentUtils.awaitUntil(this._clock, this._lock, endTime);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void destroy() {
        Object object = this._lock;
        synchronized (object) {
            block6: {
                if (this._zk != null) {
                    try {
                        this.changeState(State.NONE);
                        this._zk.close();
                        this._zk = null;
                    }
                    catch (Exception e) {
                        if (!log.isDebugEnabled()) break block6;
                        log.debug("ignored exception", (Throwable)e);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void process(WatchedEvent event) {
        Object object = this._lock;
        synchronized (object) {
            if (event.getState() != null) {
                if (log.isDebugEnabled()) {
                    log.debug("event: " + (Object)((Object)event.getState()));
                }
                switch (event.getState()) {
                    case SyncConnected: {
                        this.changeState(State.CONNECTED);
                        break;
                    }
                    case Disconnected: {
                        if (this._state == State.NONE) break;
                        this.changeState(State.RECONNECTING);
                        break;
                    }
                    case Expired: {
                        this._zk = null;
                        this.changeState(State.NONE);
                        try {
                            log.warn("Expiration detected: trying to restart...");
                            this.start();
                        }
                        catch (Throwable e) {
                            log.warn("Error while restarting:", e);
                            if (this._expiredSessionRecovery != null) break;
                            this._expiredSessionRecovery = new ExpiredSessionRecovery();
                            this._expiredSessionRecovery.setDaemon(true);
                            this._expiredSessionRecovery.start();
                        }
                        break;
                    }
                    default: {
                        log.warn("unprocessed event state: " + (Object)((Object)event.getState()));
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected IZooKeeper getZk() throws InternalException {
        Object object = this._lock;
        synchronized (object) {
            if (!this.isConnected()) {
                throw new IllegalStateException("not connected");
            }
            return this._zk;
        }
    }

    @Override
    public String getConnectString() {
        return this._factory.getConnectString();
    }

    private class ExpiredSessionRecovery
    extends Thread {
        private ExpiredSessionRecovery() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            log.info("Entering recovery mode");
            try {
                Object object = ZKClient.this._lock;
                synchronized (object) {
                    int count = 0;
                    while (ZKClient.this._state == State.NONE) {
                        try {
                            log.warn("Recovery mode: trying to reconnect to zookeeper [" + ++count + "]");
                            ZKClient.this.start();
                        }
                        catch (Throwable e) {
                            log.warn("Recovery mode: reconnect attempt failed [" + count + "]... waiting for " + ZKClient.this._reconnectTimeout, e);
                            try {
                                ZKClient.this._lock.wait(ZKClient.this._reconnectTimeout.getDurationInMilliseconds());
                            }
                            catch (InterruptedException e1) {
                                throw new RuntimeException("Recovery mode: wait interrupted... bailing out", e1);
                            }
                        }
                    }
                }
            }
            finally {
                ZKClient.this._expiredSessionRecovery = null;
                log.info("Exiting recovery mode.");
            }
        }
    }

    private class StateChangeDispatcher
    extends Thread {
        public final String MODULE = StateChangeDispatcher.class.getName();
        public final Logger log = LoggerFactory.getLogger((String)this.MODULE);
        private volatile boolean _running = true;
        private final Queue<Boolean> _events = new LinkedList<Boolean>();
        private final Map<LifecycleListener, Boolean> _eventsHistory = new IdentityHashMap<LifecycleListener, Boolean>();

        private StateChangeDispatcher() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            this.log.info("Starting StateChangeDispatcher");
            while (this._running) {
                Boolean isConnectedEvent = null;
                Queue<Boolean> queue = this._events;
                synchronized (queue) {
                    while (this._running && this._events.isEmpty()) {
                        try {
                            this._events.wait();
                        }
                        catch (InterruptedException e) {
                            if (!this.log.isDebugEnabled()) continue;
                            this.log.debug("ignoring exception", (Throwable)e);
                        }
                    }
                    if (!this._events.isEmpty()) {
                        isConnectedEvent = this._events.remove();
                    }
                }
                if (!this._running || isConnectedEvent == null) continue;
                Set listeners = ZKClient.this._listeners;
                if (listeners != null) {
                    for (LifecycleListener listener : listeners) {
                        try {
                            Boolean previousEvent = this._eventsHistory.get(listener);
                            if (previousEvent != null && previousEvent == isConnectedEvent) continue;
                            if (isConnectedEvent.booleanValue()) {
                                listener.onConnected();
                                continue;
                            }
                            listener.onDisconnected();
                        }
                        catch (Throwable e) {
                            this.log.warn("Exception while excecuting listener (ignored)", e);
                        }
                    }
                    this._eventsHistory.clear();
                    for (LifecycleListener listener : listeners) {
                        this._eventsHistory.put(listener, isConnectedEvent);
                    }
                    continue;
                }
                this._eventsHistory.clear();
            }
            this.log.info("StateChangeDispatcher terminated.");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void end() {
            Queue<Boolean> queue = this._events;
            synchronized (queue) {
                this._running = false;
                this._events.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addEvent(State oldState, State newState) {
            Queue<Boolean> queue = this._events;
            synchronized (queue) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("addEvent: " + (Object)((Object)oldState) + " => " + (Object)((Object)newState));
                }
                if (this._running) {
                    if (newState == State.CONNECTED) {
                        this._events.add(true);
                        this._events.notifyAll();
                    } else if (oldState == State.CONNECTED) {
                        this._events.add(false);
                        this._events.notifyAll();
                    }
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum State {
        NONE,
        CONNECTING,
        CONNECTED,
        RECONNECTING;

    }
}

