/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.fabric.dosgi.impl;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.fusesource.fabric.dosgi.api.Dispatched;
import org.fusesource.fabric.dosgi.api.SerializationStrategy;
import org.fusesource.fabric.dosgi.capset.CapabilitySet;
import org.fusesource.fabric.dosgi.capset.SimpleFilter;
import org.fusesource.fabric.dosgi.impl.EndpointDescription;
import org.fusesource.fabric.dosgi.impl.ExportRegistration;
import org.fusesource.fabric.dosgi.impl.ImportRegistration;
import org.fusesource.fabric.dosgi.io.ClientInvoker;
import org.fusesource.fabric.dosgi.io.ServerInvoker;
import org.fusesource.fabric.dosgi.tcp.ClientInvokerImpl;
import org.fusesource.fabric.dosgi.tcp.ServerInvokerImpl;
import org.fusesource.fabric.dosgi.util.AriesFrameworkUtil;
import org.fusesource.fabric.dosgi.util.Utils;
import org.fusesource.fabric.dosgi.util.UuidGenerator;
import org.fusesource.fabric.zookeeper.IZKClient;
import org.fusesource.hawtdispatch.Dispatch;
import org.fusesource.hawtdispatch.DispatchQueue;
import org.linkedin.zookeeper.tracker.NodeEvent;
import org.linkedin.zookeeper.tracker.NodeEventsListener;
import org.linkedin.zookeeper.tracker.ZKDataReader;
import org.linkedin.zookeeper.tracker.ZKStringDataReader;
import org.linkedin.zookeeper.tracker.ZooKeeperTreeTracker;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceFactory;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.framework.hooks.service.EventHook;
import org.osgi.framework.hooks.service.FindHook;
import org.osgi.framework.hooks.service.ListenerHook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Manager
implements ServiceListener,
ListenerHook,
EventHook,
FindHook,
NodeEventsListener<String>,
Dispatched {
    public static final String CONFIG = "fabric-dosgi";
    private static final Logger LOGGER = LoggerFactory.getLogger(Manager.class);
    private static final String DOSGI_REGISTRY = "/fabric/dosgi";
    private static final String FABRIC_ADDRESS = "fabric.address";
    private final BundleContext bundleContext;
    private ServiceRegistration registration;
    private final IZKClient zooKeeper;
    private ZooKeeperTreeTracker<String> tree;
    private final CapabilitySet<EndpointDescription> remoteEndpoints;
    private final DispatchQueue queue = Dispatch.createQueue();
    private final Map<ServiceReference, ExportRegistration> exportedServices;
    private final Map<EndpointDescription, Map<Long, ImportRegistration>> importedServices = new ConcurrentHashMap<EndpointDescription, Map<Long, ImportRegistration>>();
    private final Map<ListenerHook.ListenerInfo, SimpleFilter> listeners;
    private final Map<String, SerializationStrategy> serializationStrategies;
    private String uuid;
    private final String uri;
    private final String exportedAddress;
    private final long timeout;
    private ClientInvoker client;
    private ServerInvoker server;

    public Manager(BundleContext context, IZKClient zooKeeper) throws Exception {
        this(context, zooKeeper, "tcp://0.0.0.0:2543", null, TimeUnit.MINUTES.toMillis(5L));
    }

    public Manager(BundleContext context, IZKClient zooKeeper, String uri, String exportedAddress, long timeout) throws Exception {
        this.exportedServices = new ConcurrentHashMap<ServiceReference, ExportRegistration>();
        this.listeners = new ConcurrentHashMap<ListenerHook.ListenerInfo, SimpleFilter>();
        this.serializationStrategies = new ConcurrentHashMap<String, SerializationStrategy>();
        this.remoteEndpoints = new CapabilitySet(Arrays.asList("objectClass", "endpoint.framework.uuid"), false);
        this.bundleContext = context;
        this.zooKeeper = zooKeeper;
        this.uri = uri;
        this.exportedAddress = exportedAddress;
        this.timeout = timeout;
    }

    public void init() throws Exception {
        this.client = new ClientInvokerImpl(this.queue, this.timeout, this.serializationStrategies);
        this.server = new ServerInvokerImpl(this.uri, this.queue, this.serializationStrategies);
        this.client.start();
        this.server.start();
        try {
            this.zooKeeper.createWithParents(DOSGI_REGISTRY, CreateMode.PERSISTENT);
        }
        catch (KeeperException.NodeExistsException e) {
            // empty catch block
        }
        this.tree = new ZooKeeperTreeTracker((org.linkedin.zookeeper.client.IZKClient)this.zooKeeper, (ZKDataReader)new ZKStringDataReader(), DOSGI_REGISTRY);
        this.tree.track((NodeEventsListener)this);
        this.uuid = Utils.getUUID(this.bundleContext);
        String filter = "(service.exported.interfaces=*)";
        this.bundleContext.addServiceListener((ServiceListener)this, filter);
        this.registration = this.bundleContext.registerService(new String[]{ListenerHook.class.getName(), EventHook.class.getName(), FindHook.class.getName()}, (Object)this, null);
        ServiceReference[] references = this.bundleContext.getServiceReferences((String)null, filter);
        if (references != null) {
            for (ServiceReference reference : references) {
                this.exportService(reference);
            }
        }
    }

    public void destroy() {
        for (Map<Long, ImportRegistration> registrations : this.importedServices.values()) {
            for (ImportRegistration registration : registrations.values()) {
                registration.getImportedService().unregister();
            }
        }
        for (ServiceReference reference : this.exportedServices.keySet()) {
            this.unExportService(reference);
        }
        this.server.stop();
        this.client.stop();
        this.tree.destroy();
        if (this.registration != null) {
            this.registration.unregister();
        }
        this.bundleContext.removeServiceListener((ServiceListener)this);
    }

    public void serviceChanged(ServiceEvent event) {
        ServiceReference reference = event.getServiceReference();
        switch (event.getType()) {
            case 1: {
                this.exportService(reference);
                break;
            }
            case 2: {
                this.updateService(reference);
                break;
            }
            case 4: {
                this.unExportService(reference);
            }
        }
    }

    public void added(Collection listenerInfos) {
        for (ListenerHook.ListenerInfo listenerInfo : listenerInfos) {
            if (listenerInfo.getBundleContext() == this.bundleContext || listenerInfo.getFilter() == null) continue;
            String filter = "(&" + listenerInfo.getFilter() + "(!(" + "endpoint.framework.uuid" + "=" + this.uuid + ")))";
            SimpleFilter exFilter = SimpleFilter.parse(filter);
            this.listeners.put(listenerInfo, exFilter);
            Set<EndpointDescription> matches = this.remoteEndpoints.match(exFilter);
            for (EndpointDescription endpoint : matches) {
                this.doImportService(endpoint, listenerInfo);
            }
        }
    }

    public void removed(Collection listenerInfos) {
        for (ListenerHook.ListenerInfo listenerInfo : listenerInfos) {
            if (listenerInfo.getBundleContext() == this.bundleContext || listenerInfo.getFilter() == null) continue;
            SimpleFilter exFilter = this.listeners.remove(listenerInfo);
            Set<EndpointDescription> matches = this.remoteEndpoints.match(exFilter);
            for (EndpointDescription endpoint : matches) {
                ImportRegistration registration;
                Map<Long, ImportRegistration> registrations = this.importedServices.get(endpoint);
                if (registrations == null || (registration = registrations.get(listenerInfo.getBundleContext().getBundle().getBundleId())) == null) continue;
                registration.removeReference(listenerInfo);
                if (registration.hasReferences()) continue;
                registration.getImportedService().unregister();
                registrations.remove(listenerInfo.getBundleContext().getBundle().getBundleId());
            }
        }
    }

    public void event(ServiceEvent event, Collection collection) {
        ServiceReference reference = event.getServiceReference();
        if (reference.getProperty("service.imported") != null && reference.getProperty(FABRIC_ADDRESS) != null) {
            Collection contexts = collection;
            Iterator iterator = contexts.iterator();
            while (iterator.hasNext()) {
                BundleContext context = (BundleContext)iterator.next();
                if (context == reference.getBundle().getBundleContext() || context == this.bundleContext) continue;
                iterator.remove();
            }
        }
    }

    public void find(BundleContext context, String name, String filter, boolean allServices, Collection collection) {
        Collection references = collection;
        Iterator iterator = references.iterator();
        while (iterator.hasNext()) {
            ServiceReference reference = (ServiceReference)iterator.next();
            if (reference.getProperty("service.imported") == null || reference.getProperty(FABRIC_ADDRESS) == null || context == reference.getBundle().getBundleContext() || context == this.bundleContext) continue;
            iterator.remove();
        }
    }

    public void onEvents(Collection<NodeEvent<String>> nodeEvents) {
        try {
            block7: for (NodeEvent<String> event : nodeEvents) {
                if (event.getDepth() == 0) continue;
                switch (event.getEventType()) {
                    case ADDED: {
                        EndpointDescription endpoint = Utils.getEndpointDescription((String)event.getData());
                        this.remoteEndpoints.addCapability(endpoint);
                        for (Map.Entry<ListenerHook.ListenerInfo, SimpleFilter> entry : this.listeners.entrySet()) {
                            if (!CapabilitySet.matches(endpoint, entry.getValue())) continue;
                            this.doImportService(endpoint, entry.getKey());
                        }
                        continue block7;
                    }
                    case UPDATED: {
                        EndpointDescription endpoint = Utils.getEndpointDescription((String)event.getData());
                        Map<Long, ImportRegistration> registrations = this.importedServices.get(endpoint);
                        if (registrations == null) continue block7;
                        for (ImportRegistration reg : registrations.values()) {
                            reg.importedService.setProperties(new Hashtable<String, Object>(endpoint.getProperties()));
                        }
                        continue block7;
                    }
                    case DELETED: {
                        EndpointDescription endpoint = Utils.getEndpointDescription((String)event.getData());
                        this.remoteEndpoints.removeCapability(endpoint);
                        Map<Long, ImportRegistration> registrations = this.importedServices.remove(endpoint);
                        if (registrations == null) break;
                        for (ImportRegistration reg : registrations.values()) {
                            reg.getImportedService().unregister();
                        }
                        break;
                    }
                }
            }
        }
        catch (Exception e) {
            LOGGER.info("Error when handling zookeeper events", (Throwable)e);
        }
    }

    protected void exportService(ServiceReference reference) {
        if (!this.exportedServices.containsKey(reference)) {
            try {
                ExportRegistration registration = this.doExportService(reference);
                if (registration != null) {
                    this.exportedServices.put(reference, registration);
                }
            }
            catch (Exception e) {
                LOGGER.info("Error when exporting endpoint", (Throwable)e);
            }
        }
    }

    protected void updateService(ServiceReference reference) {
        ExportRegistration registration = this.exportedServices.get(reference);
        if (registration == null) {
            // empty if block
        }
    }

    protected void unExportService(ServiceReference reference) {
        try {
            ExportRegistration registration = this.exportedServices.remove(reference);
            if (registration != null) {
                this.server.unregisterService(registration.getExportedEndpoint().getId());
                this.zooKeeper.delete(registration.getZooKeeperNode());
            }
        }
        catch (Exception e) {
            LOGGER.info("Error when unexporting endpoint", (Throwable)e);
        }
    }

    protected ExportRegistration doExportService(final ServiceReference reference) throws Exception {
        TreeMap<String, Object> properties = new TreeMap<String, Object>(String.CASE_INSENSITIVE_ORDER);
        for (String k : reference.getPropertyKeys()) {
            properties.put(k, reference.getProperty(k));
        }
        Set<String> intents = Utils.normalize(properties.get("service.exported.intents"));
        Set<String> extraIntents = Utils.normalize(properties.get("service.exported.intents.extra"));
        if (!intents.isEmpty() || !extraIntents.isEmpty()) {
            throw new UnsupportedOperationException();
        }
        Set<String> configs = Utils.normalize(properties.get("service.exported.configs"));
        if (configs.isEmpty()) {
            configs.add(CONFIG);
        } else if (!configs.contains(CONFIG)) {
            throw new UnsupportedOperationException();
        }
        URI connectUri = new URI(this.server.getConnectAddress());
        String fabricAddress = connectUri.getScheme() + "://" + this.exportedAddress + ":" + connectUri.getPort();
        properties.remove("service.exported.configs");
        properties.put("service.imported.configs", new String[]{CONFIG});
        properties.put("endpoint.framework.uuid", this.uuid);
        properties.put(FABRIC_ADDRESS, fabricAddress);
        String uuid = UuidGenerator.getUUID();
        properties.put("endpoint.id", uuid);
        EndpointDescription description = new EndpointDescription(properties);
        this.server.registerService(description.getId(), new ServerInvoker.ServiceFactory(){

            @Override
            public Object get() {
                return reference.getBundle().getBundleContext().getService(reference);
            }

            @Override
            public void unget() {
                reference.getBundle().getBundleContext().ungetService(reference);
            }
        }, AriesFrameworkUtil.getClassLoader(reference.getBundle()));
        String descStr = Utils.getEndpointDescriptionXML(description);
        String nodePath = this.zooKeeper.create("/fabric/dosgi/" + uuid, descStr, CreateMode.EPHEMERAL);
        return new ExportRegistration(reference, description, nodePath);
    }

    protected ImportRegistration doImportService(EndpointDescription endpoint, ListenerHook.ListenerInfo listener) {
        ImportRegistration reg;
        Map<Long, ImportRegistration> registrations = this.importedServices.get(endpoint);
        if (registrations == null) {
            registrations = new HashMap<Long, ImportRegistration>();
            this.importedServices.put(endpoint, registrations);
        }
        if ((reg = registrations.get(listener.getBundleContext().getBundle().getBundleId())) == null) {
            Bundle bundle = this.bundleContext.getBundle(listener.getBundleContext().getBundle().getBundleId());
            ServiceRegistration registration = bundle.getBundleContext().registerService(endpoint.getInterfaces().toArray(new String[endpoint.getInterfaces().size()]), (Object)new Factory(endpoint), new Hashtable<String, Object>(endpoint.getProperties()));
            reg = new ImportRegistration(registration, endpoint);
            registrations.put(listener.getBundleContext().getBundle().getBundleId(), reg);
        }
        reg.addReference(listener);
        return reg;
    }

    @Override
    public DispatchQueue queue() {
        return this.queue;
    }

    class Factory
    implements ServiceFactory {
        private final EndpointDescription description;

        Factory(EndpointDescription description) {
            this.description = description;
        }

        public Object getService(Bundle bundle, ServiceRegistration registration) {
            ClassLoader classLoader = AriesFrameworkUtil.getClassLoader(bundle);
            ArrayList interfaces = new ArrayList();
            for (String interfaceName : this.description.getInterfaces()) {
                try {
                    interfaces.add(classLoader.loadClass(interfaceName));
                }
                catch (ClassNotFoundException e) {}
            }
            String address = (String)this.description.getProperties().get(Manager.FABRIC_ADDRESS);
            InvocationHandler handler = Manager.this.client.getProxy(address, this.description.getId(), classLoader);
            return Proxy.newProxyInstance(classLoader, interfaces.toArray(new Class[interfaces.size()]), handler);
        }

        public void ungetService(Bundle bundle, ServiceRegistration registration, Object service) {
        }
    }
}

