/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.web.extender.war.internal;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import org.ops4j.lang.NullArgumentException;
import org.ops4j.lang.PreConditionException;
import org.ops4j.pax.swissbox.extender.BundleObserver;
import org.ops4j.pax.web.extender.war.internal.WebAppPublisher;
import org.ops4j.pax.web.extender.war.internal.WebEventDispatcher;
import org.ops4j.pax.web.extender.war.internal.WebXmlParser;
import org.ops4j.pax.web.extender.war.internal.model.WebApp;
import org.ops4j.pax.web.extender.war.internal.util.Path;
import org.ops4j.pax.web.service.spi.WarManager;
import org.ops4j.pax.web.service.spi.WebEvent;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class WebXmlObserver
implements BundleObserver<URL>,
WarManager {
    static final String UNDEPLOYED_STATE = "undeployed";
    static final String WAITING_STATE = "waiting";
    static final String DEPLOYED_STATE = "deployed";
    private static final Logger LOG = LoggerFactory.getLogger(WebXmlObserver.class);
    private final WebXmlParser m_parser;
    private final WebAppPublisher m_publisher;
    private final HashMap<Long, WebApp> webApps = new HashMap();
    private final HashMap<String, LinkedList<WebApp>> contexts = new HashMap();
    private final BundleContext bundleContext;
    private final WebEventDispatcher eventDispatcher;

    WebXmlObserver(WebXmlParser parser, WebAppPublisher publisher, WebEventDispatcher eventDispatcher, BundleContext bundleContext) {
        NullArgumentException.validateNotNull(parser, "Web.xml Parser");
        NullArgumentException.validateNotNull(publisher, "Web App Publisher");
        NullArgumentException.validateNotNull(eventDispatcher, "WebEvent Dispatcher");
        NullArgumentException.validateNotNull(bundleContext, "BundleContext");
        this.m_parser = parser;
        this.m_publisher = publisher;
        this.bundleContext = bundleContext;
        this.eventDispatcher = eventDispatcher;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addingEntries(Bundle bundle, List<URL> entries) {
        NullArgumentException.validateNotNull(bundle, "Bundle");
        NullArgumentException.validateNotNull(entries, "List of web.xml's");
        ClassLoader previous = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
        String contextName = this.extractContextName(bundle);
        LOG.info(String.format("Using [%s] as web application context name", contextName));
        try {
            PreConditionException.validateEqualTo(entries.size(), 1L, "Number of xml's");
            PreConditionException.validateEqualTo("WEB-INF".compareToIgnoreCase(Path.getDirectParent(entries.get(0))), 0L, "Direct parent of web.xml");
        }
        catch (PreConditionException pce) {
            LOG.error(pce.getMessage(), (Throwable)pce);
            this.eventDispatcher.webEvent(new WebEvent(5, "/" + contextName, bundle, this.bundleContext.getBundle(), (Throwable)pce));
            throw pce;
        }
        if (this.webApps.containsKey(bundle.getBundleId())) {
            LOG.debug(String.format("Already found a web application in bundle %d", bundle.getBundleId()));
            return;
        }
        URL webXmlURL = entries.get(0);
        LOG.debug("Parsing a web application from [" + webXmlURL + "]");
        String rootPath = this.extractRootPath(bundle);
        LOG.info(String.format("Using [%s] as web application root path", rootPath));
        InputStream is = null;
        try {
            is = webXmlURL.openStream();
            WebApp webApp = this.m_parser.parse(is);
            if (webApp != null) {
                LOG.debug("Parsed web app [" + webApp + "]");
                webApp.setWebXmlURL(webXmlURL);
                webApp.setBundle(bundle);
                webApp.setContextName(contextName);
                webApp.setRootPath(rootPath);
                webApp.setDeploymentState(UNDEPLOYED_STATE);
                this.webApps.put(bundle.getBundleId(), webApp);
                if ("true".equals(WebXmlObserver.opt(WebXmlObserver.getHeader(bundle, "Webapp-Deploy"), "true"))) {
                    this.deploy(webApp);
                } else {
                    this.eventDispatcher.webEvent(new WebEvent(4, "/" + webApp.getContextName(), webApp.getBundle(), this.bundleContext.getBundle()));
                }
            }
        }
        catch (Exception ignore) {
            LOG.error("Could not parse web.xml", (Throwable)ignore);
            this.eventDispatcher.webEvent(new WebEvent(5, "/" + contextName, bundle, this.bundleContext.getBundle(), (Throwable)ignore));
        }
        finally {
            Thread.currentThread().setContextClassLoader(previous);
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException ignore) {}
            }
        }
    }

    private void deploy(WebApp webApp) {
        Bundle bundle = webApp.getBundle();
        URL webXmlURL = webApp.getWebXmlURL();
        String contextName = webApp.getContextName();
        this.eventDispatcher.webEvent(new WebEvent(1, "/" + contextName, bundle, this.bundleContext.getBundle()));
        if (!this.contexts.containsKey(contextName)) {
            LinkedList<WebApp> queue = new LinkedList<WebApp>();
            this.contexts.put(contextName, queue);
            queue.add(webApp);
            webApp.setDeploymentState(DEPLOYED_STATE);
            this.m_publisher.publish(webApp);
            this.eventDispatcher.webEvent(new WebEvent(2, "/" + contextName, bundle, this.bundleContext.getBundle()));
        } else {
            LinkedList<WebApp> queue = this.contexts.get(contextName);
            queue.add(webApp);
            LinkedList<Long> duplicateIds = new LinkedList<Long>();
            for (WebApp duplicateWebApp : queue) {
                duplicateIds.add(duplicateWebApp.getBundle().getBundleId());
            }
            webApp.setDeploymentState(WAITING_STATE);
            this.eventDispatcher.webEvent(new WebEvent(6, "/" + contextName, bundle, this.bundleContext.getBundle(), duplicateIds));
        }
    }

    @Override
    public void removingEntries(Bundle bundle, List<URL> entries) {
        WebApp webApp = this.webApps.remove(bundle.getBundleId());
        if (webApp != null && webApp.getDeploymentState() != UNDEPLOYED_STATE) {
            this.undeploy(webApp);
        }
    }

    private void undeploy(WebApp webApp) {
        String contextName = webApp.getContextName();
        LinkedList<WebApp> queue = this.contexts.get(contextName);
        if (queue != null) {
            if (queue.get(0) == webApp) {
                webApp.setDeploymentState(UNDEPLOYED_STATE);
                this.eventDispatcher.webEvent(new WebEvent(3, "/" + contextName, webApp.getBundle(), this.bundleContext.getBundle()));
                this.m_publisher.unpublish(webApp);
                this.eventDispatcher.webEvent(new WebEvent(4, "/" + contextName, webApp.getBundle(), this.bundleContext.getBundle()));
                queue.removeFirst();
                LOG.debug("Check for a waiting webapp.");
                if (!queue.isEmpty()) {
                    LOG.debug("Found another bundle waiting for the context");
                    WebApp next = queue.getFirst();
                    next.setDeploymentState(DEPLOYED_STATE);
                    this.eventDispatcher.webEvent(new WebEvent(1, "/" + contextName, next.getBundle(), this.bundleContext.getBundle()));
                    this.m_publisher.publish(next);
                    this.eventDispatcher.webEvent(new WebEvent(2, "/" + contextName, next.getBundle(), this.bundleContext.getBundle()));
                } else {
                    this.contexts.remove(contextName);
                }
            } else if (queue.remove(webApp)) {
                webApp.setDeploymentState(UNDEPLOYED_STATE);
                this.eventDispatcher.webEvent(new WebEvent(4, "/" + contextName, webApp.getBundle(), this.bundleContext.getBundle()));
            } else {
                LOG.debug("Web application was not in the deployment queue");
            }
        } else {
            LOG.debug(String.format("No web application published under context: %s", contextName));
        }
    }

    public int start(long bundleId, String contextName) {
        WebApp webApp = this.webApps.get(bundleId);
        if (webApp == null) {
            return 2;
        }
        if (webApp.getDeploymentState() != UNDEPLOYED_STATE) {
            return 3;
        }
        if (contextName != null) {
            webApp.setContextName(contextName);
        }
        this.deploy(webApp);
        return 0;
    }

    public int stop(long bundleId) {
        WebApp webApp = this.webApps.get(bundleId);
        if (webApp == null) {
            return 2;
        }
        if (webApp.getDeploymentState() == UNDEPLOYED_STATE) {
            return 4;
        }
        this.undeploy(webApp);
        return 0;
    }

    private String extractRootPath(Bundle bundle) {
        String rootPath = WebXmlObserver.getHeader(bundle, "Webapp-Root");
        if (rootPath == null) {
            LOG.debug("No 'Webapp-Root' manifest attribute specified");
            rootPath = "";
        }
        rootPath = WebXmlObserver.stripPrefix(rootPath, "/");
        rootPath = WebXmlObserver.stripSuffix(rootPath, "/");
        rootPath = rootPath.trim();
        return rootPath;
    }

    private static String stripPrefix(String value, String prefix) {
        if (value.startsWith(prefix)) {
            return value.substring(prefix.length());
        }
        return value;
    }

    private static <T> T opt(T value, T orElse) {
        if (value == null) {
            return orElse;
        }
        return value;
    }

    private static String stripSuffix(String value, String suffix) {
        if (value.endsWith(suffix)) {
            return value.substring(0, value.length() - suffix.length());
        }
        return value;
    }

    private static String getHeader(Bundle bundle, String ... keys) {
        Bundle[] bundles;
        Dictionary headers = bundle.getHeaders();
        for (String key : keys) {
            String value = (String)headers.get(key);
            if (value == null) continue;
            return value;
        }
        for (Bundle fragment : bundles = bundle.getBundleContext().getBundles()) {
            if (fragment.getState() != 4) continue;
            headers = fragment.getHeaders();
            for (String key : keys) {
                String value = (String)headers.get(key);
                if (value == null) continue;
                return value;
            }
        }
        return null;
    }

    private String extractContextName(Bundle bundle) {
        String contextName = WebXmlObserver.getHeader(bundle, "Web-ContextPath", "Webapp-Context");
        if (contextName == null) {
            LOG.debug("No 'Web-ContextPath' or 'Webapp-Context' manifest attribute specified");
            String symbolicName = bundle.getSymbolicName();
            if (symbolicName == null) {
                contextName = String.valueOf(bundle.getBundleId());
                LOG.debug(String.format("Using bundle id [%s] as context name", contextName));
            } else {
                contextName = symbolicName;
                LOG.debug(String.format("Using bundle symbolic name [%s] as context name", contextName));
            }
        }
        if ((contextName = contextName.trim()).startsWith("/")) {
            contextName = contextName.substring(1);
        }
        return contextName;
    }
}

