/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.cluster.settings;

import java.io.IOException;
import java.util.Map;
import org.elasticsearch.ElasticSearchGenerationException;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ValidateActions;
import org.elasticsearch.action.support.master.MasterNodeOperationRequest;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.settings.ImmutableSettings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.common.xcontent.XContentType;

public class ClusterUpdateSettingsRequest
extends MasterNodeOperationRequest {
    private Settings transientSettings = ImmutableSettings.Builder.EMPTY_SETTINGS;
    private Settings persistentSettings = ImmutableSettings.Builder.EMPTY_SETTINGS;

    @Override
    public ActionRequestValidationException validate() {
        ActionRequestValidationException validationException = null;
        if (this.transientSettings.getAsMap().isEmpty() && this.persistentSettings.getAsMap().isEmpty()) {
            validationException = ValidateActions.addValidationError("no settings to update", validationException);
        }
        return validationException;
    }

    Settings transientSettings() {
        return this.transientSettings;
    }

    Settings persistentSettings() {
        return this.persistentSettings;
    }

    public ClusterUpdateSettingsRequest transientSettings(Settings settings) {
        this.transientSettings = settings;
        return this;
    }

    public ClusterUpdateSettingsRequest transientSettings(Settings.Builder settings) {
        this.transientSettings = settings.build();
        return this;
    }

    public ClusterUpdateSettingsRequest transientSettings(String source) {
        this.transientSettings = ImmutableSettings.settingsBuilder().loadFromSource(source).build();
        return this;
    }

    public ClusterUpdateSettingsRequest transientSettings(Map source) {
        try {
            XContentBuilder builder = XContentFactory.contentBuilder(XContentType.JSON);
            builder.map(source);
            this.transientSettings(builder.string());
        }
        catch (IOException e) {
            throw new ElasticSearchGenerationException("Failed to generate [" + source + "]", e);
        }
        return this;
    }

    public ClusterUpdateSettingsRequest persistentSettings(Settings settings) {
        this.persistentSettings = settings;
        return this;
    }

    public ClusterUpdateSettingsRequest persistentSettings(Settings.Builder settings) {
        this.persistentSettings = settings.build();
        return this;
    }

    public ClusterUpdateSettingsRequest persistentSettings(String source) {
        this.persistentSettings = ImmutableSettings.settingsBuilder().loadFromSource(source).build();
        return this;
    }

    public ClusterUpdateSettingsRequest persistentSettings(Map source) {
        try {
            XContentBuilder builder = XContentFactory.contentBuilder(XContentType.JSON);
            builder.map(source);
            this.persistentSettings(builder.string());
        }
        catch (IOException e) {
            throw new ElasticSearchGenerationException("Failed to generate [" + source + "]", e);
        }
        return this;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        this.transientSettings = ImmutableSettings.readSettingsFromStream(in);
        this.persistentSettings = ImmutableSettings.readSettingsFromStream(in);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        ImmutableSettings.writeSettingsToStream(this.transientSettings, out);
        ImmutableSettings.writeSettingsToStream(this.persistentSettings, out);
    }
}

