/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.indices.alias;

import java.util.HashSet;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicReference;
import org.elasticsearch.ElasticSearchException;
import org.elasticsearch.action.admin.indices.alias.IndicesAliasesRequest;
import org.elasticsearch.action.admin.indices.alias.IndicesAliasesResponse;
import org.elasticsearch.action.support.master.TransportMasterNodeOperationAction;
import org.elasticsearch.cluster.ClusterService;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.AliasAction;
import org.elasticsearch.cluster.metadata.MetaDataIndexAliasesService;
import org.elasticsearch.common.collect.Sets;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

public class TransportIndicesAliasesAction
extends TransportMasterNodeOperationAction<IndicesAliasesRequest, IndicesAliasesResponse> {
    private final MetaDataIndexAliasesService indexAliasesService;

    @Inject
    public TransportIndicesAliasesAction(Settings settings, TransportService transportService, ClusterService clusterService, ThreadPool threadPool, MetaDataIndexAliasesService indexAliasesService) {
        super(settings, transportService, clusterService, threadPool);
        this.indexAliasesService = indexAliasesService;
    }

    @Override
    protected String executor() {
        return "management";
    }

    @Override
    protected String transportAction() {
        return "indices/aliases";
    }

    @Override
    protected IndicesAliasesRequest newRequest() {
        return new IndicesAliasesRequest();
    }

    @Override
    protected IndicesAliasesResponse newResponse() {
        return new IndicesAliasesResponse();
    }

    @Override
    protected ClusterBlockException checkBlock(IndicesAliasesRequest request, ClusterState state) {
        HashSet<String> indices = Sets.newHashSet();
        for (AliasAction aliasAction : request.aliasActions()) {
            indices.add(aliasAction.index());
        }
        return state.blocks().indicesBlockedException(ClusterBlockLevel.METADATA, indices.toArray(new String[indices.size()]));
    }

    @Override
    protected IndicesAliasesResponse masterOperation(IndicesAliasesRequest request, ClusterState state) throws ElasticSearchException {
        final AtomicReference responseRef = new AtomicReference();
        final AtomicReference<InterruptedException> failureRef = new AtomicReference<InterruptedException>();
        final CountDownLatch latch = new CountDownLatch(1);
        this.indexAliasesService.indicesAliases(new MetaDataIndexAliasesService.Request(request.aliasActions().toArray(new AliasAction[request.aliasActions().size()]), request.timeout()), new MetaDataIndexAliasesService.Listener(){

            @Override
            public void onResponse(MetaDataIndexAliasesService.Response response) {
                responseRef.set(new IndicesAliasesResponse(response.acknowledged()));
                latch.countDown();
            }

            @Override
            public void onFailure(Throwable t) {
                failureRef.set(t);
                latch.countDown();
            }
        });
        try {
            latch.await();
        }
        catch (InterruptedException e) {
            failureRef.set(e);
        }
        if (failureRef.get() != null) {
            if (failureRef.get() instanceof ElasticSearchException) {
                throw (ElasticSearchException)failureRef.get();
            }
            throw new ElasticSearchException(((Throwable)failureRef.get()).getMessage(), (Throwable)failureRef.get());
        }
        return (IndicesAliasesResponse)responseRef.get();
    }
}

