/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.bulk;

import java.io.IOException;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.delete.DeleteResponse;
import org.elasticsearch.action.index.IndexResponse;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Streamable;

public class BulkItemResponse
implements Streamable {
    private int id;
    private String opType;
    private ActionResponse response;
    private Failure failure;

    BulkItemResponse() {
    }

    public BulkItemResponse(int id, String opType, ActionResponse response) {
        this.id = id;
        this.opType = opType;
        this.response = response;
    }

    public BulkItemResponse(int id, String opType, Failure failure) {
        this.id = id;
        this.opType = opType;
        this.failure = failure;
    }

    public int itemId() {
        return this.id;
    }

    public String opType() {
        return this.opType;
    }

    public String index() {
        if (this.failure != null) {
            return this.failure.index();
        }
        if (this.response instanceof IndexResponse) {
            return ((IndexResponse)this.response).index();
        }
        if (this.response instanceof DeleteResponse) {
            return ((DeleteResponse)this.response).index();
        }
        return null;
    }

    public String getIndex() {
        return this.index();
    }

    public String type() {
        if (this.failure != null) {
            return this.failure.type();
        }
        if (this.response instanceof IndexResponse) {
            return ((IndexResponse)this.response).type();
        }
        if (this.response instanceof DeleteResponse) {
            return ((DeleteResponse)this.response).type();
        }
        return null;
    }

    public String getType() {
        return this.type();
    }

    public String id() {
        if (this.failure != null) {
            return this.failure.id();
        }
        if (this.response instanceof IndexResponse) {
            return ((IndexResponse)this.response).id();
        }
        if (this.response instanceof DeleteResponse) {
            return ((DeleteResponse)this.response).id();
        }
        return null;
    }

    public String getId() {
        return this.id();
    }

    public long version() {
        if (this.failure != null) {
            return -1L;
        }
        if (this.response instanceof IndexResponse) {
            return ((IndexResponse)this.response).version();
        }
        if (this.response instanceof DeleteResponse) {
            return ((DeleteResponse)this.response).version();
        }
        return -1L;
    }

    public <T extends ActionResponse> T response() {
        return (T)this.response;
    }

    public boolean failed() {
        return this.failure != null;
    }

    public boolean isFailed() {
        return this.failed();
    }

    public String failureMessage() {
        if (this.failure != null) {
            return this.failure.message();
        }
        return null;
    }

    public String getFailureMessage() {
        return this.failureMessage();
    }

    public Failure failure() {
        return this.failure;
    }

    public Failure getFailure() {
        return this.failure();
    }

    public static BulkItemResponse readBulkItem(StreamInput in) throws IOException {
        BulkItemResponse response = new BulkItemResponse();
        response.readFrom(in);
        return response;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        this.id = in.readVInt();
        this.opType = in.readUTF();
        byte type = in.readByte();
        if (type == 0) {
            this.response = new IndexResponse();
            this.response.readFrom(in);
        } else if (type == 1) {
            this.response = new DeleteResponse();
            this.response.readFrom(in);
        }
        if (in.readBoolean()) {
            this.failure = new Failure(in.readUTF(), in.readUTF(), in.readUTF(), in.readUTF());
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeVInt(this.id);
        out.writeUTF(this.opType);
        if (this.response == null) {
            out.writeByte((byte)2);
        } else {
            if (this.response instanceof IndexResponse) {
                out.writeByte((byte)0);
            } else if (this.response instanceof DeleteResponse) {
                out.writeByte((byte)1);
            }
            this.response.writeTo(out);
        }
        if (this.failure == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            out.writeUTF(this.failure.index());
            out.writeUTF(this.failure.type());
            out.writeUTF(this.failure.id());
            out.writeUTF(this.failure.message());
        }
    }

    public static class Failure {
        private final String index;
        private final String type;
        private final String id;
        private final String message;

        public Failure(String index, String type, String id, String message) {
            this.index = index;
            this.type = type;
            this.id = id;
            this.message = message;
        }

        public String index() {
            return this.index;
        }

        public String getIndex() {
            return this.index();
        }

        public String type() {
            return this.type;
        }

        public String getType() {
            return this.type();
        }

        public String id() {
            return this.id;
        }

        public String getId() {
            return this.id;
        }

        public String message() {
            return this.message;
        }

        public String getMessage() {
            return this.message();
        }
    }
}

