/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.bulk;

import java.io.IOException;
import java.util.List;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ValidateActions;
import org.elasticsearch.action.WriteConsistencyLevel;
import org.elasticsearch.action.delete.DeleteRequest;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.support.replication.ReplicationType;
import org.elasticsearch.action.support.replication.ShardReplicationOperationRequest;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.collect.Lists;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.xcontent.XContent;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.index.VersionType;

public class BulkRequest
implements ActionRequest {
    final List<ActionRequest> requests = Lists.newArrayList();
    private boolean listenerThreaded = false;
    private ReplicationType replicationType = ReplicationType.DEFAULT;
    private WriteConsistencyLevel consistencyLevel = WriteConsistencyLevel.DEFAULT;
    private boolean refresh = false;

    public BulkRequest add(IndexRequest request) {
        request.beforeLocalFork();
        return this.internalAdd(request);
    }

    private BulkRequest internalAdd(IndexRequest request) {
        this.requests.add(request);
        return this;
    }

    public BulkRequest add(DeleteRequest request) {
        this.requests.add(request);
        return this;
    }

    public BulkRequest add(byte[] data, int from, int length, boolean contentUnsafe) throws Exception {
        return this.add(data, from, length, contentUnsafe, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BulkRequest add(byte[] data, int from, int length, boolean contentUnsafe, @Nullable String defaultIndex, @Nullable String defaultType) throws Exception {
        int nextMarker;
        XContent xContent = XContentFactory.xContent(data, from, length);
        byte marker = xContent.streamSeparator();
        while ((nextMarker = this.findNextMarker(marker, from, data, length)) != -1) {
            XContentParser parser = xContent.createParser(data, from, nextMarker - from);
            try {
                from = nextMarker + 1;
                XContentParser.Token token = parser.nextToken();
                if (token == null) continue;
                assert (token == XContentParser.Token.START_OBJECT);
                token = parser.nextToken();
                assert (token == XContentParser.Token.FIELD_NAME);
                String action = parser.currentName();
                String index = defaultIndex;
                String type = defaultType;
                String id = null;
                String routing = null;
                String parent = null;
                String timestamp = null;
                Long ttl = null;
                String opType = null;
                long version = 0L;
                VersionType versionType = VersionType.INTERNAL;
                String percolate = null;
                String currentFieldName = null;
                while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                    if (token == XContentParser.Token.FIELD_NAME) {
                        currentFieldName = parser.currentName();
                        continue;
                    }
                    if (!token.isValue()) continue;
                    if ("_index".equals(currentFieldName)) {
                        index = parser.text();
                        continue;
                    }
                    if ("_type".equals(currentFieldName)) {
                        type = parser.text();
                        continue;
                    }
                    if ("_id".equals(currentFieldName)) {
                        id = parser.text();
                        continue;
                    }
                    if ("_routing".equals(currentFieldName) || "routing".equals(currentFieldName)) {
                        routing = parser.text();
                        continue;
                    }
                    if ("_parent".equals(currentFieldName) || "parent".equals(currentFieldName)) {
                        parent = parser.text();
                        continue;
                    }
                    if ("_timestamp".equals(currentFieldName) || "timestamp".equals(currentFieldName)) {
                        timestamp = parser.text();
                        continue;
                    }
                    if ("_ttl".equals(currentFieldName) || "ttl".equals(currentFieldName)) {
                        if (parser.currentToken() == XContentParser.Token.VALUE_STRING) {
                            ttl = TimeValue.parseTimeValue(parser.text(), null).millis();
                            continue;
                        }
                        ttl = parser.longValue();
                        continue;
                    }
                    if ("op_type".equals(currentFieldName) || "opType".equals(currentFieldName)) {
                        opType = parser.text();
                        continue;
                    }
                    if ("_version".equals(currentFieldName) || "version".equals(currentFieldName)) {
                        version = parser.longValue();
                        continue;
                    }
                    if ("_version_type".equals(currentFieldName) || "_versionType".equals(currentFieldName) || "version_type".equals(currentFieldName) || "versionType".equals(currentFieldName)) {
                        versionType = VersionType.fromString(parser.text());
                        continue;
                    }
                    if (!"percolate".equals(currentFieldName) && !"_percolate".equals(currentFieldName)) continue;
                    percolate = parser.textOrNull();
                }
                if ("delete".equals(action)) {
                    this.add(new DeleteRequest(index, type, id).parent(parent).version(version).versionType(versionType).routing(routing));
                    continue;
                }
                nextMarker = this.findNextMarker(marker, from, data, length);
                if (nextMarker == -1) break;
                if ("index".equals(action)) {
                    if (opType == null) {
                        this.internalAdd(new IndexRequest(index, type, id).routing(routing).parent(parent).timestamp(timestamp).ttl(ttl).version(version).versionType(versionType).source(data, from, nextMarker - from, contentUnsafe).percolate(percolate));
                    } else {
                        this.internalAdd(new IndexRequest(index, type, id).routing(routing).parent(parent).timestamp(timestamp).ttl(ttl).version(version).versionType(versionType).create("create".equals(opType)).source(data, from, nextMarker - from, contentUnsafe).percolate(percolate));
                    }
                } else if ("create".equals(action)) {
                    this.internalAdd(new IndexRequest(index, type, id).routing(routing).parent(parent).timestamp(timestamp).ttl(ttl).version(version).versionType(versionType).create(true).source(data, from, nextMarker - from, contentUnsafe).percolate(percolate));
                }
                from = nextMarker + 1;
            }
            finally {
                parser.close();
            }
        }
        return this;
    }

    public BulkRequest consistencyLevel(WriteConsistencyLevel consistencyLevel) {
        this.consistencyLevel = consistencyLevel;
        return this;
    }

    public WriteConsistencyLevel consistencyLevel() {
        return this.consistencyLevel;
    }

    public BulkRequest refresh(boolean refresh) {
        this.refresh = refresh;
        return this;
    }

    public boolean refresh() {
        return this.refresh;
    }

    public BulkRequest replicationType(ReplicationType replicationType) {
        this.replicationType = replicationType;
        return this;
    }

    public ReplicationType replicationType() {
        return this.replicationType;
    }

    private int findNextMarker(byte marker, int from, byte[] data, int length) {
        for (int i = from; i < length; ++i) {
            if (data[i] != marker) continue;
            return i;
        }
        return -1;
    }

    public int numberOfActions() {
        return this.requests.size();
    }

    @Override
    public ActionRequestValidationException validate() {
        ActionRequestValidationException validationException = null;
        if (this.requests.isEmpty()) {
            validationException = ValidateActions.addValidationError("no requests added", validationException);
        }
        for (int i = 0; i < this.requests.size(); ++i) {
            ActionRequestValidationException ex = this.requests.get(i).validate();
            if (ex == null) continue;
            if (validationException == null) {
                validationException = new ActionRequestValidationException();
            }
            validationException.addValidationErrors(ex.validationErrors());
        }
        return validationException;
    }

    @Override
    public boolean listenerThreaded() {
        return this.listenerThreaded;
    }

    @Override
    public BulkRequest listenerThreaded(boolean listenerThreaded) {
        this.listenerThreaded = listenerThreaded;
        return this;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        this.replicationType = ReplicationType.fromId(in.readByte());
        this.consistencyLevel = WriteConsistencyLevel.fromId(in.readByte());
        int size = in.readVInt();
        for (int i = 0; i < size; ++i) {
            ShardReplicationOperationRequest request;
            byte type = in.readByte();
            if (type == 0) {
                request = new IndexRequest();
                ((IndexRequest)request).readFrom(in);
                this.requests.add(request);
                continue;
            }
            if (type != 1) continue;
            request = new DeleteRequest();
            ((DeleteRequest)request).readFrom(in);
            this.requests.add(request);
        }
        this.refresh = in.readBoolean();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeByte(this.replicationType.id());
        out.writeByte(this.consistencyLevel.id());
        out.writeVInt(this.requests.size());
        for (ActionRequest request : this.requests) {
            if (request instanceof IndexRequest) {
                out.writeByte((byte)0);
            } else if (request instanceof DeleteRequest) {
                out.writeByte((byte)1);
            }
            request.writeTo(out);
        }
        out.writeBoolean(this.refresh);
    }
}

