/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.search;

import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.search.SearchOperationThreading;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.search.SearchScrollRequest;
import org.elasticsearch.action.support.BaseRequestBuilder;
import org.elasticsearch.client.Client;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.search.Scroll;

public class SearchScrollRequestBuilder
extends BaseRequestBuilder<SearchScrollRequest, SearchResponse> {
    public SearchScrollRequestBuilder(Client client) {
        super(client, new SearchScrollRequest());
    }

    public SearchScrollRequestBuilder(Client client, String scrollId) {
        super(client, new SearchScrollRequest(scrollId));
    }

    public SearchScrollRequestBuilder setOperationThreading(SearchOperationThreading operationThreading) {
        ((SearchScrollRequest)this.request).operationThreading(operationThreading);
        return this;
    }

    public SearchScrollRequestBuilder listenerThreaded(boolean threadedListener) {
        ((SearchScrollRequest)this.request).listenerThreaded(threadedListener);
        return this;
    }

    public SearchScrollRequestBuilder setScrollId(String scrollId) {
        ((SearchScrollRequest)this.request).scrollId(scrollId);
        return this;
    }

    public SearchScrollRequestBuilder setScroll(Scroll scroll) {
        ((SearchScrollRequest)this.request).scroll(scroll);
        return this;
    }

    public SearchScrollRequestBuilder setScroll(TimeValue keepAlive) {
        ((SearchScrollRequest)this.request).scroll(keepAlive);
        return this;
    }

    public SearchScrollRequestBuilder setScroll(String keepAlive) {
        ((SearchScrollRequest)this.request).scroll(keepAlive);
        return this;
    }

    @Override
    protected void doExecute(ActionListener<SearchResponse> listener) {
        this.client.searchScroll((SearchScrollRequest)this.request, listener);
    }
}

