/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.search;

import org.elasticsearch.ElasticSearchIllegalArgumentException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.search.SearchScrollRequest;
import org.elasticsearch.action.search.type.ParsedScrollId;
import org.elasticsearch.action.search.type.TransportSearchHelper;
import org.elasticsearch.action.search.type.TransportSearchScrollQueryAndFetchAction;
import org.elasticsearch.action.search.type.TransportSearchScrollQueryThenFetchAction;
import org.elasticsearch.action.search.type.TransportSearchScrollScanAction;
import org.elasticsearch.action.support.TransportAction;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.BaseTransportRequestHandler;
import org.elasticsearch.transport.TransportChannel;
import org.elasticsearch.transport.TransportService;

public class TransportSearchScrollAction
extends TransportAction<SearchScrollRequest, SearchResponse> {
    private final TransportSearchScrollQueryThenFetchAction queryThenFetchAction;
    private final TransportSearchScrollQueryAndFetchAction queryAndFetchAction;
    private final TransportSearchScrollScanAction scanAction;

    @Inject
    public TransportSearchScrollAction(Settings settings, ThreadPool threadPool, TransportService transportService, TransportSearchScrollQueryThenFetchAction queryThenFetchAction, TransportSearchScrollQueryAndFetchAction queryAndFetchAction, TransportSearchScrollScanAction scanAction) {
        super(settings, threadPool);
        this.queryThenFetchAction = queryThenFetchAction;
        this.queryAndFetchAction = queryAndFetchAction;
        this.scanAction = scanAction;
        transportService.registerHandler("search/scroll", new TransportHandler());
    }

    @Override
    protected void doExecute(SearchScrollRequest request, ActionListener<SearchResponse> listener) {
        block5: {
            try {
                ParsedScrollId scrollId = TransportSearchHelper.parseScrollId(request.scrollId());
                if (scrollId.type().equals("queryThenFetch")) {
                    this.queryThenFetchAction.execute(request, scrollId, listener);
                    break block5;
                }
                if (scrollId.type().equals("queryAndFetch")) {
                    this.queryAndFetchAction.execute(request, scrollId, listener);
                    break block5;
                }
                if (scrollId.type().equals("scan")) {
                    this.scanAction.execute(request, scrollId, listener);
                    break block5;
                }
                throw new ElasticSearchIllegalArgumentException("Scroll id type [" + scrollId.type() + "] unrecognized");
            }
            catch (Exception e) {
                listener.onFailure(e);
            }
        }
    }

    private class TransportHandler
    extends BaseTransportRequestHandler<SearchScrollRequest> {
        private TransportHandler() {
        }

        @Override
        public SearchScrollRequest newInstance() {
            return new SearchScrollRequest();
        }

        @Override
        public void messageReceived(SearchScrollRequest request, final TransportChannel channel) throws Exception {
            TransportSearchScrollAction.this.execute(request, new ActionListener<SearchResponse>(){

                @Override
                public void onResponse(SearchResponse result) {
                    try {
                        channel.sendResponse(result);
                    }
                    catch (Exception e) {
                        this.onFailure(e);
                    }
                }

                @Override
                public void onFailure(Throwable e) {
                    try {
                        channel.sendResponse(e);
                    }
                    catch (Exception e1) {
                        TransportSearchScrollAction.this.logger.warn("Failed to send response for search", e1, new Object[0]);
                    }
                }
            });
        }

        @Override
        public String executor() {
            return "same";
        }
    }
}

