/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.routing.allocation.decider;

import org.elasticsearch.cluster.routing.RoutingNode;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.cluster.routing.allocation.RoutingAllocation;
import org.elasticsearch.common.component.AbstractComponent;
import org.elasticsearch.common.settings.Settings;

public abstract class AllocationDecider
extends AbstractComponent {
    protected AllocationDecider(Settings settings) {
        super(settings);
    }

    public boolean canRebalance(ShardRouting shardRouting, RoutingAllocation allocation) {
        return true;
    }

    public Decision canAllocate(ShardRouting shardRouting, RoutingNode node, RoutingAllocation allocation) {
        return Decision.YES;
    }

    public boolean canRemain(ShardRouting shardRouting, RoutingNode node, RoutingAllocation allocation) {
        return true;
    }

    public static enum Decision {
        YES{

            @Override
            public boolean allocate() {
                return true;
            }
        }
        ,
        NO{

            @Override
            public boolean allocate() {
                return false;
            }
        }
        ,
        THROTTLE{

            @Override
            public boolean allocate() {
                return false;
            }
        };


        public abstract boolean allocate();
    }
}

