/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.routing.allocation.decider;

import java.util.List;
import org.elasticsearch.cluster.routing.MutableShardRouting;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.cluster.routing.allocation.RoutingAllocation;
import org.elasticsearch.cluster.routing.allocation.decider.AllocationDecider;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;

public class RebalanceOnlyWhenActiveAllocationDecider
extends AllocationDecider {
    @Inject
    public RebalanceOnlyWhenActiveAllocationDecider(Settings settings) {
        super(settings);
    }

    @Override
    public boolean canRebalance(ShardRouting shardRouting, RoutingAllocation allocation) {
        List<MutableShardRouting> shards = allocation.routingNodes().shardsRoutingFor(shardRouting);
        for (int i = 0; i < shards.size(); ++i) {
            if (shards.get(i).active()) continue;
            return false;
        }
        return true;
    }
}

