/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.io.stream;

import java.io.IOException;
import java.lang.ref.SoftReference;
import java.util.Queue;
import java.util.concurrent.atomic.AtomicInteger;
import org.elasticsearch.common.io.stream.BytesStreamOutput;
import org.elasticsearch.common.io.stream.HandlesStreamOutput;
import org.elasticsearch.common.io.stream.LZFStreamOutput;
import org.elasticsearch.common.util.concurrent.jsr166y.LinkedTransferQueue;

public class CachedStreamOutput {
    private static final SoftWrapper<Queue<Entry>> cache = new SoftWrapper();
    private static final AtomicInteger counter = new AtomicInteger();
    public static int BYTES_LIMIT = 0x100000;
    public static int COUNT_LIMIT = 100;

    private static Entry newEntry() {
        BytesStreamOutput bytes = new BytesStreamOutput();
        HandlesStreamOutput handles = new HandlesStreamOutput(bytes);
        return new Entry(bytes, handles);
    }

    public static void clear() {
        cache.clear();
    }

    public static Entry popEntry() {
        Queue<Entry> ref = cache.get();
        if (ref == null) {
            return CachedStreamOutput.newEntry();
        }
        Entry entry = ref.poll();
        if (entry == null) {
            return CachedStreamOutput.newEntry();
        }
        counter.decrementAndGet();
        return entry;
    }

    public static void pushEntry(Entry entry) {
        if (entry.bytes().underlyingBytes().length > BYTES_LIMIT) {
            return;
        }
        Queue<Entry> ref = cache.get();
        if (ref == null) {
            ref = new LinkedTransferQueue<Entry>();
            counter.set(0);
            cache.set(ref);
        }
        if (counter.incrementAndGet() > COUNT_LIMIT) {
            counter.decrementAndGet();
        } else {
            ref.add(entry);
        }
    }

    static class SoftWrapper<T> {
        private SoftReference<T> ref;

        public void set(T ref) {
            this.ref = new SoftReference<T>(ref);
        }

        public T get() {
            return this.ref == null ? null : (T)this.ref.get();
        }

        public void clear() {
            this.ref = null;
        }
    }

    public static class Entry {
        private final BytesStreamOutput bytes;
        private final HandlesStreamOutput handles;
        private LZFStreamOutput lzf;

        Entry(BytesStreamOutput bytes, HandlesStreamOutput handles) {
            this.bytes = bytes;
            this.handles = handles;
        }

        private LZFStreamOutput lzf() {
            if (this.lzf == null) {
                this.lzf = new LZFStreamOutput(this.bytes, true);
            }
            return this.lzf;
        }

        public BytesStreamOutput bytes() {
            return this.bytes;
        }

        public BytesStreamOutput cachedBytes() {
            this.bytes.reset();
            return this.bytes;
        }

        public LZFStreamOutput cachedLZFBytes() throws IOException {
            LZFStreamOutput lzf = this.lzf();
            lzf.reset();
            return lzf;
        }

        public HandlesStreamOutput cachedHandlesLzfBytes() throws IOException {
            LZFStreamOutput lzf = this.lzf();
            this.handles.reset(lzf);
            return this.handles;
        }

        public HandlesStreamOutput cachedHandlesBytes() throws IOException {
            this.handles.reset(this.bytes);
            return this.handles;
        }
    }
}

