/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.gateway.local.state.meta;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReferenceArray;
import org.elasticsearch.ElasticSearchException;
import org.elasticsearch.action.ActionFuture;
import org.elasticsearch.action.FailedNodeException;
import org.elasticsearch.action.support.nodes.NodeOperationRequest;
import org.elasticsearch.action.support.nodes.NodeOperationResponse;
import org.elasticsearch.action.support.nodes.NodesOperationRequest;
import org.elasticsearch.action.support.nodes.NodesOperationResponse;
import org.elasticsearch.action.support.nodes.TransportNodesOperationAction;
import org.elasticsearch.cluster.ClusterName;
import org.elasticsearch.cluster.ClusterService;
import org.elasticsearch.cluster.metadata.MetaData;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.collect.Lists;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.gateway.local.state.meta.LocalGatewayMetaState;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

public class TransportNodesListGatewayMetaState
extends TransportNodesOperationAction<Request, NodesLocalGatewayMetaState, NodeRequest, NodeLocalGatewayMetaState> {
    private LocalGatewayMetaState metaState;

    @Inject
    public TransportNodesListGatewayMetaState(Settings settings, ClusterName clusterName, ThreadPool threadPool, ClusterService clusterService, TransportService transportService) {
        super(settings, clusterName, threadPool, clusterService, transportService);
    }

    TransportNodesListGatewayMetaState init(LocalGatewayMetaState metaState) {
        this.metaState = metaState;
        return this;
    }

    public ActionFuture<NodesLocalGatewayMetaState> list(Set<String> nodesIds, @Nullable TimeValue timeout) {
        return this.execute(new Request(nodesIds).timeout(timeout));
    }

    @Override
    protected String executor() {
        return "generic";
    }

    @Override
    protected String transportAction() {
        return "/gateway/local/meta-state";
    }

    @Override
    protected boolean transportCompress() {
        return true;
    }

    @Override
    protected Request newRequest() {
        return new Request();
    }

    @Override
    protected NodeRequest newNodeRequest() {
        return new NodeRequest();
    }

    @Override
    protected NodeRequest newNodeRequest(String nodeId, Request request) {
        return new NodeRequest(nodeId);
    }

    @Override
    protected NodeLocalGatewayMetaState newNodeResponse() {
        return new NodeLocalGatewayMetaState();
    }

    @Override
    protected NodesLocalGatewayMetaState newResponse(Request request, AtomicReferenceArray responses) {
        ArrayList<NodeLocalGatewayMetaState> nodesList = Lists.newArrayList();
        ArrayList<FailedNodeException> failures = Lists.newArrayList();
        for (int i = 0; i < responses.length(); ++i) {
            Object resp = responses.get(i);
            if (resp instanceof NodeLocalGatewayMetaState) {
                nodesList.add((NodeLocalGatewayMetaState)resp);
                continue;
            }
            if (!(resp instanceof FailedNodeException)) continue;
            failures.add((FailedNodeException)resp);
        }
        return new NodesLocalGatewayMetaState(this.clusterName, nodesList.toArray(new NodeLocalGatewayMetaState[nodesList.size()]), failures.toArray(new FailedNodeException[failures.size()]));
    }

    @Override
    protected NodeLocalGatewayMetaState nodeOperation(NodeRequest request) throws ElasticSearchException {
        return new NodeLocalGatewayMetaState(this.clusterService.localNode(), this.metaState.currentMetaData());
    }

    @Override
    protected boolean accumulateExceptions() {
        return true;
    }

    public static class NodeLocalGatewayMetaState
    extends NodeOperationResponse {
        private MetaData metaData;

        NodeLocalGatewayMetaState() {
        }

        public NodeLocalGatewayMetaState(DiscoveryNode node, MetaData metaData) {
            super(node);
            this.metaData = metaData;
        }

        public MetaData metaData() {
            return this.metaData;
        }

        @Override
        public void readFrom(StreamInput in) throws IOException {
            super.readFrom(in);
            if (in.readBoolean()) {
                this.metaData = MetaData.Builder.readFrom(in);
            }
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            if (this.metaData == null) {
                out.writeBoolean(false);
            } else {
                out.writeBoolean(true);
                MetaData.Builder.writeTo(this.metaData, out);
            }
        }
    }

    static class NodeRequest
    extends NodeOperationRequest {
        NodeRequest() {
        }

        NodeRequest(String nodeId) {
            super(nodeId);
        }

        @Override
        public void readFrom(StreamInput in) throws IOException {
            super.readFrom(in);
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
        }
    }

    public static class NodesLocalGatewayMetaState
    extends NodesOperationResponse<NodeLocalGatewayMetaState> {
        private FailedNodeException[] failures;

        NodesLocalGatewayMetaState() {
        }

        public NodesLocalGatewayMetaState(ClusterName clusterName, NodeLocalGatewayMetaState[] nodes, FailedNodeException[] failures) {
            super(clusterName, (NodeOperationResponse[])nodes);
            this.failures = failures;
        }

        public FailedNodeException[] failures() {
            return this.failures;
        }

        @Override
        public void readFrom(StreamInput in) throws IOException {
            super.readFrom(in);
            this.nodes = new NodeLocalGatewayMetaState[in.readVInt()];
            for (int i = 0; i < ((NodeLocalGatewayMetaState[])this.nodes).length; ++i) {
                ((NodeLocalGatewayMetaState[])this.nodes)[i] = new NodeLocalGatewayMetaState();
                ((NodeLocalGatewayMetaState[])this.nodes)[i].readFrom(in);
            }
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeVInt(((NodeLocalGatewayMetaState[])this.nodes).length);
            for (NodeLocalGatewayMetaState response : (NodeLocalGatewayMetaState[])this.nodes) {
                response.writeTo(out);
            }
        }
    }

    static class Request
    extends NodesOperationRequest {
        public Request() {
        }

        public Request(Set<String> nodesIds) {
            super(nodesIds.toArray(new String[nodesIds.size()]));
        }

        @Override
        public Request timeout(TimeValue timeout) {
            super.timeout(timeout);
            return this;
        }

        @Override
        public void readFrom(StreamInput in) throws IOException {
            super.readFrom(in);
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
        }
    }
}

