/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.analysis;

import org.apache.lucene.analysis.PorterStemFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.ar.ArabicStemFilter;
import org.apache.lucene.analysis.br.BrazilianStemFilter;
import org.apache.lucene.analysis.cz.CzechStemFilter;
import org.apache.lucene.analysis.de.GermanLightStemFilter;
import org.apache.lucene.analysis.de.GermanMinimalStemFilter;
import org.apache.lucene.analysis.el.GreekStemFilter;
import org.apache.lucene.analysis.en.EnglishMinimalStemFilter;
import org.apache.lucene.analysis.en.EnglishPossessiveFilter;
import org.apache.lucene.analysis.en.KStemFilter;
import org.apache.lucene.analysis.es.SpanishLightStemFilter;
import org.apache.lucene.analysis.fi.FinnishLightStemFilter;
import org.apache.lucene.analysis.fr.FrenchLightStemFilter;
import org.apache.lucene.analysis.fr.FrenchMinimalStemFilter;
import org.apache.lucene.analysis.hi.HindiStemFilter;
import org.apache.lucene.analysis.hu.HungarianLightStemFilter;
import org.apache.lucene.analysis.id.IndonesianStemFilter;
import org.apache.lucene.analysis.it.ItalianLightStemFilter;
import org.apache.lucene.analysis.lv.LatvianStemFilter;
import org.apache.lucene.analysis.pt.PortugueseLightStemFilter;
import org.apache.lucene.analysis.pt.PortugueseMinimalStemFilter;
import org.apache.lucene.analysis.pt.PortugueseStemFilter;
import org.apache.lucene.analysis.ru.RussianLightStemFilter;
import org.apache.lucene.analysis.snowball.SnowballFilter;
import org.apache.lucene.analysis.sv.SwedishLightStemFilter;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.inject.assistedinject.Assisted;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.analysis.AbstractTokenFilterFactory;
import org.elasticsearch.index.settings.IndexSettings;
import org.tartarus.snowball.ext.ArmenianStemmer;
import org.tartarus.snowball.ext.BasqueStemmer;
import org.tartarus.snowball.ext.CatalanStemmer;
import org.tartarus.snowball.ext.DanishStemmer;
import org.tartarus.snowball.ext.DutchStemmer;
import org.tartarus.snowball.ext.EnglishStemmer;
import org.tartarus.snowball.ext.FinnishStemmer;
import org.tartarus.snowball.ext.FrenchStemmer;
import org.tartarus.snowball.ext.German2Stemmer;
import org.tartarus.snowball.ext.GermanStemmer;
import org.tartarus.snowball.ext.HungarianStemmer;
import org.tartarus.snowball.ext.ItalianStemmer;
import org.tartarus.snowball.ext.KpStemmer;
import org.tartarus.snowball.ext.LovinsStemmer;
import org.tartarus.snowball.ext.NorwegianStemmer;
import org.tartarus.snowball.ext.PorterStemmer;
import org.tartarus.snowball.ext.PortugueseStemmer;
import org.tartarus.snowball.ext.RomanianStemmer;
import org.tartarus.snowball.ext.RussianStemmer;
import org.tartarus.snowball.ext.SpanishStemmer;
import org.tartarus.snowball.ext.SwedishStemmer;
import org.tartarus.snowball.ext.TurkishStemmer;

public class StemmerTokenFilterFactory
extends AbstractTokenFilterFactory {
    private String language;

    @Inject
    public StemmerTokenFilterFactory(Index index, @IndexSettings Settings indexSettings, @Assisted String name, @Assisted Settings settings) {
        super(index, indexSettings, name, settings);
        this.language = Strings.capitalize(settings.get("language", settings.get("name", "porter")));
    }

    @Override
    public TokenStream create(TokenStream tokenStream) {
        if ("arabic".equalsIgnoreCase(this.language)) {
            return new ArabicStemFilter(tokenStream);
        }
        if ("armenian".equalsIgnoreCase(this.language)) {
            return new SnowballFilter(tokenStream, new ArmenianStemmer());
        }
        if ("basque".equalsIgnoreCase(this.language)) {
            return new SnowballFilter(tokenStream, new BasqueStemmer());
        }
        if ("brazilian".equalsIgnoreCase(this.language)) {
            return new BrazilianStemFilter(tokenStream);
        }
        if ("catalan".equalsIgnoreCase(this.language)) {
            return new SnowballFilter(tokenStream, new CatalanStemmer());
        }
        if ("czech".equalsIgnoreCase(this.language)) {
            return new CzechStemFilter(tokenStream);
        }
        if ("danish".equalsIgnoreCase(this.language)) {
            return new SnowballFilter(tokenStream, new DanishStemmer());
        }
        if ("dutch".equalsIgnoreCase(this.language)) {
            return new SnowballFilter(tokenStream, new DutchStemmer());
        }
        if ("english".equalsIgnoreCase(this.language)) {
            return new SnowballFilter(tokenStream, new EnglishStemmer());
        }
        if ("finnish".equalsIgnoreCase(this.language)) {
            return new SnowballFilter(tokenStream, new FinnishStemmer());
        }
        if ("french".equalsIgnoreCase(this.language)) {
            return new SnowballFilter(tokenStream, new FrenchStemmer());
        }
        if ("german".equalsIgnoreCase(this.language)) {
            return new SnowballFilter(tokenStream, new GermanStemmer());
        }
        if ("german2".equalsIgnoreCase(this.language)) {
            return new SnowballFilter(tokenStream, new German2Stemmer());
        }
        if ("hungarian".equalsIgnoreCase(this.language)) {
            return new SnowballFilter(tokenStream, new HungarianStemmer());
        }
        if ("italian".equalsIgnoreCase(this.language)) {
            return new SnowballFilter(tokenStream, new ItalianStemmer());
        }
        if ("kp".equalsIgnoreCase(this.language)) {
            return new SnowballFilter(tokenStream, new KpStemmer());
        }
        if ("kstem".equalsIgnoreCase(this.language)) {
            return new KStemFilter(tokenStream);
        }
        if ("lovins".equalsIgnoreCase(this.language)) {
            return new SnowballFilter(tokenStream, new LovinsStemmer());
        }
        if ("latvian".equalsIgnoreCase(this.language)) {
            return new LatvianStemFilter(tokenStream);
        }
        if ("norwegian".equalsIgnoreCase(this.language)) {
            return new SnowballFilter(tokenStream, new NorwegianStemmer());
        }
        if ("porter".equalsIgnoreCase(this.language)) {
            return new PorterStemFilter(tokenStream);
        }
        if ("porter2".equalsIgnoreCase(this.language)) {
            return new SnowballFilter(tokenStream, new PorterStemmer());
        }
        if ("portuguese".equalsIgnoreCase(this.language)) {
            return new SnowballFilter(tokenStream, new PortugueseStemmer());
        }
        if ("romanian".equalsIgnoreCase(this.language)) {
            return new SnowballFilter(tokenStream, new RomanianStemmer());
        }
        if ("russian".equalsIgnoreCase(this.language)) {
            return new SnowballFilter(tokenStream, new RussianStemmer());
        }
        if ("spanish".equalsIgnoreCase(this.language)) {
            return new SnowballFilter(tokenStream, new SpanishStemmer());
        }
        if ("swedish".equalsIgnoreCase(this.language)) {
            return new SnowballFilter(tokenStream, new SwedishStemmer());
        }
        if ("turkish".equalsIgnoreCase(this.language)) {
            return new SnowballFilter(tokenStream, new TurkishStemmer());
        }
        if ("minimal_english".equalsIgnoreCase(this.language) || "minimalEnglish".equalsIgnoreCase(this.language)) {
            return new EnglishMinimalStemFilter(tokenStream);
        }
        if ("possessive_english".equalsIgnoreCase(this.language) || "possessiveEnglish".equalsIgnoreCase(this.language)) {
            return new EnglishPossessiveFilter(this.version, tokenStream);
        }
        if ("light_finish".equalsIgnoreCase(this.language) || "lightFinish".equalsIgnoreCase(this.language)) {
            return new FinnishLightStemFilter(tokenStream);
        }
        if ("light_french".equalsIgnoreCase(this.language) || "lightFrench".equalsIgnoreCase(this.language)) {
            return new FrenchLightStemFilter(tokenStream);
        }
        if ("minimal_french".equalsIgnoreCase(this.language) || "minimalFrench".equalsIgnoreCase(this.language)) {
            return new FrenchMinimalStemFilter(tokenStream);
        }
        if ("light_german".equalsIgnoreCase(this.language) || "lightGerman".equalsIgnoreCase(this.language)) {
            return new GermanLightStemFilter(tokenStream);
        }
        if ("minimal_german".equalsIgnoreCase(this.language) || "minimalGerman".equalsIgnoreCase(this.language)) {
            return new GermanMinimalStemFilter(tokenStream);
        }
        if ("hindi".equalsIgnoreCase(this.language)) {
            return new HindiStemFilter(tokenStream);
        }
        if ("light_hungarian".equalsIgnoreCase(this.language) || "lightHungarian".equalsIgnoreCase(this.language)) {
            return new HungarianLightStemFilter(tokenStream);
        }
        if ("indonesian".equalsIgnoreCase(this.language)) {
            return new IndonesianStemFilter(tokenStream);
        }
        if ("light_italian".equalsIgnoreCase(this.language) || "lightItalian".equalsIgnoreCase(this.language)) {
            return new ItalianLightStemFilter(tokenStream);
        }
        if ("light_portuguese".equalsIgnoreCase(this.language) || "lightPortuguese".equalsIgnoreCase(this.language)) {
            return new PortugueseLightStemFilter(tokenStream);
        }
        if ("minimal_portuguese".equalsIgnoreCase(this.language) || "minimalPortuguese".equalsIgnoreCase(this.language)) {
            return new PortugueseMinimalStemFilter(tokenStream);
        }
        if ("portuguese".equalsIgnoreCase(this.language)) {
            return new PortugueseStemFilter(tokenStream);
        }
        if ("light_russian".equalsIgnoreCase(this.language) || "lightRussian".equalsIgnoreCase(this.language)) {
            return new RussianLightStemFilter(tokenStream);
        }
        if ("light_spanish".equalsIgnoreCase(this.language) || "lightSpanish".equalsIgnoreCase(this.language)) {
            return new SpanishLightStemFilter(tokenStream);
        }
        if ("light_swedish".equalsIgnoreCase(this.language) || "lightSwedish".equalsIgnoreCase(this.language)) {
            return new SwedishLightStemFilter(tokenStream);
        }
        if ("greek".equalsIgnoreCase(this.language)) {
            return new GreekStemFilter(tokenStream);
        }
        return new SnowballFilter(tokenStream, this.language);
    }
}

