/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.cache.id.simple;

import org.elasticsearch.common.BytesWrap;
import org.elasticsearch.common.trove.ExtTObjectIntHasMap;
import org.elasticsearch.index.cache.id.IdReaderTypeCache;

public class SimpleIdReaderTypeCache
implements IdReaderTypeCache {
    private final String type;
    private final ExtTObjectIntHasMap<BytesWrap> idToDoc;
    private final BytesWrap[] parentIdsValues;
    private final int[] parentIdsOrdinals;

    public SimpleIdReaderTypeCache(String type, ExtTObjectIntHasMap<BytesWrap> idToDoc, BytesWrap[] parentIdsValues, int[] parentIdsOrdinals) {
        this.type = type;
        this.idToDoc = idToDoc;
        this.idToDoc.trimToSize();
        this.parentIdsValues = parentIdsValues;
        this.parentIdsOrdinals = parentIdsOrdinals;
    }

    public String type() {
        return this.type;
    }

    @Override
    public BytesWrap parentIdByDoc(int docId) {
        return this.parentIdsValues[this.parentIdsOrdinals[docId]];
    }

    @Override
    public int docById(BytesWrap id) {
        return this.idToDoc.get(id);
    }

    public BytesWrap canReuse(BytesWrap id) {
        return this.idToDoc.key(id);
    }
}

