/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.field.data.support;

import java.io.IOException;
import java.util.ArrayList;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermDocs;
import org.apache.lucene.index.TermEnum;
import org.apache.lucene.util.StringHelper;
import org.elasticsearch.index.field.data.FieldData;

public class FieldDataLoader {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T extends FieldData> T load(IndexReader reader, String field, TypeLoader<T> loader) throws IOException {
        ArrayList<int[]> ordinals;
        block14: {
            loader.init();
            field = StringHelper.intern(field);
            ordinals = new ArrayList<int[]>();
            int[] idx = new int[reader.maxDoc()];
            ordinals.add(new int[reader.maxDoc()]);
            int t = 1;
            TermDocs termDocs = reader.termDocs();
            TermEnum termEnum = reader.terms(new Term(field));
            try {
                Term term;
                while ((term = termEnum.term()) != null) {
                    if (term.field() != field) {
                    } else {
                        loader.collectTerm(term.text());
                        termDocs.seek(termEnum);
                        while (termDocs.next()) {
                            int[] ordinal;
                            int doc = termDocs.doc();
                            if (idx[doc] >= ordinals.size()) {
                                ordinal = new int[reader.maxDoc()];
                                ordinals.add(ordinal);
                            } else {
                                ordinal = (int[])ordinals.get(idx[doc]);
                            }
                            ordinal[doc] = t;
                            int n = doc;
                            idx[n] = idx[n] + 1;
                        }
                        ++t;
                        if (termEnum.next()) continue;
                    }
                    break;
                }
            }
            catch (RuntimeException e) {
                if (e.getClass().getName().endsWith("StopFillCacheException")) {
                    break block14;
                }
                throw e;
            }
            finally {
                termDocs.close();
                termEnum.close();
            }
        }
        if (ordinals.size() == 1) {
            return loader.buildSingleValue(field, (int[])ordinals.get(0));
        }
        int[][] nativeOrdinals = new int[ordinals.size()][];
        for (int i = 0; i < nativeOrdinals.length; ++i) {
            nativeOrdinals[i] = (int[])ordinals.get(i);
        }
        return loader.buildMultiValue(field, nativeOrdinals);
    }

    public static abstract class FreqsTypeLoader<T extends FieldData>
    implements TypeLoader<T> {
        protected FreqsTypeLoader() {
        }

        @Override
        public void init() {
        }
    }

    public static interface TypeLoader<T extends FieldData> {
        public void init();

        public void collectTerm(String var1);

        public T buildSingleValue(String var1, int[] var2);

        public T buildMultiValue(String var1, int[][] var2);
    }
}

