/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper.internal;

import java.io.IOException;
import java.util.Map;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.Fieldable;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.support.XContentMapValues;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.Mapper;
import org.elasticsearch.index.mapper.MapperParsingException;
import org.elasticsearch.index.mapper.MergeContext;
import org.elasticsearch.index.mapper.MergeMappingException;
import org.elasticsearch.index.mapper.ParseContext;
import org.elasticsearch.index.mapper.RootMapper;
import org.elasticsearch.index.mapper.core.IntegerFieldMapper;
import org.elasticsearch.index.mapper.core.NumberFieldMapper;
import org.elasticsearch.index.mapper.core.TypeParsers;

public class SizeFieldMapper
extends IntegerFieldMapper
implements RootMapper {
    public static final String NAME = "_size";
    public static final String CONTENT_TYPE = "_size";
    private final boolean enabled;

    public SizeFieldMapper() {
        this(false, Defaults.STORE);
    }

    public SizeFieldMapper(boolean enabled, Field.Store store) {
        super(new FieldMapper.Names("_size"), 4, Defaults.FUZZY_FACTOR, Defaults.INDEX, store, 1.0f, true, true, Defaults.NULL_VALUE);
        this.enabled = enabled;
    }

    @Override
    protected String contentType() {
        return "_size";
    }

    public boolean enabled() {
        return this.enabled;
    }

    @Override
    public void validate(ParseContext context) throws MapperParsingException {
    }

    @Override
    public void preParse(ParseContext context) throws IOException {
    }

    @Override
    public void postParse(ParseContext context) throws IOException {
        super.parse(context);
    }

    @Override
    public void parse(ParseContext context) throws IOException {
    }

    @Override
    public boolean includeInObject() {
        return false;
    }

    @Override
    protected Fieldable parseCreateField(ParseContext context) throws IOException {
        if (!this.enabled) {
            return null;
        }
        return new IntegerFieldMapper.CustomIntegerNumericField((NumberFieldMapper)this, context.sourceLength());
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        if (!this.enabled && this.store == Defaults.STORE) {
            return builder;
        }
        builder.startObject(this.contentType());
        if (this.enabled) {
            builder.field("enabled", this.enabled);
        }
        if (this.store != Defaults.STORE) {
            builder.field("store", this.store.name().toLowerCase());
        }
        builder.endObject();
        return builder;
    }

    @Override
    public void merge(Mapper mergeWith, MergeContext mergeContext) throws MergeMappingException {
    }

    public static class TypeParser
    implements Mapper.TypeParser {
        @Override
        public Mapper.Builder parse(String name, Map<String, Object> node, Mapper.TypeParser.ParserContext parserContext) throws MapperParsingException {
            Builder builder = new Builder();
            for (Map.Entry<String, Object> entry : node.entrySet()) {
                String fieldName = Strings.toUnderscoreCase(entry.getKey());
                Object fieldNode = entry.getValue();
                if (fieldName.equals("enabled")) {
                    builder.enabled(XContentMapValues.nodeBooleanValue(fieldNode));
                    continue;
                }
                if (!fieldName.equals("store")) continue;
                builder.store(TypeParsers.parseStore(fieldName, fieldNode.toString()));
            }
            return builder;
        }
    }

    public static class Builder
    extends Mapper.Builder<Builder, IntegerFieldMapper> {
        protected boolean enabled = false;
        protected Field.Store store = Defaults.STORE;

        public Builder() {
            super("_size");
            this.builder = this;
        }

        public Builder enabled(boolean enabled) {
            this.enabled = enabled;
            return (Builder)this.builder;
        }

        public Builder store(Field.Store store) {
            this.store = store;
            return (Builder)this.builder;
        }

        @Override
        public SizeFieldMapper build(Mapper.BuilderContext context) {
            return new SizeFieldMapper(this.enabled, this.store);
        }
    }

    public static class Defaults
    extends IntegerFieldMapper.Defaults {
        public static final String NAME = "_size";
        public static final boolean ENABLED = false;
    }
}

