/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper.internal;

import java.io.IOException;
import java.util.Date;
import java.util.Map;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.Fieldable;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.common.xcontent.support.XContentMapValues;
import org.elasticsearch.index.AlreadyExpiredException;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.InternalMapper;
import org.elasticsearch.index.mapper.Mapper;
import org.elasticsearch.index.mapper.MapperParsingException;
import org.elasticsearch.index.mapper.MergeContext;
import org.elasticsearch.index.mapper.MergeMappingException;
import org.elasticsearch.index.mapper.ParseContext;
import org.elasticsearch.index.mapper.RootMapper;
import org.elasticsearch.index.mapper.core.LongFieldMapper;
import org.elasticsearch.index.mapper.core.NumberFieldMapper;
import org.elasticsearch.index.mapper.core.TypeParsers;
import org.elasticsearch.search.internal.SearchContext;

public class TTLFieldMapper
extends LongFieldMapper
implements InternalMapper,
RootMapper {
    public static final String NAME = "_ttl";
    public static final String CONTENT_TYPE = "_ttl";
    private boolean enabled;
    private long defaultTTL;

    public TTLFieldMapper() {
        this(Defaults.STORE, Defaults.INDEX, false, -1L);
    }

    protected TTLFieldMapper(Field.Store store, Field.Index index, boolean enabled, long defaultTTL) {
        super(new FieldMapper.Names("_ttl", "_ttl", "_ttl", "_ttl"), 4, Defaults.FUZZY_FACTOR, index, store, 1.0f, true, true, Defaults.NULL_VALUE);
        this.enabled = enabled;
        this.defaultTTL = defaultTTL;
    }

    public boolean enabled() {
        return this.enabled;
    }

    public long defaultTTL() {
        return this.defaultTTL;
    }

    @Override
    public Object valueForSearch(Fieldable field) {
        SearchContext searchContext = SearchContext.current();
        long now = searchContext != null ? searchContext.nowInMillis() : System.currentTimeMillis();
        long value = this.value(field);
        return value - now;
    }

    public Object valueForSearch(long expirationTime) {
        return expirationTime - System.currentTimeMillis();
    }

    @Override
    public void validate(ParseContext context) throws MapperParsingException {
    }

    @Override
    public void preParse(ParseContext context) throws IOException {
    }

    @Override
    public void postParse(ParseContext context) throws IOException {
        super.parse(context);
    }

    @Override
    public void parse(ParseContext context) throws IOException, MapperParsingException {
        if (context.sourceToParse().ttl() < 0L) {
            long ttl = context.parser().currentToken() == XContentParser.Token.VALUE_STRING ? TimeValue.parseTimeValue(context.parser().text(), null).millis() : context.parser().longValue();
            if (ttl <= 0L) {
                throw new MapperParsingException("TTL value must be > 0. Illegal value provided [" + ttl + "]");
            }
            context.sourceToParse().ttl(ttl);
        }
    }

    @Override
    public boolean includeInObject() {
        return true;
    }

    @Override
    protected Fieldable parseCreateField(ParseContext context) throws IOException, AlreadyExpiredException {
        if (this.enabled) {
            long ttl = context.sourceToParse().ttl();
            if (ttl <= 0L && this.defaultTTL > 0L) {
                ttl = this.defaultTTL;
                context.sourceToParse().ttl(ttl);
            }
            if (ttl > 0L) {
                long timestamp = context.sourceToParse().timestamp();
                long expire = new Date(timestamp + ttl).getTime();
                long now = System.currentTimeMillis();
                if (now >= expire) {
                    throw new AlreadyExpiredException(context.index(), context.type(), context.id(), timestamp, ttl, now);
                }
                return new LongFieldMapper.CustomLongNumericField((NumberFieldMapper)this, expire);
            }
        }
        return null;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        if (!this.enabled && this.defaultTTL == -1L) {
            return builder;
        }
        builder.startObject("_ttl");
        if (this.enabled) {
            builder.field("enabled", this.enabled);
        }
        if (this.defaultTTL != -1L) {
            builder.field("default", this.defaultTTL);
        }
        builder.endObject();
        return builder;
    }

    @Override
    public void merge(Mapper mergeWith, MergeContext mergeContext) throws MergeMappingException {
        TTLFieldMapper ttlMergeWith = (TTLFieldMapper)mergeWith;
        if (!mergeContext.mergeFlags().simulate() && ttlMergeWith.defaultTTL != -1L) {
            this.defaultTTL = ttlMergeWith.defaultTTL;
        }
    }

    public static class TypeParser
    implements Mapper.TypeParser {
        @Override
        public Mapper.Builder parse(String name, Map<String, Object> node, Mapper.TypeParser.ParserContext parserContext) throws MapperParsingException {
            Builder builder = new Builder();
            TypeParsers.parseField(builder, builder.name, node, parserContext);
            for (Map.Entry<String, Object> entry : node.entrySet()) {
                TimeValue ttlTimeValue;
                String fieldName = Strings.toUnderscoreCase(entry.getKey());
                Object fieldNode = entry.getValue();
                if (fieldName.equals("enabled")) {
                    builder.enabled(XContentMapValues.nodeBooleanValue(fieldNode));
                    continue;
                }
                if (!fieldName.equals("default") || (ttlTimeValue = XContentMapValues.nodeTimeValue(fieldNode, null)) == null) continue;
                builder.defaultTTL(ttlTimeValue.millis());
            }
            return builder;
        }
    }

    public static class Builder
    extends NumberFieldMapper.Builder<Builder, TTLFieldMapper> {
        private boolean enabled = false;
        private long defaultTTL = -1L;

        public Builder() {
            super("_ttl");
            this.store = Defaults.STORE;
            this.index = Defaults.INDEX;
        }

        public Builder enabled(boolean enabled) {
            this.enabled = enabled;
            return (Builder)this.builder;
        }

        public Builder defaultTTL(long defaultTTL) {
            this.defaultTTL = defaultTTL;
            return (Builder)this.builder;
        }

        @Override
        public TTLFieldMapper build(Mapper.BuilderContext context) {
            return new TTLFieldMapper(this.store, this.index, this.enabled, this.defaultTTL);
        }
    }

    public static class Defaults
    extends LongFieldMapper.Defaults {
        public static final String NAME = "_ttl";
        public static final Field.Store STORE = Field.Store.YES;
        public static final Field.Index INDEX = Field.Index.NOT_ANALYZED;
        public static final boolean ENABLED = false;
        public static final long DEFAULT = -1L;
    }
}

