/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.indices.recovery;

import java.io.IOException;
import java.util.Set;
import org.elasticsearch.common.collect.Sets;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Streamable;
import org.elasticsearch.index.shard.ShardId;

class RecoveryCleanFilesRequest
implements Streamable {
    private ShardId shardId;
    private Set<String> snapshotFiles;

    RecoveryCleanFilesRequest() {
    }

    RecoveryCleanFilesRequest(ShardId shardId, Set<String> snapshotFiles) {
        this.shardId = shardId;
        this.snapshotFiles = snapshotFiles;
    }

    public ShardId shardId() {
        return this.shardId;
    }

    public Set<String> snapshotFiles() {
        return this.snapshotFiles;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        this.shardId = ShardId.readShardId(in);
        int size = in.readVInt();
        this.snapshotFiles = Sets.newHashSetWithExpectedSize(size);
        for (int i = 0; i < size; ++i) {
            this.snapshotFiles.add(in.readUTF());
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        this.shardId.writeTo(out);
        out.writeVInt(this.snapshotFiles.size());
        for (String snapshotFile : this.snapshotFiles) {
            out.writeUTF(snapshotFile);
        }
    }
}

