/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.indices.store;

import java.io.File;
import java.util.Map;
import java.util.concurrent.ScheduledFuture;
import org.elasticsearch.cluster.ClusterChangedEvent;
import org.elasticsearch.cluster.ClusterService;
import org.elasticsearch.cluster.ClusterStateListener;
import org.elasticsearch.cluster.routing.IndexRoutingTable;
import org.elasticsearch.cluster.routing.IndexShardRoutingTable;
import org.elasticsearch.cluster.routing.RoutingTable;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.cluster.routing.ShardRoutingState;
import org.elasticsearch.common.component.AbstractComponent;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.io.FileSystemUtils;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.util.concurrent.ConcurrentCollections;
import org.elasticsearch.env.NodeEnvironment;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.service.IndexService;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.indices.IndicesService;
import org.elasticsearch.threadpool.ThreadPool;

public class IndicesStore
extends AbstractComponent
implements ClusterStateListener {
    private final NodeEnvironment nodeEnv;
    private final IndicesService indicesService;
    private final ClusterService clusterService;
    private final ThreadPool threadPool;
    private final TimeValue danglingTimeout;
    private final Map<String, DanglingIndex> danglingIndices = ConcurrentCollections.newConcurrentMap();
    private final Object danglingMutex = new Object();

    @Inject
    public IndicesStore(Settings settings, NodeEnvironment nodeEnv, IndicesService indicesService, ClusterService clusterService, ThreadPool threadPool) {
        super(settings);
        this.nodeEnv = nodeEnv;
        this.indicesService = indicesService;
        this.clusterService = clusterService;
        this.threadPool = threadPool;
        this.danglingTimeout = this.componentSettings.getAsTime("dangling_timeout", TimeValue.timeValueHours(2L));
        clusterService.addLast(this);
    }

    public void close() {
        this.clusterService.remove(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clusterChanged(ClusterChangedEvent event) {
        IndexService indexService;
        if (!event.routingTableChanged()) {
            return;
        }
        if (event.state().blocks().disableStatePersistence()) {
            return;
        }
        RoutingTable routingTable = event.state().routingTable();
        for (IndexRoutingTable indexRoutingTable : routingTable) {
            indexService = this.indicesService.indexService(indexRoutingTable.index());
            if (indexService == null || !indexService.store().persistent()) continue;
            for (IndexShardRoutingTable indexShardRoutingTable : indexRoutingTable) {
                if (indexService.hasShard(indexShardRoutingTable.shardId().id()) || !indexService.store().canDeleteUnallocated(indexShardRoutingTable.shardId()) || indexShardRoutingTable.countWithState(ShardRoutingState.STARTED) != indexShardRoutingTable.size()) continue;
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("[{}][{}] deleting unallocated shard", indexShardRoutingTable.shardId().index().name(), indexShardRoutingTable.shardId().id());
                }
                try {
                    indexService.store().deleteUnallocated(indexShardRoutingTable.shardId());
                }
                catch (Exception e) {
                    this.logger.debug("[{}][{}] failed to delete unallocated shard, ignoring", e, indexShardRoutingTable.shardId().index().name(), indexShardRoutingTable.shardId().id());
                }
            }
        }
        if (this.nodeEnv.hasNodeFile()) {
            for (IndexRoutingTable indexRoutingTable : routingTable) {
                indexService = this.indicesService.indexService(indexRoutingTable.index());
                if (indexService != null) continue;
                for (IndexShardRoutingTable indexShardRoutingTable : indexRoutingTable) {
                    boolean shardCanBeDeleted = true;
                    for (ShardRouting shardRouting : indexShardRoutingTable) {
                        if (!shardRouting.active()) {
                            shardCanBeDeleted = false;
                            break;
                        }
                        String localNodeId = this.clusterService.localNode().id();
                        if (!localNodeId.equals(shardRouting.currentNodeId()) && !localNodeId.equals(shardRouting.relocatingNodeId())) continue;
                        shardCanBeDeleted = false;
                        break;
                    }
                    if (!shardCanBeDeleted) continue;
                    ShardId shardId = indexShardRoutingTable.shardId();
                    for (File shardLocation : this.nodeEnv.shardLocations(shardId)) {
                        if (!shardLocation.exists()) continue;
                        this.logger.debug("[{}][{}] deleting shard that is no longer used", shardId.index().name(), shardId.id());
                        FileSystemUtils.deleteRecursively(shardLocation);
                    }
                }
            }
            if (this.danglingTimeout.millis() >= 0L) {
                Object object = this.danglingMutex;
                synchronized (object) {
                    for (String danglingIndex : this.danglingIndices.keySet()) {
                        if (!event.state().metaData().hasIndex(danglingIndex)) continue;
                        this.logger.debug("[{}] no longer dangling (created), removing", danglingIndex);
                        DanglingIndex removed = this.danglingIndices.remove(danglingIndex);
                        removed.future.cancel(false);
                    }
                    try {
                        for (String indexName : this.nodeEnv.findAllIndices()) {
                            if (event.state().metaData().hasIndex(indexName) || this.danglingIndices.containsKey(indexName)) continue;
                            if (this.danglingTimeout.millis() == 0L) {
                                this.logger.info("[{}] dangling index, exists on local file system, but not in cluster metadata, timeout set to 0, deleting now", indexName);
                                FileSystemUtils.deleteRecursively(this.nodeEnv.indexLocations(new Index(indexName)));
                                continue;
                            }
                            this.logger.info("[{}] dangling index, exists on local file system, but not in cluster metadata, scheduling to delete in [{}]", indexName, this.danglingTimeout);
                            this.danglingIndices.put(indexName, new DanglingIndex(indexName, this.threadPool.schedule(this.danglingTimeout, "same", new RemoveDanglingIndex(indexName))));
                        }
                    }
                    catch (Exception e) {
                        this.logger.warn("failed to find dangling indices", e, new Object[0]);
                    }
                }
            }
        }
    }

    class RemoveDanglingIndex
    implements Runnable {
        private final String index;

        RemoveDanglingIndex(String index) {
            this.index = index;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Object object = IndicesStore.this.danglingMutex;
            synchronized (object) {
                DanglingIndex remove = (DanglingIndex)IndicesStore.this.danglingIndices.remove(this.index);
                if (remove == null) {
                    return;
                }
                IndicesStore.this.logger.info("[{}] deleting dangling index", this.index);
                FileSystemUtils.deleteRecursively(IndicesStore.this.nodeEnv.indexLocations(new Index(this.index)));
            }
        }
    }

    static class DanglingIndex {
        public final String index;
        public final ScheduledFuture future;

        DanglingIndex(String index, ScheduledFuture future) {
            this.index = index;
            this.future = future;
        }
    }
}

