/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.rest.action.get;

import java.io.IOException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.get.MultiGetRequest;
import org.elasticsearch.action.get.MultiGetResponse;
import org.elasticsearch.client.Client;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.rest.XContentRestResponse;
import org.elasticsearch.rest.XContentThrowableRestResponse;
import org.elasticsearch.rest.action.support.RestXContentBuilder;

public class RestMultiGetAction
extends BaseRestHandler {
    @Inject
    public RestMultiGetAction(Settings settings, Client client, RestController controller) {
        super(settings, client);
        controller.registerHandler(RestRequest.Method.GET, "/_mget", this);
        controller.registerHandler(RestRequest.Method.POST, "/_mget", this);
        controller.registerHandler(RestRequest.Method.GET, "/{index}/_mget", this);
        controller.registerHandler(RestRequest.Method.POST, "/{index}/_mget", this);
        controller.registerHandler(RestRequest.Method.GET, "/{index}/{type}/_mget", this);
        controller.registerHandler(RestRequest.Method.POST, "/{index}/{type}/_mget", this);
    }

    @Override
    public void handleRequest(final RestRequest request, final RestChannel channel) {
        MultiGetRequest multiGetRequest = new MultiGetRequest();
        multiGetRequest.listenerThreaded(false);
        multiGetRequest.refresh(request.paramAsBoolean("refresh", multiGetRequest.refresh()));
        multiGetRequest.preference(request.param("preference"));
        multiGetRequest.realtime(request.paramAsBooleanOptional("realtime", null));
        String[] sFields = null;
        String sField = request.param("fields");
        if (sField != null) {
            sFields = Strings.splitStringByCommaToArray(sField);
        }
        try {
            multiGetRequest.add(request.param("index"), request.param("type"), sFields, request.contentByteArray(), request.contentByteArrayOffset(), request.contentLength());
        }
        catch (Exception e) {
            try {
                XContentBuilder builder = RestXContentBuilder.restContentBuilder(request);
                channel.sendResponse(new XContentRestResponse(request, RestStatus.BAD_REQUEST, builder.startObject().field("error", e.getMessage()).endObject()));
            }
            catch (IOException e1) {
                this.logger.error("Failed to send failure response", e1, new Object[0]);
            }
            return;
        }
        this.client.multiGet(multiGetRequest, new ActionListener<MultiGetResponse>(){

            @Override
            public void onResponse(MultiGetResponse response) {
                try {
                    XContentBuilder builder = RestXContentBuilder.restContentBuilder(request);
                    response.toXContent(builder, request);
                    channel.sendResponse(new XContentRestResponse(request, RestStatus.OK, builder));
                }
                catch (Exception e) {
                    this.onFailure(e);
                }
            }

            @Override
            public void onFailure(Throwable e) {
                try {
                    channel.sendResponse(new XContentThrowableRestResponse(request, e));
                }
                catch (IOException e1) {
                    RestMultiGetAction.this.logger.error("Failed to send failure response", e1, new Object[0]);
                }
            }
        });
    }
}

