/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.scriptbuilder.statements.java;

import java.net.URI;
import org.jclouds.scriptbuilder.domain.Statement;
import org.jclouds.scriptbuilder.domain.StatementList;
import org.jclouds.scriptbuilder.domain.Statements;

public class InstallJDK {
    public static Statement fromOracle() {
        throw new UnsupportedOperationException("Oracle JDK install doesn't currently work due to license agreement");
    }

    public static Statement fromOpenJDK() {
        return new FromOpenJDK();
    }

    @Deprecated
    public static Statement fromURL() {
        return InstallJDK.fromOpenJDK();
    }

    public static Statement fromURL(URI url) {
        return new FromURL(url);
    }

    public static class FromURL
    extends StatementList {
        public FromURL() {
            super(Statements.call("setupPublicCurl", new String[0]), Statements.call("installJDKFromURL", new String[0]));
        }

        public FromURL(URI jdk7Url) {
            super(Statements.call("setupPublicCurl", new String[0]), Statements.call("installJDKFromURL", jdk7Url.toASCIIString()));
        }
    }

    public static class FromOpenJDK
    extends StatementList {
        public FromOpenJDK() {
            super(Statements.call("setupPublicCurl", new String[0]), Statements.call("installOpenJDK", new String[0]));
        }
    }
}

