/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.fabric.fab;

import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.fusesource.common.util.Filter;
import org.fusesource.fabric.fab.DependencyClassLoader;
import org.fusesource.fabric.fab.DependencyTree;

public class SharedClassLoaderRegistry {
    private Map<DependencyTree, DependencyClassLoader> cache = new HashMap<DependencyTree, DependencyClassLoader>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DependencyClassLoader getClassLoader(DependencyTree tree, Filter<DependencyTree> sharedFilter, Filter<DependencyTree> excludeFilter) throws MalformedURLException {
        DependencyClassLoader answer = null;
        if (excludeFilter == null || !excludeFilter.matches((Object)tree)) {
            if (sharedFilter != null && sharedFilter.matches((Object)tree)) {
                Map<DependencyTree, DependencyClassLoader> map = this.cache;
                synchronized (map) {
                    answer = this.cache.get(tree);
                    if (answer == null) {
                        answer = this.createClassLoader(tree, sharedFilter, excludeFilter);
                        this.cache.put(tree, answer);
                    }
                }
            } else {
                answer = this.createClassLoader(tree, sharedFilter, excludeFilter);
            }
        }
        return answer;
    }

    protected DependencyClassLoader createClassLoader(DependencyTree tree, Filter<DependencyTree> sharedFilter, Filter<DependencyTree> excludeFilter) throws MalformedURLException {
        ArrayList<DependencyClassLoader> childClassLoaders = new ArrayList<DependencyClassLoader>();
        List<DependencyTree> children = tree.getChildren();
        ArrayList<DependencyTree> nonSharedDependencies = new ArrayList<DependencyTree>();
        for (DependencyTree child : children) {
            if (excludeFilter != null && excludeFilter.matches((Object)tree)) continue;
            if (sharedFilter != null && sharedFilter.matches((Object)child)) {
                DependencyClassLoader childClassLoader = this.getClassLoader(child, sharedFilter, excludeFilter);
                if (childClassLoader == null) continue;
                childClassLoaders.add(childClassLoader);
                continue;
            }
            nonSharedDependencies.add(child);
            child.addDescendants(nonSharedDependencies);
        }
        return DependencyClassLoader.newInstance(tree, nonSharedDependencies, childClassLoaders, null);
    }
}

