/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.broker;

import java.io.EOFException;
import java.io.IOException;
import java.net.SocketException;
import java.net.URI;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.activemq.advisory.AdvisorySupport;
import org.apache.activemq.broker.Broker;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.BrokerStoppedException;
import org.apache.activemq.broker.Connection;
import org.apache.activemq.broker.ConnectionContext;
import org.apache.activemq.broker.Connector;
import org.apache.activemq.broker.ConsumerBrokerExchange;
import org.apache.activemq.broker.MapTransportConnectionStateRegister;
import org.apache.activemq.broker.ProducerBrokerExchange;
import org.apache.activemq.broker.SingleTransportConnectionStateRegister;
import org.apache.activemq.broker.SuppressReplyException;
import org.apache.activemq.broker.TransportConnectionState;
import org.apache.activemq.broker.TransportConnectionStateRegister;
import org.apache.activemq.broker.TransportConnector;
import org.apache.activemq.broker.region.ConnectionStatistics;
import org.apache.activemq.broker.region.RegionBroker;
import org.apache.activemq.command.ActiveMQDestination;
import org.apache.activemq.command.BrokerInfo;
import org.apache.activemq.command.Command;
import org.apache.activemq.command.ConnectionControl;
import org.apache.activemq.command.ConnectionError;
import org.apache.activemq.command.ConnectionId;
import org.apache.activemq.command.ConnectionInfo;
import org.apache.activemq.command.ConsumerControl;
import org.apache.activemq.command.ConsumerId;
import org.apache.activemq.command.ConsumerInfo;
import org.apache.activemq.command.ControlCommand;
import org.apache.activemq.command.DataArrayResponse;
import org.apache.activemq.command.DataStructure;
import org.apache.activemq.command.DestinationInfo;
import org.apache.activemq.command.ExceptionResponse;
import org.apache.activemq.command.FlushCommand;
import org.apache.activemq.command.IntegerResponse;
import org.apache.activemq.command.KeepAliveInfo;
import org.apache.activemq.command.Message;
import org.apache.activemq.command.MessageAck;
import org.apache.activemq.command.MessageDispatch;
import org.apache.activemq.command.MessageDispatchNotification;
import org.apache.activemq.command.MessagePull;
import org.apache.activemq.command.ProducerAck;
import org.apache.activemq.command.ProducerId;
import org.apache.activemq.command.ProducerInfo;
import org.apache.activemq.command.RemoveSubscriptionInfo;
import org.apache.activemq.command.Response;
import org.apache.activemq.command.SessionId;
import org.apache.activemq.command.SessionInfo;
import org.apache.activemq.command.ShutdownInfo;
import org.apache.activemq.command.TransactionId;
import org.apache.activemq.command.TransactionInfo;
import org.apache.activemq.command.WireFormatInfo;
import org.apache.activemq.network.DemandForwardingBridge;
import org.apache.activemq.network.MBeanNetworkListener;
import org.apache.activemq.network.NetworkBridgeConfiguration;
import org.apache.activemq.network.NetworkBridgeFactory;
import org.apache.activemq.security.MessageAuthorizationPolicy;
import org.apache.activemq.state.CommandVisitor;
import org.apache.activemq.state.ConnectionState;
import org.apache.activemq.state.ConsumerState;
import org.apache.activemq.state.ProducerState;
import org.apache.activemq.state.SessionState;
import org.apache.activemq.state.TransactionState;
import org.apache.activemq.thread.Task;
import org.apache.activemq.thread.TaskRunner;
import org.apache.activemq.thread.TaskRunnerFactory;
import org.apache.activemq.transaction.Transaction;
import org.apache.activemq.transport.DefaultTransportListener;
import org.apache.activemq.transport.ResponseCorrelator;
import org.apache.activemq.transport.TransmitCallback;
import org.apache.activemq.transport.Transport;
import org.apache.activemq.transport.TransportDisposedIOException;
import org.apache.activemq.util.IntrospectionSupport;
import org.apache.activemq.util.MarshallingSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

public class TransportConnection
implements Connection,
Task,
CommandVisitor {
    private static final Logger LOG = LoggerFactory.getLogger(TransportConnection.class);
    private static final Logger TRANSPORTLOG = LoggerFactory.getLogger((String)(TransportConnection.class.getName() + ".Transport"));
    private static final Logger SERVICELOG = LoggerFactory.getLogger((String)(TransportConnection.class.getName() + ".Service"));
    protected final Broker broker;
    protected final TransportConnector connector;
    protected final Map<ConnectionId, ConnectionState> brokerConnectionStates;
    protected BrokerInfo brokerInfo;
    protected final List<Command> dispatchQueue = new LinkedList<Command>();
    protected TaskRunner taskRunner;
    protected final AtomicReference<IOException> transportException = new AtomicReference();
    protected AtomicBoolean dispatchStopped = new AtomicBoolean(false);
    private final Transport transport;
    private MessageAuthorizationPolicy messageAuthorizationPolicy;
    private WireFormatInfo wireFormatInfo;
    private boolean inServiceException;
    private final ConnectionStatistics statistics = new ConnectionStatistics();
    private boolean manageable;
    private boolean slow;
    private boolean markedCandidate;
    private boolean blockedCandidate;
    private boolean blocked;
    private boolean connected;
    private boolean active;
    private boolean starting;
    private boolean pendingStop;
    private long timeStamp;
    private final AtomicBoolean stopping = new AtomicBoolean(false);
    private final CountDownLatch stopped = new CountDownLatch(1);
    private final AtomicBoolean asyncException = new AtomicBoolean(false);
    private final Map<ProducerId, ProducerBrokerExchange> producerExchanges = new HashMap<ProducerId, ProducerBrokerExchange>();
    private final Map<ConsumerId, ConsumerBrokerExchange> consumerExchanges = new HashMap<ConsumerId, ConsumerBrokerExchange>();
    private final CountDownLatch dispatchStoppedLatch = new CountDownLatch(1);
    private ConnectionContext context;
    private boolean networkConnection;
    private boolean faultTolerantConnection;
    private final AtomicInteger protocolVersion = new AtomicInteger(9);
    private DemandForwardingBridge duplexBridge;
    private final TaskRunnerFactory taskRunnerFactory;
    private final TaskRunnerFactory stopTaskRunnerFactory;
    private TransportConnectionStateRegister connectionStateRegister = new SingleTransportConnectionStateRegister();
    private final ReentrantReadWriteLock serviceLock = new ReentrantReadWriteLock();
    private String duplexNetworkConnectorId;
    private Throwable stopError = null;

    public TransportConnection(TransportConnector connector, Transport transport, Broker broker, TaskRunnerFactory taskRunnerFactory, TaskRunnerFactory stopTaskRunnerFactory) {
        this.connector = connector;
        this.broker = broker;
        RegionBroker rb = (RegionBroker)broker.getAdaptor(RegionBroker.class);
        this.brokerConnectionStates = rb.getConnectionStates();
        if (connector != null) {
            this.statistics.setParent(connector.getStatistics());
            this.messageAuthorizationPolicy = connector.getMessageAuthorizationPolicy();
        }
        this.taskRunnerFactory = taskRunnerFactory;
        this.stopTaskRunnerFactory = stopTaskRunnerFactory;
        this.transport = transport;
        final BrokerService brokerService = this.broker.getBrokerService();
        this.transport.setTransportListener(new DefaultTransportListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onCommand(Object o) {
                block6: {
                    TransportConnection.this.serviceLock.readLock().lock();
                    try {
                        if (!(o instanceof Command)) {
                            throw new RuntimeException("Protocol violation - Command corrupted: " + o.toString());
                        }
                        Command command = (Command)o;
                        if (!brokerService.isStopping()) {
                            Response response = TransportConnection.this.service(command);
                            if (response != null && !brokerService.isStopping()) {
                                TransportConnection.this.dispatchSync(response);
                            }
                            break block6;
                        }
                        throw new BrokerStoppedException("Broker " + brokerService + " is being stopped");
                    }
                    finally {
                        TransportConnection.this.serviceLock.readLock().unlock();
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onException(IOException exception) {
                TransportConnection.this.serviceLock.readLock().lock();
                try {
                    TransportConnection.this.serviceTransportException(exception);
                }
                finally {
                    TransportConnection.this.serviceLock.readLock().unlock();
                }
            }
        });
        this.connected = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getDispatchQueueSize() {
        List<Command> list = this.dispatchQueue;
        synchronized (list) {
            return this.dispatchQueue.size();
        }
    }

    public void serviceTransportException(IOException e) {
        BrokerService bService = this.connector.getBrokerService();
        if (bService.isShutdownOnSlaveFailure() && this.brokerInfo != null && this.brokerInfo.isSlaveBroker()) {
            LOG.error("Slave has exception: " + e.getMessage() + " shutting down master now.", (Throwable)e);
            try {
                this.doStop();
                bService.stop();
            }
            catch (Exception ex) {
                LOG.warn("Failed to stop the master", (Throwable)ex);
            }
        }
        if (!this.stopping.get()) {
            this.transportException.set(e);
            if (TRANSPORTLOG.isDebugEnabled()) {
                TRANSPORTLOG.debug(this + " failed: " + e, (Throwable)e);
            } else if (TRANSPORTLOG.isWarnEnabled() && !this.expected(e)) {
                TRANSPORTLOG.warn(this + " failed: " + e);
            }
            this.stopAsync();
        }
    }

    private boolean expected(IOException e) {
        return this.isStomp() && (e instanceof SocketException && e.getMessage().indexOf("reset") != -1 || e instanceof EOFException);
    }

    private boolean isStomp() {
        URI uri = this.connector.getUri();
        return uri != null && uri.getScheme() != null && uri.getScheme().indexOf("stomp") != -1;
    }

    @Override
    public void serviceExceptionAsync(final IOException e) {
        if (this.asyncException.compareAndSet(false, true)) {
            new Thread("Async Exception Handler"){

                @Override
                public void run() {
                    TransportConnection.this.serviceException(e);
                }
            }.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void serviceException(Throwable e) {
        if (e instanceof IOException) {
            this.serviceTransportException((IOException)e);
        } else if (e.getClass() == BrokerStoppedException.class) {
            if (!this.stopping.get()) {
                if (SERVICELOG.isDebugEnabled()) {
                    SERVICELOG.debug("Broker has been stopped.  Notifying client and closing his connection.");
                }
                ConnectionError ce = new ConnectionError();
                ce.setException(e);
                this.dispatchSync(ce);
                this.stopError = e;
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException ie) {
                    Thread.currentThread().interrupt();
                }
                this.stopAsync();
            }
        } else if (!this.stopping.get() && !this.inServiceException) {
            this.inServiceException = true;
            try {
                SERVICELOG.warn("Async error occurred: " + e, e);
                ConnectionError ce = new ConnectionError();
                ce.setException(e);
                if (this.pendingStop) {
                    this.dispatchSync(ce);
                } else {
                    this.dispatchAsync(ce);
                }
            }
            finally {
                this.inServiceException = false;
            }
        }
    }

    @Override
    public Response service(Command command) {
        MDC.put((String)"activemq.connector", (String)this.connector.getUri().toString());
        Response response = null;
        boolean responseRequired = command.isResponseRequired();
        int commandId = command.getCommandId();
        try {
            response = !this.pendingStop ? command.visit(this) : new ExceptionResponse(this.stopError);
        }
        catch (Throwable e) {
            if (SERVICELOG.isDebugEnabled() && e.getClass() != BrokerStoppedException.class) {
                SERVICELOG.debug("Error occured while processing " + (responseRequired ? "sync" : "async") + " command: " + command + ", exception: " + e, e);
            }
            if (e instanceof SuppressReplyException || e.getCause() instanceof SuppressReplyException) {
                LOG.info("Suppressing reply to: " + command + " on: " + e + ", cause: " + e.getCause());
                responseRequired = false;
            }
            if (responseRequired) {
                response = new ExceptionResponse(e);
            }
            this.serviceException(e);
        }
        if (responseRequired) {
            if (response == null) {
                response = new Response();
            }
            response.setCorrelationId(commandId);
        }
        if (this.context != null) {
            if (this.context.isDontSendReponse()) {
                this.context.setDontSendReponse(false);
                response = null;
            }
            this.context = null;
        }
        MDC.remove((String)"activemq.connector");
        return response;
    }

    @Override
    public Response processKeepAlive(KeepAliveInfo info2) throws Exception {
        return null;
    }

    @Override
    public Response processRemoveSubscription(RemoveSubscriptionInfo info2) throws Exception {
        this.broker.removeSubscription(this.lookupConnectionState(info2.getConnectionId()).getContext(), info2);
        return null;
    }

    @Override
    public Response processWireFormat(WireFormatInfo info2) throws Exception {
        this.wireFormatInfo = info2;
        this.protocolVersion.set(info2.getVersion());
        return null;
    }

    @Override
    public Response processShutdown(ShutdownInfo info2) throws Exception {
        this.stopAsync();
        return null;
    }

    @Override
    public Response processFlush(FlushCommand command) throws Exception {
        return null;
    }

    @Override
    public Response processBeginTransaction(TransactionInfo info2) throws Exception {
        TransportConnectionState cs = this.lookupConnectionState(info2.getConnectionId());
        this.context = null;
        if (cs != null) {
            this.context = cs.getContext();
        }
        if (cs == null) {
            throw new NullPointerException("Context is null");
        }
        if (cs.getTransactionState(info2.getTransactionId()) == null) {
            cs.addTransactionState(info2.getTransactionId());
            this.broker.beginTransaction(this.context, info2.getTransactionId());
        }
        return null;
    }

    @Override
    public Response processEndTransaction(TransactionInfo info2) throws Exception {
        return null;
    }

    @Override
    public Response processPrepareTransaction(TransactionInfo info2) throws Exception {
        TransportConnectionState cs = this.lookupConnectionState(info2.getConnectionId());
        this.context = null;
        if (cs != null) {
            this.context = cs.getContext();
        }
        if (cs == null) {
            throw new NullPointerException("Context is null");
        }
        TransactionState transactionState = cs.getTransactionState(info2.getTransactionId());
        if (transactionState == null) {
            throw new IllegalStateException("Cannot prepare a transaction that had not been started or previously returned XA_RDONLY: " + info2.getTransactionId());
        }
        if (!transactionState.isPrepared()) {
            transactionState.setPrepared(true);
            int result = this.broker.prepareTransaction(this.context, info2.getTransactionId());
            transactionState.setPreparedResult(result);
            if (result == 3) {
                cs.removeTransactionState(info2.getTransactionId());
            }
            IntegerResponse response = new IntegerResponse(result);
            return response;
        }
        IntegerResponse response = new IntegerResponse(transactionState.getPreparedResult());
        return response;
    }

    @Override
    public Response processCommitTransactionOnePhase(TransactionInfo info2) throws Exception {
        TransportConnectionState cs = this.lookupConnectionState(info2.getConnectionId());
        this.context = cs.getContext();
        cs.removeTransactionState(info2.getTransactionId());
        this.broker.commitTransaction(this.context, info2.getTransactionId(), true);
        return null;
    }

    @Override
    public Response processCommitTransactionTwoPhase(TransactionInfo info2) throws Exception {
        TransportConnectionState cs = this.lookupConnectionState(info2.getConnectionId());
        this.context = cs.getContext();
        cs.removeTransactionState(info2.getTransactionId());
        this.broker.commitTransaction(this.context, info2.getTransactionId(), false);
        return null;
    }

    @Override
    public Response processRollbackTransaction(TransactionInfo info2) throws Exception {
        TransportConnectionState cs = this.lookupConnectionState(info2.getConnectionId());
        this.context = cs.getContext();
        cs.removeTransactionState(info2.getTransactionId());
        this.broker.rollbackTransaction(this.context, info2.getTransactionId());
        return null;
    }

    @Override
    public Response processForgetTransaction(TransactionInfo info2) throws Exception {
        TransportConnectionState cs = this.lookupConnectionState(info2.getConnectionId());
        this.context = cs.getContext();
        this.broker.forgetTransaction(this.context, info2.getTransactionId());
        return null;
    }

    @Override
    public Response processRecoverTransactions(TransactionInfo info2) throws Exception {
        TransportConnectionState cs = this.lookupConnectionState(info2.getConnectionId());
        this.context = cs.getContext();
        DataStructure[] preparedTransactions = this.broker.getPreparedTransactions(this.context);
        return new DataArrayResponse(preparedTransactions);
    }

    @Override
    public Response processMessage(Message messageSend) throws Exception {
        ProducerId producerId = messageSend.getProducerId();
        ProducerBrokerExchange producerExchange = this.getProducerBrokerExchange(producerId);
        if (producerExchange.canDispatch(messageSend)) {
            this.broker.send(producerExchange, messageSend);
        }
        return null;
    }

    @Override
    public Response processMessageAck(MessageAck ack) throws Exception {
        ConsumerBrokerExchange consumerExchange = this.getConsumerBrokerExchange(ack.getConsumerId());
        if (consumerExchange != null) {
            this.broker.acknowledge(consumerExchange, ack);
        }
        return null;
    }

    @Override
    public Response processMessagePull(MessagePull pull) throws Exception {
        return this.broker.messagePull(this.lookupConnectionState(pull.getConsumerId()).getContext(), pull);
    }

    @Override
    public Response processMessageDispatchNotification(MessageDispatchNotification notification) throws Exception {
        this.broker.processDispatchNotification(notification);
        return null;
    }

    @Override
    public Response processAddDestination(DestinationInfo info2) throws Exception {
        TransportConnectionState cs = this.lookupConnectionState(info2.getConnectionId());
        this.broker.addDestinationInfo(cs.getContext(), info2);
        if (info2.getDestination().isTemporary()) {
            cs.addTempDestination(info2);
        }
        return null;
    }

    @Override
    public Response processRemoveDestination(DestinationInfo info2) throws Exception {
        TransportConnectionState cs = this.lookupConnectionState(info2.getConnectionId());
        this.broker.removeDestinationInfo(cs.getContext(), info2);
        if (info2.getDestination().isTemporary()) {
            cs.removeTempDestination(info2.getDestination());
        }
        return null;
    }

    @Override
    public Response processAddProducer(ProducerInfo info2) throws Exception {
        SessionId sessionId = info2.getProducerId().getParentId();
        ConnectionId connectionId = sessionId.getParentId();
        TransportConnectionState cs = this.lookupConnectionState(connectionId);
        if (cs == null) {
            throw new IllegalStateException("Cannot add a producer to a connection that had not been registered: " + connectionId);
        }
        SessionState ss = cs.getSessionState(sessionId);
        if (ss == null) {
            throw new IllegalStateException("Cannot add a producer to a session that had not been registered: " + sessionId);
        }
        if (!ss.getProducerIds().contains(info2.getProducerId())) {
            ActiveMQDestination destination = info2.getDestination();
            if (destination != null && !AdvisorySupport.isAdvisoryTopic(destination) && this.getProducerCount(connectionId) >= this.connector.getMaximumProducersAllowedPerConnection()) {
                throw new IllegalStateException("Can't add producer on connection " + connectionId + ": at maximum limit: " + this.connector.getMaximumProducersAllowedPerConnection());
            }
            this.broker.addProducer(cs.getContext(), info2);
            try {
                ss.addProducer(info2);
            }
            catch (IllegalStateException e) {
                this.broker.removeProducer(cs.getContext(), info2);
            }
        }
        return null;
    }

    @Override
    public Response processRemoveProducer(ProducerId id) throws Exception {
        SessionId sessionId = id.getParentId();
        ConnectionId connectionId = sessionId.getParentId();
        TransportConnectionState cs = this.lookupConnectionState(connectionId);
        SessionState ss = cs.getSessionState(sessionId);
        if (ss == null) {
            throw new IllegalStateException("Cannot remove a producer from a session that had not been registered: " + sessionId);
        }
        ProducerState ps = ss.removeProducer(id);
        if (ps == null) {
            throw new IllegalStateException("Cannot remove a producer that had not been registered: " + id);
        }
        this.removeProducerBrokerExchange(id);
        this.broker.removeProducer(cs.getContext(), ps.getInfo());
        return null;
    }

    @Override
    public Response processAddConsumer(ConsumerInfo info2) throws Exception {
        SessionId sessionId = info2.getConsumerId().getParentId();
        ConnectionId connectionId = sessionId.getParentId();
        TransportConnectionState cs = this.lookupConnectionState(connectionId);
        if (cs == null) {
            throw new IllegalStateException("Cannot add a consumer to a connection that had not been registered: " + connectionId);
        }
        SessionState ss = cs.getSessionState(sessionId);
        if (ss == null) {
            throw new IllegalStateException(this.broker.getBrokerName() + " Cannot add a consumer to a session that had not been registered: " + sessionId);
        }
        if (!ss.getConsumerIds().contains(info2.getConsumerId())) {
            ActiveMQDestination destination = info2.getDestination();
            if (destination != null && !AdvisorySupport.isAdvisoryTopic(destination) && this.getConsumerCount(connectionId) >= this.connector.getMaximumConsumersAllowedPerConnection()) {
                throw new IllegalStateException("Can't add consumer on connection " + connectionId + ": at maximum limit: " + this.connector.getMaximumConsumersAllowedPerConnection());
            }
            this.broker.addConsumer(cs.getContext(), info2);
            try {
                ss.addConsumer(info2);
                this.addConsumerBrokerExchange(info2.getConsumerId());
            }
            catch (IllegalStateException e) {
                this.broker.removeConsumer(cs.getContext(), info2);
            }
        }
        return null;
    }

    @Override
    public Response processRemoveConsumer(ConsumerId id, long lastDeliveredSequenceId) throws Exception {
        SessionId sessionId = id.getParentId();
        ConnectionId connectionId = sessionId.getParentId();
        TransportConnectionState cs = this.lookupConnectionState(connectionId);
        if (cs == null) {
            throw new IllegalStateException("Cannot remove a consumer from a connection that had not been registered: " + connectionId);
        }
        SessionState ss = cs.getSessionState(sessionId);
        if (ss == null) {
            throw new IllegalStateException("Cannot remove a consumer from a session that had not been registered: " + sessionId);
        }
        ConsumerState consumerState = ss.removeConsumer(id);
        if (consumerState == null) {
            throw new IllegalStateException("Cannot remove a consumer that had not been registered: " + id);
        }
        ConsumerInfo info2 = consumerState.getInfo();
        info2.setLastDeliveredSequenceId(lastDeliveredSequenceId);
        this.broker.removeConsumer(cs.getContext(), consumerState.getInfo());
        this.removeConsumerBrokerExchange(id);
        return null;
    }

    @Override
    public Response processAddSession(SessionInfo info2) throws Exception {
        ConnectionId connectionId = info2.getSessionId().getParentId();
        TransportConnectionState cs = this.lookupConnectionState(connectionId);
        if (cs != null && !cs.getSessionIds().contains(info2.getSessionId())) {
            this.broker.addSession(cs.getContext(), info2);
            try {
                cs.addSession(info2);
            }
            catch (IllegalStateException e) {
                e.printStackTrace();
                this.broker.removeSession(cs.getContext(), info2);
            }
        }
        return null;
    }

    @Override
    public Response processRemoveSession(SessionId id, long lastDeliveredSequenceId) throws Exception {
        ConnectionId connectionId = id.getParentId();
        TransportConnectionState cs = this.lookupConnectionState(connectionId);
        if (cs == null) {
            throw new IllegalStateException("Cannot remove session from connection that had not been registered: " + connectionId);
        }
        SessionState session = cs.getSessionState(id);
        if (session == null) {
            throw new IllegalStateException("Cannot remove session that had not been registered: " + id);
        }
        session.shutdown();
        for (ConsumerId consumerId : session.getConsumerIds()) {
            try {
                this.processRemoveConsumer(consumerId, lastDeliveredSequenceId);
            }
            catch (Throwable e) {
                LOG.warn("Failed to remove consumer: " + consumerId + ". Reason: " + e, e);
            }
        }
        for (ProducerId producerId : session.getProducerIds()) {
            try {
                this.processRemoveProducer(producerId);
            }
            catch (Throwable e) {
                LOG.warn("Failed to remove producer: " + producerId + ". Reason: " + e, e);
            }
        }
        cs.removeSession(id);
        this.broker.removeSession(cs.getContext(), session.getInfo());
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Response processAddConnection(ConnectionInfo info2) throws Exception {
        TransportConnectionState state;
        if (this.wireFormatInfo != null && this.wireFormatInfo.getVersion() <= 2) {
            info2.setClientMaster(true);
        }
        Object object = this.brokerConnectionStates;
        synchronized (object) {
            state = (TransportConnectionState)this.brokerConnectionStates.get(info2.getConnectionId());
            if (state == null) {
                state = new TransportConnectionState(info2, this);
                this.brokerConnectionStates.put(info2.getConnectionId(), state);
            }
            state.incrementReference();
        }
        object = state.getConnectionMutex();
        synchronized (object) {
            if (state.getConnection() != this) {
                LOG.debug("Killing previous stale connection: " + state.getConnection().getRemoteAddress());
                state.getConnection().stop();
                LOG.debug("Connection " + this.getRemoteAddress() + " taking over previous connection: " + state.getConnection().getRemoteAddress());
                state.setConnection(this);
                state.reset(info2);
            }
        }
        this.registerConnectionState(info2.getConnectionId(), state);
        LOG.debug("Setting up new connection id: " + info2.getConnectionId() + ", address: " + this.getRemoteAddress() + ", info: " + info2);
        this.faultTolerantConnection = info2.isFaultTolerant();
        String clientId = info2.getClientId();
        this.context = new ConnectionContext();
        this.context.setBroker(this.broker);
        this.context.setClientId(clientId);
        this.context.setClientMaster(info2.isClientMaster());
        this.context.setConnection(this);
        this.context.setConnectionId(info2.getConnectionId());
        this.context.setConnector(this.connector);
        this.context.setMessageAuthorizationPolicy(this.getMessageAuthorizationPolicy());
        this.context.setNetworkConnection(this.networkConnection);
        this.context.setFaultTolerant(this.faultTolerantConnection);
        this.context.setTransactions(new ConcurrentHashMap<TransactionId, Transaction>());
        this.context.setUserName(info2.getUserName());
        this.context.setWireFormatInfo(this.wireFormatInfo);
        this.context.setReconnect(info2.isFailoverReconnect());
        this.manageable = info2.isManageable();
        this.context.setConnectionState(state);
        state.setContext(this.context);
        state.setConnection(this);
        if (info2.getClientIp() == null) {
            info2.setClientIp(this.getRemoteAddress());
        }
        try {
            this.broker.addConnection(this.context, info2);
        }
        catch (Exception e) {
            Map<ConnectionId, ConnectionState> map2 = this.brokerConnectionStates;
            synchronized (map2) {
                this.brokerConnectionStates.remove(info2.getConnectionId());
            }
            this.unregisterConnectionState(info2.getConnectionId());
            LOG.warn("Failed to add Connection " + info2.getConnectionId() + ", reason: " + e.toString());
            if (LOG.isDebugEnabled()) {
                LOG.debug("Exception detail:", (Throwable)e);
            }
            if (e instanceof SecurityException) {
                this.delayedStop(2000, "Failed with SecurityException: " + e.getLocalizedMessage(), e);
            }
            throw e;
        }
        if (info2.isManageable()) {
            ConnectionControl command = this.connector.getConnectionControl();
            command.setFaultTolerant(this.broker.isFaultTolerantConfiguration());
            if (info2.isFailoverReconnect()) {
                command.setRebalanceConnection(false);
            }
            this.dispatchAsync(command);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized Response processRemoveConnection(ConnectionId id, long lastDeliveredSequenceId) throws InterruptedException {
        LOG.debug("remove connection id: " + id);
        TransportConnectionState cs = this.lookupConnectionState(id);
        if (cs != null) {
            block14: {
                cs.shutdown();
                for (SessionId sessionId : cs.getSessionIds()) {
                    try {
                        this.processRemoveSession(sessionId, lastDeliveredSequenceId);
                    }
                    catch (Throwable e) {
                        SERVICELOG.warn("Failed to remove session " + sessionId, e);
                    }
                }
                Iterator<DestinationInfo> iter = cs.getTempDestinations().iterator();
                while (iter.hasNext()) {
                    DestinationInfo di = iter.next();
                    try {
                        this.broker.removeDestination(cs.getContext(), di.getDestination(), 0L);
                    }
                    catch (Throwable e) {
                        SERVICELOG.warn("Failed to remove tmp destination " + di.getDestination(), e);
                    }
                    iter.remove();
                }
                try {
                    this.broker.removeConnection(cs.getContext(), cs.getInfo(), null);
                }
                catch (Throwable e) {
                    SERVICELOG.warn("Failed to remove connection " + cs.getInfo() + ", reason: " + e.toString());
                    if (!LOG.isDebugEnabled()) break block14;
                    SERVICELOG.debug("Exception detail:", e);
                }
            }
            TransportConnectionState state = this.unregisterConnectionState(id);
            if (state != null) {
                Map<ConnectionId, ConnectionState> map2 = this.brokerConnectionStates;
                synchronized (map2) {
                    if (state.decrementReference() == 0) {
                        this.brokerConnectionStates.remove(id);
                    }
                }
            }
        }
        return null;
    }

    @Override
    public Response processProducerAck(ProducerAck ack) throws Exception {
        return null;
    }

    @Override
    public Connector getConnector() {
        return this.connector;
    }

    @Override
    public void dispatchSync(Command message) {
        try {
            this.processDispatch(message);
        }
        catch (IOException e) {
            this.serviceExceptionAsync(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dispatchAsync(Command message) {
        if (!this.stopping.get()) {
            if (this.taskRunner == null) {
                this.dispatchSync(message);
            } else {
                List<Command> list = this.dispatchQueue;
                synchronized (list) {
                    this.dispatchQueue.add(message);
                }
                try {
                    this.taskRunner.wakeup();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }
        } else if (message.isMessageDispatch()) {
            MessageDispatch md = (MessageDispatch)message;
            TransmitCallback sub = md.getTransmitCallback();
            this.broker.postProcessDispatch(md);
            if (sub != null) {
                sub.onFailure();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processDispatch(Command command) throws IOException {
        MessageDispatch messageDispatch = (MessageDispatch)(command.isMessageDispatch() ? command : null);
        try {
            if (!this.stopping.get()) {
                if (messageDispatch != null) {
                    this.broker.preProcessDispatch(messageDispatch);
                }
                this.dispatch(command);
            }
        }
        catch (IOException e) {
            if (messageDispatch != null) {
                TransmitCallback sub = messageDispatch.getTransmitCallback();
                this.broker.postProcessDispatch(messageDispatch);
                if (sub != null) {
                    sub.onFailure();
                }
                messageDispatch = null;
                throw e;
            }
        }
        finally {
            if (messageDispatch != null) {
                TransmitCallback sub = messageDispatch.getTransmitCallback();
                this.broker.postProcessDispatch(messageDispatch);
                if (sub != null) {
                    sub.onSuccess();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean iterate() {
        try {
            if (this.pendingStop || this.stopping.get()) {
                if (this.dispatchStopped.compareAndSet(false, true)) {
                    if (this.transportException.get() == null) {
                        try {
                            this.dispatch(new ShutdownInfo());
                        }
                        catch (Throwable ignore) {
                            // empty catch block
                        }
                    }
                    this.dispatchStoppedLatch.countDown();
                }
                return false;
            }
            if (!this.dispatchStopped.get()) {
                Command command = null;
                List<Command> list = this.dispatchQueue;
                synchronized (list) {
                    if (this.dispatchQueue.isEmpty()) {
                        return false;
                    }
                    command = this.dispatchQueue.remove(0);
                }
                this.processDispatch(command);
                return true;
            }
            return false;
        }
        catch (IOException e) {
            if (this.dispatchStopped.compareAndSet(false, true)) {
                this.dispatchStoppedLatch.countDown();
            }
            this.serviceExceptionAsync(e);
            return false;
        }
    }

    @Override
    public ConnectionStatistics getStatistics() {
        return this.statistics;
    }

    public MessageAuthorizationPolicy getMessageAuthorizationPolicy() {
        return this.messageAuthorizationPolicy;
    }

    public void setMessageAuthorizationPolicy(MessageAuthorizationPolicy messageAuthorizationPolicy) {
        this.messageAuthorizationPolicy = messageAuthorizationPolicy;
    }

    @Override
    public boolean isManageable() {
        return this.manageable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start() throws Exception {
        try {
            TransportConnection transportConnection = this;
            synchronized (transportConnection) {
                this.starting = true;
                this.taskRunner = this.taskRunnerFactory != null ? this.taskRunnerFactory.createTaskRunner(this, "ActiveMQ Connection Dispatcher: " + this.getRemoteAddress()) : null;
                this.transport.start();
                this.active = true;
                BrokerInfo info2 = this.connector.getBrokerInfo().copy();
                if (this.connector.isUpdateClusterClients()) {
                    info2.setPeerBrokerInfos(this.broker.getPeerBrokerInfos());
                } else {
                    info2.setPeerBrokerInfos(null);
                }
                this.dispatchAsync(info2);
                this.connector.onStarted(this);
            }
        }
        catch (Exception e) {
            this.pendingStop = true;
            throw e;
        }
        finally {
            this.setStarting(false);
            if (this.isPendingStop()) {
                LOG.debug("Calling the delayed stop() after start() " + this);
                this.stop();
            }
        }
    }

    @Override
    public void stop() throws Exception {
        this.stopAsync();
        while (!this.stopped.await(5L, TimeUnit.SECONDS)) {
            LOG.info("The connection to '" + this.transport.getRemoteAddress() + "' is taking a long time to shutdown.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delayedStop(final int waitTime, final String reason, Throwable cause) {
        if (waitTime > 0) {
            TransportConnection transportConnection = this;
            synchronized (transportConnection) {
                this.pendingStop = true;
                this.stopError = cause;
            }
            try {
                this.stopTaskRunnerFactory.execute(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            Thread.sleep(waitTime);
                            TransportConnection.this.stopAsync();
                            LOG.info("Stopping " + TransportConnection.this.transport.getRemoteAddress() + " because " + reason);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                });
            }
            catch (Throwable t) {
                LOG.warn("Cannot create stopAsync. This exception will be ignored.", t);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopAsync() {
        TransportConnection transportConnection = this;
        synchronized (transportConnection) {
            this.pendingStop = true;
            if (this.starting) {
                LOG.debug("stopAsync() called in the middle of start(). Delaying till start completes..");
                return;
            }
        }
        if (this.stopping.compareAndSet(false, true)) {
            List<TransportConnectionState> connectionStates = this.listConnectionStates();
            for (TransportConnectionState cs : connectionStates) {
                ConnectionContext connectionContext = cs.getContext();
                if (connectionContext == null) continue;
                connectionContext.getStopping().set(true);
            }
            try {
                this.stopTaskRunnerFactory.execute(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        TransportConnection.this.serviceLock.writeLock().lock();
                        try {
                            TransportConnection.this.doStop();
                        }
                        catch (Throwable e) {
                            LOG.debug("Error occurred while shutting down a connection " + this, e);
                        }
                        finally {
                            TransportConnection.this.stopped.countDown();
                            TransportConnection.this.serviceLock.writeLock().unlock();
                        }
                    }
                });
            }
            catch (Throwable t) {
                LOG.warn("Cannot create async transport stopper thread. This exception is ignored. Not waiting for stop to complete", t);
                this.stopped.countDown();
            }
        }
    }

    public String toString() {
        return "Transport Connection to: " + this.transport.getRemoteAddress();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doStop() throws Exception {
        LOG.debug("Stopping connection: {}", (Object)this.transport.getRemoteAddress());
        this.connector.onStopped(this);
        try {
            TransportConnection transportConnection = this;
            synchronized (transportConnection) {
                if (this.duplexBridge != null) {
                    this.duplexBridge.stop();
                }
            }
        }
        catch (Exception ignore) {
            LOG.trace("Exception caught stopping. This exception is ignored.", (Throwable)ignore);
        }
        try {
            this.transport.stop();
            LOG.debug("Stopped transport: " + this.transport.getRemoteAddress());
        }
        catch (Exception e) {
            LOG.debug("Could not stop transport to " + this.transport.getRemoteAddress() + ". This exception is ignored.", (Throwable)e);
        }
        if (this.taskRunner != null) {
            this.taskRunner.shutdown(1L);
            this.taskRunner = null;
        }
        this.active = false;
        List<Command> e = this.dispatchQueue;
        synchronized (e) {
            for (Command command : this.dispatchQueue) {
                if (!command.isMessageDispatch()) continue;
                MessageDispatch md = (MessageDispatch)command;
                TransmitCallback sub = md.getTransmitCallback();
                this.broker.postProcessDispatch(md);
                if (sub == null) continue;
                sub.onFailure();
            }
            this.dispatchQueue.clear();
        }
        if (!this.broker.isStopped()) {
            List<TransportConnectionState> connectionStates = this.listConnectionStates();
            connectionStates = this.listConnectionStates();
            for (TransportConnectionState cs : connectionStates) {
                cs.getContext().getStopping().set(true);
                try {
                    LOG.debug("Cleaning up connection resources: {}", (Object)this.getRemoteAddress());
                    this.processRemoveConnection(cs.getInfo().getConnectionId(), 0L);
                }
                catch (Throwable ignore) {
                    ignore.printStackTrace();
                }
            }
        }
        LOG.debug("Connection Stopped: {}", (Object)this.getRemoteAddress());
    }

    public boolean isBlockedCandidate() {
        return this.blockedCandidate;
    }

    public void setBlockedCandidate(boolean blockedCandidate) {
        this.blockedCandidate = blockedCandidate;
    }

    public boolean isMarkedCandidate() {
        return this.markedCandidate;
    }

    public void setMarkedCandidate(boolean markedCandidate) {
        this.markedCandidate = markedCandidate;
        if (!markedCandidate) {
            this.timeStamp = 0L;
            this.blockedCandidate = false;
        }
    }

    public void setSlow(boolean slow) {
        this.slow = slow;
    }

    @Override
    public boolean isSlow() {
        return this.slow;
    }

    public boolean isMarkedBlockedCandidate() {
        return this.markedCandidate;
    }

    public void doMark() {
        if (this.timeStamp == 0L) {
            this.timeStamp = System.currentTimeMillis();
        }
    }

    @Override
    public boolean isBlocked() {
        return this.blocked;
    }

    @Override
    public boolean isConnected() {
        return this.connected;
    }

    public void setBlocked(boolean blocked) {
        this.blocked = blocked;
    }

    public void setConnected(boolean connected) {
        this.connected = connected;
    }

    @Override
    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    public synchronized boolean isStarting() {
        return this.starting;
    }

    @Override
    public synchronized boolean isNetworkConnection() {
        return this.networkConnection;
    }

    @Override
    public boolean isFaultTolerantConnection() {
        return this.faultTolerantConnection;
    }

    protected synchronized void setStarting(boolean starting) {
        this.starting = starting;
    }

    public synchronized boolean isPendingStop() {
        return this.pendingStop;
    }

    protected synchronized void setPendingStop(boolean pendingStop) {
        this.pendingStop = pendingStop;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Response processBrokerInfo(BrokerInfo info2) {
        if (info2.isSlaveBroker()) {
            LOG.error(" Slave Brokers are no longer supported - slave trying to attach is: " + info2.getBrokerName());
        } else if (info2.isNetworkConnection() && info2.isDuplexConnection()) {
            try {
                String duplexName;
                CopyOnWriteArrayList<TransportConnection> connections;
                Properties properties = MarshallingSupport.stringToProperties(info2.getNetworkProperties());
                HashMap<String, String> props = this.createMap(properties);
                NetworkBridgeConfiguration config = new NetworkBridgeConfiguration();
                IntrospectionSupport.setProperties(config, props, "");
                config.setBrokerName(this.broker.getBrokerName());
                String duplexNetworkConnectorId = config.getName() + "@" + info2.getBrokerId();
                CopyOnWriteArrayList<TransportConnection> copyOnWriteArrayList = connections = this.connector.getConnections();
                synchronized (copyOnWriteArrayList) {
                    for (TransportConnection c : connections) {
                        if (c == this || !duplexNetworkConnectorId.equals(c.getDuplexNetworkConnectorId())) continue;
                        LOG.warn("Stopping an existing active duplex connection [" + c + "] for network connector (" + duplexNetworkConnectorId + ").");
                        c.stopAsync();
                        c.getStopped().await(1L, TimeUnit.SECONDS);
                    }
                    this.setDuplexNetworkConnectorId(duplexNetworkConnectorId);
                }
                Transport localTransport = NetworkBridgeFactory.createLocalTransport(this.broker);
                Transport remoteBridgeTransport = this.transport;
                if (!(remoteBridgeTransport instanceof ResponseCorrelator)) {
                    remoteBridgeTransport = new ResponseCorrelator(remoteBridgeTransport);
                }
                if ((duplexName = localTransport.toString()).contains("#")) {
                    duplexName = duplexName.substring(duplexName.lastIndexOf("#"));
                }
                MBeanNetworkListener listener = new MBeanNetworkListener(this.broker.getBrokerService(), this.broker.getBrokerService().createDuplexNetworkConnectorObjectName(duplexName));
                listener.setCreatedByDuplex(true);
                this.duplexBridge = NetworkBridgeFactory.createBridge(config, localTransport, remoteBridgeTransport, listener);
                this.duplexBridge.setBrokerService(this.broker.getBrokerService());
                info2.setDuplexConnection(false);
                this.duplexBridge.setCreatedByDuplex(true);
                this.duplexBridge.duplexStart(this, this.brokerInfo, info2);
                LOG.info("Started responder end of duplex bridge " + duplexNetworkConnectorId);
                return null;
            }
            catch (TransportDisposedIOException e) {
                LOG.warn("Duplex bridge " + this.duplexNetworkConnectorId + " was stopped before it was correctly started.");
                return null;
            }
            catch (Exception e) {
                LOG.error("Failed to create responder end of duplex network bridge " + this.duplexNetworkConnectorId, (Throwable)e);
                return null;
            }
        }
        if (this.brokerInfo != null) {
            LOG.warn("Unexpected extra broker info command received: " + info2);
        }
        this.brokerInfo = info2;
        this.networkConnection = true;
        List<TransportConnectionState> connectionStates = this.listConnectionStates();
        for (TransportConnectionState cs : connectionStates) {
            cs.getContext().setNetworkConnection(true);
        }
        return null;
    }

    private HashMap<String, String> createMap(Properties properties) {
        return new HashMap<Object, Object>(properties);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void dispatch(Command command) throws IOException {
        try {
            this.setMarkedCandidate(true);
            this.transport.oneway(command);
        }
        finally {
            this.setMarkedCandidate(false);
        }
    }

    @Override
    public String getRemoteAddress() {
        return this.transport.getRemoteAddress();
    }

    @Override
    public String getConnectionId() {
        List<TransportConnectionState> connectionStates = this.listConnectionStates();
        Iterator<TransportConnectionState> i$ = connectionStates.iterator();
        if (i$.hasNext()) {
            TransportConnectionState cs = i$.next();
            if (cs.getInfo().getClientId() != null) {
                return cs.getInfo().getClientId();
            }
            return cs.getInfo().getConnectionId().toString();
        }
        return null;
    }

    @Override
    public void updateClient(ConnectionControl control) {
        if (this.isActive() && !this.isBlocked() && this.isFaultTolerantConnection() && this.wireFormatInfo != null && this.wireFormatInfo.getVersion() >= 6) {
            this.dispatchAsync(control);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ProducerBrokerExchange getProducerBrokerExchange(ProducerId id) throws IOException {
        ProducerBrokerExchange result = this.producerExchanges.get(id);
        if (result == null) {
            Map<ProducerId, ProducerBrokerExchange> map2 = this.producerExchanges;
            synchronized (map2) {
                SessionState ss;
                result = new ProducerBrokerExchange();
                TransportConnectionState state = this.lookupConnectionState(id);
                this.context = state.getContext();
                result.setConnectionContext(this.context);
                if (this.context.isReconnect() || this.context.isNetworkConnection() && this.connector.isAuditNetworkProducers()) {
                    result.setLastStoredSequenceId(this.broker.getBrokerService().getPersistenceAdapter().getLastProducerSequenceId(id));
                }
                if ((ss = state.getSessionState(id.getParentId())) != null) {
                    result.setProducerState(ss.getProducerState(id));
                    ProducerState producerState = ss.getProducerState(id);
                    if (producerState != null && producerState.getInfo() != null) {
                        ProducerInfo info2 = producerState.getInfo();
                        result.setMutable(info2.getDestination() == null || info2.getDestination().isComposite());
                    }
                }
                this.producerExchanges.put(id, result);
            }
        } else {
            this.context = result.getConnectionContext();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeProducerBrokerExchange(ProducerId id) {
        Map<ProducerId, ProducerBrokerExchange> map2 = this.producerExchanges;
        synchronized (map2) {
            this.producerExchanges.remove(id);
        }
    }

    private ConsumerBrokerExchange getConsumerBrokerExchange(ConsumerId id) {
        ConsumerBrokerExchange result = this.consumerExchanges.get(id);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ConsumerBrokerExchange addConsumerBrokerExchange(ConsumerId id) {
        ConsumerBrokerExchange result = this.consumerExchanges.get(id);
        if (result == null) {
            Map<ConsumerId, ConsumerBrokerExchange> map2 = this.consumerExchanges;
            synchronized (map2) {
                ConsumerInfo info2;
                ConsumerState cs;
                result = new ConsumerBrokerExchange();
                TransportConnectionState state = this.lookupConnectionState(id);
                this.context = state.getContext();
                result.setConnectionContext(this.context);
                SessionState ss = state.getSessionState(id.getParentId());
                if (ss != null && (cs = ss.getConsumerState(id)) != null && (info2 = cs.getInfo()) != null && info2.getDestination() != null && info2.getDestination().isPattern()) {
                    result.setWildcard(true);
                }
                this.consumerExchanges.put(id, result);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeConsumerBrokerExchange(ConsumerId id) {
        Map<ConsumerId, ConsumerBrokerExchange> map2 = this.consumerExchanges;
        synchronized (map2) {
            this.consumerExchanges.remove(id);
        }
    }

    public int getProtocolVersion() {
        return this.protocolVersion.get();
    }

    @Override
    public Response processControlCommand(ControlCommand command) throws Exception {
        String control = command.getCommand();
        if (control != null && control.equals("shutdown")) {
            System.exit(0);
        }
        return null;
    }

    @Override
    public Response processMessageDispatch(MessageDispatch dispatch) throws Exception {
        return null;
    }

    @Override
    public Response processConnectionControl(ConnectionControl control) throws Exception {
        if (control != null) {
            this.faultTolerantConnection = control.isFaultTolerant();
        }
        return null;
    }

    @Override
    public Response processConnectionError(ConnectionError error2) throws Exception {
        return null;
    }

    @Override
    public Response processConsumerControl(ConsumerControl control) throws Exception {
        ConsumerBrokerExchange consumerExchange = this.getConsumerBrokerExchange(control.getConsumerId());
        this.broker.processConsumerControl(consumerExchange, control);
        return null;
    }

    protected synchronized TransportConnectionState registerConnectionState(ConnectionId connectionId, TransportConnectionState state) {
        TransportConnectionState cs = null;
        if (!this.connectionStateRegister.isEmpty() && !this.connectionStateRegister.doesHandleMultipleConnectionStates()) {
            MapTransportConnectionStateRegister newRegister = new MapTransportConnectionStateRegister();
            newRegister.intialize(this.connectionStateRegister);
            this.connectionStateRegister = newRegister;
        }
        cs = this.connectionStateRegister.registerConnectionState(connectionId, state);
        return cs;
    }

    protected synchronized TransportConnectionState unregisterConnectionState(ConnectionId connectionId) {
        return this.connectionStateRegister.unregisterConnectionState(connectionId);
    }

    protected synchronized List<TransportConnectionState> listConnectionStates() {
        return this.connectionStateRegister.listConnectionStates();
    }

    protected synchronized TransportConnectionState lookupConnectionState(String connectionId) {
        return this.connectionStateRegister.lookupConnectionState(connectionId);
    }

    protected synchronized TransportConnectionState lookupConnectionState(ConsumerId id) {
        return this.connectionStateRegister.lookupConnectionState(id);
    }

    protected synchronized TransportConnectionState lookupConnectionState(ProducerId id) {
        return this.connectionStateRegister.lookupConnectionState(id);
    }

    protected synchronized TransportConnectionState lookupConnectionState(SessionId id) {
        return this.connectionStateRegister.lookupConnectionState(id);
    }

    public synchronized TransportConnectionState lookupConnectionState(ConnectionId connectionId) {
        return this.connectionStateRegister.lookupConnectionState(connectionId);
    }

    protected synchronized void setDuplexNetworkConnectorId(String duplexNetworkConnectorId) {
        this.duplexNetworkConnectorId = duplexNetworkConnectorId;
    }

    protected synchronized String getDuplexNetworkConnectorId() {
        return this.duplexNetworkConnectorId;
    }

    public boolean isStopping() {
        return this.stopping.get();
    }

    protected CountDownLatch getStopped() {
        return this.stopped;
    }

    private int getProducerCount(ConnectionId connectionId) {
        int result = 0;
        TransportConnectionState cs = this.lookupConnectionState(connectionId);
        if (cs != null) {
            for (SessionId sessionId : cs.getSessionIds()) {
                SessionState sessionState = cs.getSessionState(sessionId);
                if (sessionState == null) continue;
                result += sessionState.getProducerIds().size();
            }
        }
        return result;
    }

    private int getConsumerCount(ConnectionId connectionId) {
        int result = 0;
        TransportConnectionState cs = this.lookupConnectionState(connectionId);
        if (cs != null) {
            for (SessionId sessionId : cs.getSessionIds()) {
                SessionState sessionState = cs.getSessionState(sessionId);
                if (sessionState == null) continue;
                result += sessionState.getConsumerIds().size();
            }
        }
        return result;
    }
}

