/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.openwire.v8;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.activemq.command.ActiveMQDestination;
import org.apache.activemq.command.BrokerId;
import org.apache.activemq.command.ConsumerId;
import org.apache.activemq.command.ConsumerInfo;
import org.apache.activemq.command.DataStructure;
import org.apache.activemq.filter.BooleanExpression;
import org.apache.activemq.openwire.BooleanStream;
import org.apache.activemq.openwire.OpenWireFormat;
import org.apache.activemq.openwire.v8.BaseCommandMarshaller;

public class ConsumerInfoMarshaller
extends BaseCommandMarshaller {
    @Override
    public byte getDataStructureType() {
        return 5;
    }

    @Override
    public DataStructure createObject() {
        return new ConsumerInfo();
    }

    @Override
    public void tightUnmarshal(OpenWireFormat wireFormat, Object o, DataInput dataIn, BooleanStream bs) throws IOException {
        int i;
        DataStructure[] value;
        int size2;
        super.tightUnmarshal(wireFormat, o, dataIn, bs);
        ConsumerInfo info2 = (ConsumerInfo)o;
        info2.setConsumerId((ConsumerId)this.tightUnmarsalCachedObject(wireFormat, dataIn, bs));
        info2.setBrowser(bs.readBoolean());
        info2.setDestination((ActiveMQDestination)this.tightUnmarsalCachedObject(wireFormat, dataIn, bs));
        info2.setPrefetchSize(dataIn.readInt());
        info2.setMaximumPendingMessageLimit(dataIn.readInt());
        info2.setDispatchAsync(bs.readBoolean());
        info2.setSelector(this.tightUnmarshalString(dataIn, bs));
        info2.setSubscriptionName(this.tightUnmarshalString(dataIn, bs));
        info2.setNoLocal(bs.readBoolean());
        info2.setExclusive(bs.readBoolean());
        info2.setRetroactive(bs.readBoolean());
        info2.setPriority(dataIn.readByte());
        if (bs.readBoolean()) {
            size2 = dataIn.readShort();
            value = new BrokerId[size2];
            for (i = 0; i < size2; ++i) {
                value[i] = (BrokerId)this.tightUnmarsalNestedObject(wireFormat, dataIn, bs);
            }
            info2.setBrokerPath((BrokerId[])value);
        } else {
            info2.setBrokerPath(null);
        }
        info2.setAdditionalPredicate((BooleanExpression)((Object)this.tightUnmarsalNestedObject(wireFormat, dataIn, bs)));
        info2.setNetworkSubscription(bs.readBoolean());
        info2.setOptimizedAcknowledge(bs.readBoolean());
        info2.setNoRangeAcks(bs.readBoolean());
        if (bs.readBoolean()) {
            size2 = dataIn.readShort();
            value = new ConsumerId[size2];
            for (i = 0; i < size2; ++i) {
                value[i] = (ConsumerId)this.tightUnmarsalNestedObject(wireFormat, dataIn, bs);
            }
            info2.setNetworkConsumerPath((ConsumerId[])value);
        } else {
            info2.setNetworkConsumerPath(null);
        }
    }

    @Override
    public int tightMarshal1(OpenWireFormat wireFormat, Object o, BooleanStream bs) throws IOException {
        ConsumerInfo info2 = (ConsumerInfo)o;
        int rc = super.tightMarshal1(wireFormat, o, bs);
        rc += this.tightMarshalCachedObject1(wireFormat, info2.getConsumerId(), bs);
        bs.writeBoolean(info2.isBrowser());
        rc += this.tightMarshalCachedObject1(wireFormat, info2.getDestination(), bs);
        bs.writeBoolean(info2.isDispatchAsync());
        rc += this.tightMarshalString1(info2.getSelector(), bs);
        rc += this.tightMarshalString1(info2.getSubscriptionName(), bs);
        bs.writeBoolean(info2.isNoLocal());
        bs.writeBoolean(info2.isExclusive());
        bs.writeBoolean(info2.isRetroactive());
        rc += this.tightMarshalObjectArray1(wireFormat, info2.getBrokerPath(), bs);
        rc += this.tightMarshalNestedObject1(wireFormat, (DataStructure)((Object)info2.getAdditionalPredicate()), bs);
        bs.writeBoolean(info2.isNetworkSubscription());
        bs.writeBoolean(info2.isOptimizedAcknowledge());
        bs.writeBoolean(info2.isNoRangeAcks());
        return (rc += this.tightMarshalObjectArray1(wireFormat, info2.getNetworkConsumerPath(), bs)) + 9;
    }

    @Override
    public void tightMarshal2(OpenWireFormat wireFormat, Object o, DataOutput dataOut, BooleanStream bs) throws IOException {
        super.tightMarshal2(wireFormat, o, dataOut, bs);
        ConsumerInfo info2 = (ConsumerInfo)o;
        this.tightMarshalCachedObject2(wireFormat, info2.getConsumerId(), dataOut, bs);
        bs.readBoolean();
        this.tightMarshalCachedObject2(wireFormat, info2.getDestination(), dataOut, bs);
        dataOut.writeInt(info2.getPrefetchSize());
        dataOut.writeInt(info2.getMaximumPendingMessageLimit());
        bs.readBoolean();
        this.tightMarshalString2(info2.getSelector(), dataOut, bs);
        this.tightMarshalString2(info2.getSubscriptionName(), dataOut, bs);
        bs.readBoolean();
        bs.readBoolean();
        bs.readBoolean();
        dataOut.writeByte(info2.getPriority());
        this.tightMarshalObjectArray2(wireFormat, info2.getBrokerPath(), dataOut, bs);
        this.tightMarshalNestedObject2(wireFormat, (DataStructure)((Object)info2.getAdditionalPredicate()), dataOut, bs);
        bs.readBoolean();
        bs.readBoolean();
        bs.readBoolean();
        this.tightMarshalObjectArray2(wireFormat, info2.getNetworkConsumerPath(), dataOut, bs);
    }

    @Override
    public void looseUnmarshal(OpenWireFormat wireFormat, Object o, DataInput dataIn) throws IOException {
        int i;
        DataStructure[] value;
        int size2;
        super.looseUnmarshal(wireFormat, o, dataIn);
        ConsumerInfo info2 = (ConsumerInfo)o;
        info2.setConsumerId((ConsumerId)this.looseUnmarsalCachedObject(wireFormat, dataIn));
        info2.setBrowser(dataIn.readBoolean());
        info2.setDestination((ActiveMQDestination)this.looseUnmarsalCachedObject(wireFormat, dataIn));
        info2.setPrefetchSize(dataIn.readInt());
        info2.setMaximumPendingMessageLimit(dataIn.readInt());
        info2.setDispatchAsync(dataIn.readBoolean());
        info2.setSelector(this.looseUnmarshalString(dataIn));
        info2.setSubscriptionName(this.looseUnmarshalString(dataIn));
        info2.setNoLocal(dataIn.readBoolean());
        info2.setExclusive(dataIn.readBoolean());
        info2.setRetroactive(dataIn.readBoolean());
        info2.setPriority(dataIn.readByte());
        if (dataIn.readBoolean()) {
            size2 = dataIn.readShort();
            value = new BrokerId[size2];
            for (i = 0; i < size2; ++i) {
                value[i] = (BrokerId)this.looseUnmarsalNestedObject(wireFormat, dataIn);
            }
            info2.setBrokerPath((BrokerId[])value);
        } else {
            info2.setBrokerPath(null);
        }
        info2.setAdditionalPredicate((BooleanExpression)((Object)this.looseUnmarsalNestedObject(wireFormat, dataIn)));
        info2.setNetworkSubscription(dataIn.readBoolean());
        info2.setOptimizedAcknowledge(dataIn.readBoolean());
        info2.setNoRangeAcks(dataIn.readBoolean());
        if (dataIn.readBoolean()) {
            size2 = dataIn.readShort();
            value = new ConsumerId[size2];
            for (i = 0; i < size2; ++i) {
                value[i] = (ConsumerId)this.looseUnmarsalNestedObject(wireFormat, dataIn);
            }
            info2.setNetworkConsumerPath((ConsumerId[])value);
        } else {
            info2.setNetworkConsumerPath(null);
        }
    }

    @Override
    public void looseMarshal(OpenWireFormat wireFormat, Object o, DataOutput dataOut) throws IOException {
        ConsumerInfo info2 = (ConsumerInfo)o;
        super.looseMarshal(wireFormat, o, dataOut);
        this.looseMarshalCachedObject(wireFormat, info2.getConsumerId(), dataOut);
        dataOut.writeBoolean(info2.isBrowser());
        this.looseMarshalCachedObject(wireFormat, info2.getDestination(), dataOut);
        dataOut.writeInt(info2.getPrefetchSize());
        dataOut.writeInt(info2.getMaximumPendingMessageLimit());
        dataOut.writeBoolean(info2.isDispatchAsync());
        this.looseMarshalString(info2.getSelector(), dataOut);
        this.looseMarshalString(info2.getSubscriptionName(), dataOut);
        dataOut.writeBoolean(info2.isNoLocal());
        dataOut.writeBoolean(info2.isExclusive());
        dataOut.writeBoolean(info2.isRetroactive());
        dataOut.writeByte(info2.getPriority());
        this.looseMarshalObjectArray(wireFormat, info2.getBrokerPath(), dataOut);
        this.looseMarshalNestedObject(wireFormat, (DataStructure)((Object)info2.getAdditionalPredicate()), dataOut);
        dataOut.writeBoolean(info2.isNetworkSubscription());
        dataOut.writeBoolean(info2.isOptimizedAcknowledge());
        dataOut.writeBoolean(info2.isNoRangeAcks());
        this.looseMarshalObjectArray(wireFormat, info2.getNetworkConsumerPath(), dataOut);
    }
}

