/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.pool;

import java.io.IOException;
import javax.jms.ConnectionFactory;
import javax.jms.JMSException;
import javax.transaction.SystemException;
import javax.transaction.TransactionManager;
import javax.transaction.xa.XAResource;
import org.apache.activemq.ActiveMQConnection;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.ActiveMQSession;
import org.apache.activemq.util.IOExceptionSupport;
import org.apache.geronimo.transaction.manager.NamedXAResource;
import org.apache.geronimo.transaction.manager.NamedXAResourceFactory;
import org.apache.geronimo.transaction.manager.RecoverableTransactionManager;
import org.apache.geronimo.transaction.manager.WrapperNamedXAResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ActiveMQResourceManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(ActiveMQResourceManager.class);
    private String resourceName;
    private TransactionManager transactionManager;
    private ConnectionFactory connectionFactory;

    public void recoverResource() {
        try {
            if (!Recovery.recover(this)) {
                LOGGER.info("Resource manager is unrecoverable");
            }
        }
        catch (NoClassDefFoundError e) {
            LOGGER.info("Resource manager is unrecoverable due to missing classes: " + e);
        }
        catch (Throwable e) {
            LOGGER.warn("Error while recovering resource manager", e);
        }
    }

    public String getResourceName() {
        return this.resourceName;
    }

    public void setResourceName(String resourceName) {
        this.resourceName = resourceName;
    }

    public TransactionManager getTransactionManager() {
        return this.transactionManager;
    }

    public void setTransactionManager(TransactionManager transactionManager) {
        this.transactionManager = transactionManager;
    }

    public ConnectionFactory getConnectionFactory() {
        return this.connectionFactory;
    }

    public void setConnectionFactory(ConnectionFactory connectionFactory) {
        this.connectionFactory = connectionFactory;
    }

    public static class ConnectionAndWrapperNamedXAResource
    extends WrapperNamedXAResource {
        final ActiveMQConnection connection;

        public ConnectionAndWrapperNamedXAResource(XAResource xaResource, String name, ActiveMQConnection connection) {
            super(xaResource, name);
            this.connection = connection;
        }
    }

    public static class Recovery {
        public static boolean isRecoverable(ActiveMQResourceManager rm) {
            return rm.getConnectionFactory() instanceof ActiveMQConnectionFactory && rm.getTransactionManager() instanceof RecoverableTransactionManager && rm.getResourceName() != null && !"".equals(rm.getResourceName());
        }

        public static boolean recover(final ActiveMQResourceManager rm) throws IOException {
            if (Recovery.isRecoverable(rm)) {
                try {
                    final ActiveMQConnectionFactory connFactory = (ActiveMQConnectionFactory)rm.getConnectionFactory();
                    ActiveMQConnection activeConn = (ActiveMQConnection)connFactory.createConnection();
                    ActiveMQSession session = (ActiveMQSession)activeConn.createSession(true, 0);
                    WrapperNamedXAResource namedXaResource = new WrapperNamedXAResource((XAResource)session.getTransactionContext(), rm.getResourceName());
                    RecoverableTransactionManager rtxManager = (RecoverableTransactionManager)rm.getTransactionManager();
                    rtxManager.registerNamedXAResourceFactory(new NamedXAResourceFactory(){

                        public String getName() {
                            return rm.getResourceName();
                        }

                        public NamedXAResource getNamedXAResource() throws SystemException {
                            try {
                                ActiveMQConnection activeConn = (ActiveMQConnection)connFactory.createConnection();
                                ActiveMQSession session = (ActiveMQSession)activeConn.createSession(true, 0);
                                activeConn.start();
                                LOGGER.debug("new namedXAResource's connection: " + activeConn);
                                return new ConnectionAndWrapperNamedXAResource(session.getTransactionContext(), this.getName(), activeConn);
                            }
                            catch (Exception e) {
                                SystemException se = new SystemException("Failed to create ConnectionAndWrapperNamedXAResource, " + e.getLocalizedMessage());
                                se.initCause((Throwable)e);
                                LOGGER.error(se.getLocalizedMessage(), (Throwable)se);
                                throw se;
                            }
                        }

                        public void returnNamedXAResource(NamedXAResource namedXaResource) {
                            if (namedXaResource instanceof ConnectionAndWrapperNamedXAResource) {
                                try {
                                    LOGGER.debug("closing returned namedXAResource's connection: " + ((ConnectionAndWrapperNamedXAResource)namedXaResource).connection);
                                    ((ConnectionAndWrapperNamedXAResource)namedXaResource).connection.close();
                                }
                                catch (Exception ignored) {
                                    LOGGER.debug("failed to close returned namedXAResource: " + namedXaResource, (Throwable)ignored);
                                }
                            }
                        }
                    });
                    return true;
                }
                catch (JMSException e) {
                    throw IOExceptionSupport.create((Exception)((Object)e));
                }
            }
            return false;
        }
    }
}

