/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.hawtdispatch.transport;

import java.net.InetSocketAddress;
import java.util.LinkedList;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicInteger;
import org.fusesource.hawtdispatch.CustomDispatchSource;
import org.fusesource.hawtdispatch.Dispatch;
import org.fusesource.hawtdispatch.DispatchQueue;
import org.fusesource.hawtdispatch.EventAggregators;
import org.fusesource.hawtdispatch.Task;
import org.fusesource.hawtdispatch.TaskWrapper;
import org.fusesource.hawtdispatch.transport.PipeTransport;
import org.fusesource.hawtdispatch.transport.PipeTransportRegistry;
import org.fusesource.hawtdispatch.transport.TransportServer;
import org.fusesource.hawtdispatch.transport.TransportServerListener;

public class PipeTransportServer
implements TransportServer {
    protected String connectURI;
    protected TransportServerListener listener;
    protected String name;
    protected boolean marshal;
    protected final AtomicInteger connectionCounter = new AtomicInteger();
    DispatchQueue dispatchQueue;
    private CustomDispatchSource<PipeTransport, LinkedList<PipeTransport>> acceptSource;

    public String getBoundAddress() {
        return this.connectURI;
    }

    public InetSocketAddress getSocketAddress() {
        return null;
    }

    public DispatchQueue getDispatchQueue() {
        return this.dispatchQueue;
    }

    public void setDispatchQueue(DispatchQueue queue) {
        this.dispatchQueue = queue;
    }

    public void suspend() {
        this.acceptSource.suspend();
    }

    public void resume() {
        this.acceptSource.resume();
    }

    public void setTransportServerListener(TransportServerListener listener) {
        this.listener = listener;
    }

    @Deprecated
    public void start(Runnable onCompleted2) throws Exception {
        this.start(new TaskWrapper(onCompleted2));
    }

    @Deprecated
    public void stop(Runnable onCompleted2) throws Exception {
        this.stop(new TaskWrapper(onCompleted2));
    }

    public void start(Task onCompleted2) throws Exception {
        this.acceptSource = Dispatch.createSource(EventAggregators.linkedList(), this.dispatchQueue);
        this.acceptSource.setEventHandler(new Task(){

            public void run() {
                LinkedList transports = (LinkedList)PipeTransportServer.this.acceptSource.getData();
                for (PipeTransport transport : transports) {
                    try {
                        PipeTransportServer.this.listener.onAccept(transport);
                    }
                    catch (Exception e) {
                        PipeTransportServer.this.listener.onAcceptError(e);
                    }
                }
            }
        });
        this.acceptSource.resume();
        if (onCompleted2 != null) {
            this.dispatchQueue.execute(onCompleted2);
        }
    }

    public void stop(Task onCompleted2) throws Exception {
        PipeTransportRegistry.unbind(this);
        this.acceptSource.setCancelHandler(onCompleted2);
        this.acceptSource.cancel();
    }

    public void setConnectURI(String connectURI) {
        this.connectURI = connectURI;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public PipeTransport connect() {
        PipeTransport serverTransport;
        int connectionId = this.connectionCounter.incrementAndGet();
        String remoteAddress = this.connectURI.toString() + "#" + connectionId;
        assert (this.listener != null) : "Server does not have an accept listener";
        PipeTransport clientTransport = this.createClientTransport();
        clientTransport.peer = serverTransport = this.createServerTransport();
        serverTransport.peer = clientTransport;
        clientTransport.setRemoteAddress(remoteAddress);
        serverTransport.setRemoteAddress(remoteAddress);
        serverTransport.setMarshal(this.marshal);
        this.acceptSource.merge(serverTransport);
        return clientTransport;
    }

    protected PipeTransport createClientTransport() {
        return new PipeTransport(this);
    }

    protected PipeTransport createServerTransport() {
        return new PipeTransport(this);
    }

    public boolean isMarshal() {
        return this.marshal;
    }

    public void setMarshal(boolean marshal) {
        this.marshal = marshal;
    }

    public Executor getBlockingExecutor() {
        return null;
    }

    public void setBlockingExecutor(Executor blockingExecutor) {
    }
}

