/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.direct;

import org.apache.camel.AsyncCallback;
import org.apache.camel.AsyncProcessor;
import org.apache.camel.Exchange;
import org.apache.camel.component.direct.DirectConsumerNotAvailableException;
import org.apache.camel.component.direct.DirectEndpoint;
import org.apache.camel.impl.DefaultAsyncProducer;
import org.apache.camel.util.AsyncProcessorConverterHelper;
import org.apache.camel.util.AsyncProcessorHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DirectProducer
extends DefaultAsyncProducer {
    private static final transient Logger LOG = LoggerFactory.getLogger(DirectProducer.class);
    private final DirectEndpoint endpoint;

    public DirectProducer(DirectEndpoint endpoint) {
        super(endpoint);
        this.endpoint = endpoint;
    }

    @Override
    public void process(Exchange exchange) throws Exception {
        if (this.endpoint.getConsumer() == null) {
            LOG.warn("No consumers available on endpoint: " + this.endpoint + " to process: " + exchange);
            throw new DirectConsumerNotAvailableException("No consumers available on endpoint: " + this.endpoint, exchange);
        }
        this.endpoint.getConsumer().getProcessor().process(exchange);
    }

    @Override
    public boolean process(Exchange exchange, AsyncCallback callback) {
        if (this.endpoint.getConsumer() == null) {
            LOG.warn("No consumers available on endpoint: " + this.endpoint + " to process: " + exchange);
            exchange.setException(new DirectConsumerNotAvailableException("No consumers available on endpoint: " + this.endpoint, exchange));
            callback.done(true);
            return true;
        }
        AsyncProcessor processor = AsyncProcessorConverterHelper.convert(this.endpoint.getConsumer().getProcessor());
        return AsyncProcessorHelper.process(processor, exchange, callback);
    }
}

